/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2007, 2008, 2009, 2010  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2010-06-30 07:54:24 -0600 (Wed, 30 Jun 2010) $
--   $Revision: 4661 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

/* This program adds spellings to the public objects. */


#include <ctype.h>
#include <stdio.h>

#include "objectify.h"


int main(int argc, char* argv[])
{
    int i;
    int j;
    ObjRef ref;
    char spelling[64];
    char msg[128];
    char buffer[1024];

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);


    while (fgets(buffer, sizeof(buffer), stdin) != NULL)
    {
	i = 0;

	while (buffer[i] != '\0')
	{
	    while (isspace(buffer[i])) i++;

	    j = 0;

	    while (buffer[i] != '\0' && !isspace(buffer[i]))
	    {
		if (j < sizeof(spelling) - 1)
		{
		    spelling[j++] = buffer[i++];
		}
		else if (j == sizeof(spelling) - 1)
		{
		    spelling[j++] = '\0';
		    fprintf(stderr, "WARNING: spelling %s%c", spelling, buffer[i++]);
		}
		else
		{
		    fprintf(stderr, "%c", buffer[i++]);
		}
	    }

	    if (0 < j && j < sizeof(spelling))
	    {
		spelling[j] = '\0';

		for (j = 0; spelling[j] != '\0'; j++)
		{
		    if (!isalpha(spelling[j]))
		    {
			fprintf(stderr, "WARNING: spelling %s contains invalid character '%c', ignored\n", spelling, spelling[j]);
			break;
		    }

		    spelling[j] = tolower(spelling[j]);
		}

		if (spelling[j] == '\0')
		{
		    if (nwos_find_public_spelling(spelling, &ref))
		    {
			fprintf(stderr, "WARNING: spelling %s already exists\n", spelling);
		    }
		    else
		    {
			snprintf(msg, sizeof(msg), "Creating spelling: %s", spelling);
			nwos_log(msg);
			printf("%s\n", msg);
		    }

		    nwos_create_public_spelling(spelling, &ref);
		}
	    }
	    else if (j == sizeof(spelling))
	    {
		fprintf(stderr, " is too long, ignored\n");
	    }
	}
    }

    if (ferror(stdin))
    {
	perror("reading stdin");
    }

    nwos_terminate_objectify();

    return 0;
}

