--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.14  2006/11/11 12:29:18  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.13  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.12  2006/02/18 16:46:49  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning the object.
--
-- Revision 1.11  2006/02/18 15:37:06  jsedwards
-- Changed name of "storage" in NWOS_STRING class to "to_string" so it makes
-- more sense in the clients.
--
-- Revision 1.10  2006/02/11 18:25:47  jsedwards
-- Changed reference "load" call to "get_object".
--
-- Revision 1.9  2006/02/11 04:49:17  jsedwards
-- Filled in read_body_from_string feature.
--
-- Revision 1.8  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.7  2006/02/10 04:58:26  jsedwards
-- Added "load" to creation list.
--
-- Revision 1.6  2006/02/10 01:42:45  jsedwards
-- Changed "app_revision" to just "revision" and fixed cvs Revision tag.
--
-- Revision 1.5  2006/02/09 14:06:40  jsedwards
-- Changed to new application format where the application doesn't inherit
-- from "application", but just creates it.  That way there isn't a difficulty
-- when reloading an application object, because application objects aren't
-- deferred.
--
-- Revision 1.4  2006/02/05 03:22:23  jsedwards
-- Added "session logs" and changed to new format.
--
-- Revision 1.3  2006/02/04 15:02:26  jsedwards
-- Changed to new way of having deferred class_definition.  Also changed to
-- store the count correctly.
--
-- Revision 1.2  2006/01/31 19:29:36  jsedwards
-- Moved the kludgy class stuff to the end of the file instead of the
-- beginning, to be consistent with the other classes.
--
-- Revision 1.1  2006/01/31 14:12:25  jsedwards
-- Initial version.
--


class NWOS_APPLICATION

inherit NWOS_OBJECT

creation make, make_unresolved


feature -- data variables

   name: STRING is
      do
         load_if_not_already
         Result := name_obj.to_string
      ensure
         Result /= Void
      end

   revision: STRING is
      do
         load_if_not_already
         Result := revision_obj.to_string
      ensure
         Result /= Void
      end

   session_logs: ARRAY[NWOS_SESSION_LOG] is
      do
         load_if_not_already
         Result := logs_obj
      ensure
         Result /= Void
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         name_obj.write_to_stream(stream)
         revision_obj.write_to_stream(stream)

         from
            i := logs_obj.lower
         variant
            logs_obj.upper - i
         until
            i > logs_obj.upper
         loop
            logs_obj.item(i).class_definition.identifier.write_to_stream(stream)
            logs_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         sess_log: NWOS_SESSION_LOG
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!name_obj.read_from_stream(stream)
         !!revision_obj.read_from_stream(stream)

std_output.put_string("NWOS_APPLICATION.read_body_from_stream")
std_output.put_string("%N  name: ")
std_output.put_string(name_obj.to_string)
std_output.put_string("%N  revision: ")
std_output.put_string(revision_obj.to_string)
std_output.put_new_line

         !!logs_obj.with_capacity(2, 1)  -- this will need to be fixed to handle multiple invocations of the same program

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_APPLICATION.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            sess_log ?= object_ref.get_object(class_ref)
            check
               sess_log /= Void
            end
            logs_obj.add_last(sess_log)

            !!class_ref.make_from_stream(stream)
         end
      end


   set_grade(obj_grade: like grade) is
      do
         reference := obj_grade
      end


   make(app_name, app_rev: STRING) is
      do
         !!name_obj.copy_from_string(app_name)
         !!revision_obj.copy_from_string(app_rev)

--         !!grade.make("One of the original base objects created in the initial Big Bang!", log)
                  -- in the real world the server will have to create this object

         initialize_header(Big_bang_ref)

         !!logs_obj.with_capacity(1, 1)  -- this will need to be fixed to handle multiple invocations of the same program

         logs_obj.add_last(log)  -- add the log for this session to the logs
      end


feature {NONE}  -- actual storage

   name_obj: NWOS_STRING

   revision_obj: NWOS_STRING

   logs_obj: ARRAY[NWOS_SESSION_LOG]


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 4384 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_application_ref
      end

end

