/*
--          This file is part of the New World OS and Objectify projects
--                        Copyright (C) 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
--  Program to repair .dif file with zeros in upper bytes of reference in
--  blocks.
--
*/


#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>    /* define sleep() */

#include "../disk_io.h"


uint32 convert_4_uint8_to_uint32(uint8 byte[4])
{
  return ((uint32)byte[0] << 24) | ((uint32)byte[1] << 16) | ((uint32)byte[2] << 8) | (uint32)byte[3];
}


int main(int argc, char* argv[])
{
    FILE* fp1;
    FILE* fp2;
    size_t read1;
    size_t write2;
    uint8 block[FILE_BLOCK_SIZE];
    size_t num_blocks = 0;


    if (argc != 3)
    {
	fprintf(stderr, "usage: %s in_file out_file\n", argv[0]);
	exit(1);
    }


    /* Open the file and check it */

    fp1 = fopen(argv[1], "r");
    if (fp1 == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    /* Open the output file and check it */

    fp2 = fopen(argv[2], "w");
    if (fp2 == NULL)
    {
	perror(argv[2]);
	fclose(fp1);
	exit(2);
    }


    read1 = fread(block, 1, FILE_BLOCK_SIZE, fp1);

    while (!feof(fp1) && read1 == FILE_BLOCK_SIZE)
    {
	if (num_blocks < 2)
	{
	    if (block[0] != 'N' || block[1] != 'W' || block[2]  != 'O' || block[3]  != 'S' ||
		block[4] != '0' || block[5] != '0' || block[6]  != '3' || block[7]  != '0' ||
		block[8] != 'd' || block[9] != 'i' || block[10] != 'f' || block[11] != 'f')
	    {	
		fprintf(stderr, "Not a NWOS 0030 diff file\n");
		exit(1);
	    }
	}
	else
	{
	    if (block[0] != 0 || block[1] != 0 || block[2] != 0 || block[3]  != 0)
	    {
		fprintf(stderr, "Block: %d upper bytes non-zero: %02x%02x%02x%02x\n", num_blocks, block[0], block[0], block[2], block[3]);
		exit(1);
	    }

	    block[0] = 0xff;
	    block[1] = 0xff;
	    block[2] = 0xff;
	    block[3] = 0xfe;
	}

	num_blocks++;

	write2 = fwrite(block, 1, FILE_BLOCK_SIZE, fp2);

	if (write2 != FILE_BLOCK_SIZE)
	{
	    perror(argv[2]);
	    exit(1);
	}

	read1 = fread(block, 1, FILE_BLOCK_SIZE, fp1);
    }

    if (!feof(fp1) || ferror(fp1))
    {
	perror(argv[1]);
	exit(1);
    }

    printf("file size - blocks: %d\n", num_blocks);

    fclose(fp1);

    if (fclose(fp2) != 0)
    {
	perror(argv[2]);
	exit(1);
    }

    return 0;
}
