/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  This file was originally the
--   c_structs.h file and I have left the CVS log from that file below.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.6  2006/10/31 13:48:37  jsedwards
-- Changed nick_name to nickname (nickname is in the dictionary).
--
-- Revision 1.5  2006/10/29 17:27:23  jsedwards
-- Removed the 4 "chicken and egg" classes so they can be created directly in
-- the program.
--
-- Revision 1.4  2006/10/29 14:36:21  jsedwards
-- Changed street end points around to eliminate _a and _b which would make
-- for weird behavior from converting to strings.
--
-- Revision 1.3  2006/10/28 13:51:30  jsedwards
-- Fixed up the types of a few features in various classes.
--
-- Revision 1.2  2006/10/27 13:17:04  jsedwards
-- Removed some classes (structs) that could be problematic for now.
--
-- Revision 1.1  2006/10/27 12:53:38  jsedwards
-- Check in copy of file in root directory.
--
-- Revision 1.9  2006/10/26 01:14:19  jsedwards
-- Replaced main truck version (1.8) with version from alpha_05_branch.
--
-- Revision 1.8  2006/01/23 19:22:05  jsedwards
-- Split "Letter" class into "Vowel", "Consonant", and "Vowel or Consonant"
-- classes.
--
-- Revision 1.7  2006/01/23 14:14:48  jsedwards
-- Added identifier and rating to AnyObject header.
--
-- Revision 1.6  2006/01/23 03:40:41  jsedwards
-- Added next character stuff to letter structure.
--
-- Revision 1.5  2006/01/22 20:45:49  jsedwards
-- Added stuff for letters and english language.
--
-- Revision 1.4  2006/01/22 18:12:20  jsedwards
-- Added name and description to character set structure.  Changed letter
-- object to character object.
--
-- Revision 1.3  2006/01/22 17:17:38  jsedwards
-- Added stuff for ascii character set.
--
-- Revision 1.2  2006/01/22 15:10:17  jsedwards
-- Changed binary_codes structure to have the reference list expanded inline.
-- Added includes for objectify header files.
--
-- Revision 1.1  2006/01/21 18:23:39  jsedwards
-- This file should be generated from the objects, but for now I'm saving this
-- version in CVS.
--
*/



typedef struct {
    EveryObject header;
    uint8       md5sum[16];
} C_struct_MD5sum;


typedef struct {
    EveryObject header;
    ObjRef      class_definition_class;
    ObjRef      reference_list_class;
} C_struct_Root;


typedef struct {
    EveryObject header;
    ObjRef      thing;
    ObjRef      language;
    ObjRef      spelling;
} C_struct_Word;


typedef struct {
    EveryObject header;
    ObjRef      full_word;
    ObjRef      language;
    ObjRef      spelling;
} C_struct_Abbreviation;


typedef struct {         /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
} C_struct_Language;


typedef struct {
    EveryObject header;
    ObjRef      contact;   /* entity this goes to */
    uint8       count;
    char        storage[0];
} C_struct_Email_Address;


typedef struct {
    EveryObject header;
    ObjRef      name;
    ObjRef      date;
    ObjRef      capital;
    ObjRef      postal_code;
    ObjRef      number;
} C_struct_US_State;


typedef struct {               /* need inheritence for this to inherit from a general city */
    EveryObject header;
    ObjRef      name;
    ObjRef      state;
    ObjRef      country;
} C_struct_US_City;


typedef struct {
    EveryObject header;
    ObjRef      state;
    ObjRef      area;
    char        storage[3];
} C_struct_Area_Code;


typedef struct {
    EveryObject header;
    ObjRef      country;
    ObjRef      area_code;
    char        storage[7];
} C_struct_Phone_Number;


typedef struct {
    EveryObject header;
    ObjRef      residence;   /* entity this goes to */
    ObjRef      number;
} C_struct_Home_Phone;


typedef struct {
    EveryObject header;
    ObjRef      person;     /* entity this goes to */
    ObjRef      number;
} C_struct_Mobile_Phone;


typedef struct {
    EveryObject header;
    ObjRef      business;
    ObjRef      person;     /* entity this goes to */
    ObjRef      number;
    ObjRef      extension;
} C_struct_Work_Phone;


typedef struct {
    EveryObject header;
    ObjRef      number;
} C_struct_Year;


typedef struct {         /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
    ObjRef      number;  /* note: names should be found from references for different languages */
    uint8       minimum_days;
    uint8       maximum_days;
} C_struct_Month;


typedef struct {
    EveryObject header;
    ObjRef      year;
    ObjRef      month_and_day;
} C_struct_Date;


typedef struct {
    EveryObject header;
    ObjRef      month;
    ObjRef      day;
    ObjRef      day_of_year;
    ObjRef      day_of_leap_year;
} C_struct_Month_And_Day;


typedef struct {         /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
} C_struct_Gender;


typedef struct {
    EveryObject header;
    ObjRef      gender;
    ObjRef      title;        /* Dr. etc */
    ObjRef      first_name;
    ObjRef      middle_name;
    ObjRef      last_name;
    ObjRef      maiden_name;
    ObjRef      preferred_name;
    ObjRef      goes_by;
    ObjRef      nickname;
    ObjRef      birth_date;
    ObjRef      birth_place;
    ObjRef      death_date;
    ObjRef      death_place;
    ObjRef      height;
    ObjRef      mailing_address;
} C_struct_Person;


typedef struct {
    EveryObject header;
    ObjRef      person;
    char        storage[9];
} C_struct_Social_Security_Number;


typedef struct {
    EveryObject header;
    ObjRef      person;
    ObjRef      residence;
    ObjRef      from_date;
    ObjRef      until_date;
} C_struct_Residence;


typedef struct {
    EveryObject header;
    ObjRef      address;
} C_struct_House;


typedef struct {               /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
} C_struct_Direction;


typedef struct {               /* need inheritence for this to inherit from a general address */
    EveryObject header;
    ObjRef      number;
    ObjRef      street;        /* street should have city, state and country information */
    ObjRef      zip_code;
} C_struct_US_Address;


typedef struct {               /* need inheritence for this to inherit from a general postal code */
    EveryObject header;
    ObjRef      city;
    char        zip[5];
    char        plus[4];
} C_struct_Zip_Code;


typedef struct {
    EveryObject header;
    ObjRef      direction;     /* if street has a direction, such as East, West, North, South */
    uint8       count;
    char        storage[0];
} C_struct_Street_Number;


typedef struct {
    EveryObject header;
    ObjRef      name;
    ObjRef      suffix;           /* road, street, circle, avenue, etc. */
    ObjRef      city;
    ObjRef      coordinate;
    ObjRef      cross_street_start; /* this needs to be fixed because how do we know which end is start? lower numbers? */
    ObjRef      cross_street_end;   /* if this is void then street has no outlet */
    ObjRef      note;
} C_struct_Street;


typedef struct {
    EveryObject header;
    ObjRef      user;
    ObjRef      host;
    uint8       username_count;
    char        username[0];
    uint8       password_count;
    char        password[0];
} C_struct_Password;


typedef struct {
    EveryObject header;
    ObjRef      account;
    ObjRef      to;
    ObjRef      amount;
    ObjRef      date_written;
    ObjRef      date_mailed;
    ObjRef      date_cleared;
    ObjRef      memo;
    ObjRef      status;
} C_struct_Check;


typedef struct {
    EveryObject header;
    uint8       size[4];
    ObjRef      md5sum;
    ObjRef      sha1sum;
    ObjRef      media;
    ObjRef      block_list;
} C_struct_File;


typedef struct {
    EveryObject header;
    uint8       count;
    char        storage[0];
} C_struct_File_Path;        /* temporary kludge to identify files, for now just path name */


typedef struct {
    EveryObject header;
    char        id[12];
    ObjRef      name;
    ObjRef      note;
    uint8       count[4];
    ObjRef      files[0];
} C_struct_Disc_List;


typedef struct {
    EveryObject header;
    ObjRef      disc_list;
    ObjRef      configuration;    /* hardware / software configuration that burned disc */
    ObjRef      date;
    ObjRef      media;
    ObjRef      location;         /* where located */
    uint8       copy_number;
} C_struct_Disc_Copy;


typedef struct {
    EveryObject header;
    ObjRef      name;             /* for now it's just a name */
} C_struct_Storage_Location;


typedef struct {
    EveryObject header;
    ObjRef      path;
    ObjRef      file;
    TimeStamp   modification_time;
} C_struct_Path_And_File_Association;


typedef struct {
    EveryObject header;
    uint8       count;
    uint8       digits[0];
} C_struct_Cardinal_Number;


typedef struct {
    EveryObject header;
    ObjRef      cardinal;
} C_struct_Ordinal_Number;


typedef struct {
    EveryObject header;
    uint8       sha1sum[20];
} C_struct_SHA1sum;


