/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>    /* define sleep() */

#include "../objectify_private.h"

uint32 convert_4_uint8_to_uint32(uint8 byte[4])
{
  return ((uint32)byte[0] << 24) | ((uint32)byte[1] << 16) | ((uint32)byte[2] << 8) | (uint32)byte[3];
}


int main(int argc, char* argv[])
{
    FILE* fp1;
    FILE* fp2;
    FILE* fp3;
    uint8 buf1[FILE_BLOCK_SIZE];
    uint8 buf2[FILE_BLOCK_SIZE];
    size_t read1;
    size_t read2;
    size_t write3;
    Disk_Header header1;
    Disk_Header header2;


    if (argc != 4)
    {
	fprintf(stderr, "usage: %s public_file private_file combined_file\n", argv[0]);
	exit(1);
    }

    /*************************************/
    /* Open the public file and check it */
    /*************************************/

    fp1 = fopen(argv[1], "r");
    if (fp1 == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    read1 = fread(buf1, 1, sizeof(buf1), fp1);

    if (read1 != FILE_BLOCK_SIZE)
    {
	if (ferror(fp1))
	{
	    perror(argv[1]);
	}
	else
	{
	    fprintf(stderr, "Unexpected end of file: %s\n", argv[1]);
	}
	fclose(fp1);
	exit(1);
    }

    memcpy(&header1, buf1, sizeof(header1));

    if (memcmp(header1.magic_number, "NWOS", 4) != 0)
    {
	fprintf(stderr, "Not an Objectify file: %s\n", argv[1]);
	fclose(fp1);
	exit(1);
    }


    /**************************************/
    /* Open the private file and check it */
    /**************************************/

    fp2 = fopen(argv[2], "r");
    if (fp2 == NULL)
    {
	perror(argv[2]);
	exit(1);
    }

    read2 = fread(buf2, 1, sizeof(buf2), fp2);

    if (read2 != FILE_BLOCK_SIZE)
    {
	if (ferror(fp2))
	{
	    perror(argv[2]);
	}
	else
	{
	    fprintf(stderr, "Unexpected end of file: %s\n", argv[2]);
	}
	fclose(fp1);
	fclose(fp2);
	exit(1);
    }


    memcpy(&header2, buf2, sizeof(header2));

    if (memcmp(header2.magic_number, "NWOS", 4) != 0)
    {
	fprintf(stderr, "Not an Objectify patch file: %s\n", argv[2]);
	fclose(fp1);
	fclose(fp2);
	exit(1);
    }


    /**********************************/
    /* Verify the correct public file */
    /**********************************/

    if (memcmp(header1.used_public_blocks, header2.used_public_blocks, 4) != 0 ||
	memcmp(header1.public_last_change, header2.public_last_change, sizeof(TimeStamp)) != 0)
    {
	fprintf(stderr, "Public file does not match private file.\n");
	fclose(fp1);
	fclose(fp2);
	exit(1);
    }


    /************************/
    /* Open the output file */
    /************************/

    fp3 = fopen(argv[3], "w");

    if (fp3 == NULL)
    {
	perror(argv[3]);
	fclose(fp1);
	fclose(fp2);
	exit(1);
    }


    /******************************************/
    /* Write the header from the private file */
    /******************************************/

    write3 = fwrite(buf2, 1, sizeof(buf2), fp3);

    if (write3 != FILE_BLOCK_SIZE)
    {
	perror(argv[3]);
	fclose(fp1);
	fclose(fp2);
	fclose(fp3);
	exit(1);
    }


    /************************/
    /* Copy the public data */
    /************************/

    read1 = fread(buf1, 1, sizeof(buf1), fp1);

    while (!feof(fp1) && read1 == FILE_BLOCK_SIZE)
    {
	write3 = fwrite(buf1, 1, sizeof(buf1), fp3);

	if (write3 != FILE_BLOCK_SIZE)
	{
	    perror(argv[2]);
	    fclose(fp1);
	    fclose(fp2);
	    fclose(fp3);
	    exit(1);
	}

	read1 = fread(buf1, 1, sizeof(buf1), fp1);
    }

    if (!feof(fp1) && read1 != FILE_BLOCK_SIZE)
    {
	perror(argv[1]);
    }

    fclose(fp1);


    /*************************/
    /* Copy the private data */
    /*************************/

    read2 = fread(buf2, 1, sizeof(buf2), fp2);

    while (!feof(fp2) && read2 == FILE_BLOCK_SIZE)
    {
	write3 = fwrite(buf2, 1, sizeof(buf2), fp3);

	if (write3 != FILE_BLOCK_SIZE)
	{
	    perror(argv[2]);
	    fclose(fp2);
	    fclose(fp3);
	    exit(1);
	}

	read2 = fread(buf2, 1, sizeof(buf2), fp2);
    }

    if (!feof(fp2) && read2 != FILE_BLOCK_SIZE)
    {
	perror(argv[2]);
    }

    fclose(fp2);

    fclose(fp3);

    return 0;
}
