/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2008, 2009, 2011  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2011-05-17 18:59:39 -0600 (Tue, 17 May 2011) $
--   $Revision: 4900 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <string.h>
#include "objectify.h"

void wrapper_every_object_references(EveryObject* obj, ObjRef* ref)
{
//  printf("id: %08x  refs: %08x\n", nwos_ref_to_word(&obj->common.id), nwos_ref_to_word(&obj->object.references));
    copy_reference(ref, &obj->object.references);
}

//ObjRef* wrapper_every_object_references(EveryObject* obj)
//{
//    return &obj->object.references;
//}

int wrapper_ref_list_count(ReferenceList* ref_list)
{
    return ref_list->common_header.num_refs;
}

#include <stdio.h>

void wrapper_ref_list_item(ReferenceList* ref_list, int index, ObjRef* ref)
{
//  printf("id: %08x  ref: %08x\n", nwos_ref_to_word(&ref_list->common_header.id), nwos_ref_to_word(&ref_list->references[index]));

    copy_reference(ref, &ref_list->references[index]);
}

C_struct_Class_Definition* wrapper_read_class_definition(ObjRef* class_ref)
{
    C_struct_Class_Definition* result;

    result = nwos_malloc(sizeof(C_struct_Class_Definition));

    nwos_read_class_definition(class_ref, result);

    return result;
}

C_struct_Path_And_File_Association* wrapper_read_path_and_file_association(ObjRef* ref)
{
    C_struct_Path_And_File_Association* result;

    result = nwos_malloc(sizeof(C_struct_Path_And_File_Association));

    nwos_read_object_from_disk(ref, result, sizeof(C_struct_Path_And_File_Association));

    return result;
}

void wrapper_path_and_file_association_path(C_struct_Path_And_File_Association* obj, ObjRef* ref)
{
    copy_reference(ref, &obj->path);
}

void wrapper_path_and_file_association_file(C_struct_Path_And_File_Association* obj, ObjRef* ref)
{
    copy_reference(ref, &obj->file);
}

static size_t get_path_object_size(void* file_path_obj)
{
    assert(((C_struct_File_Path*)file_path_obj)->count > 0);

    return sizeof(C_struct_File_Path) + ((C_struct_File_Path*)file_path_obj)->count;
}


C_struct_File_Path* wrapper_read_file_path(ObjRef* ref)
{
    C_struct_File_Path* result;
    char buffer[2048];
    size_t size;

    nwos_read_variable_sized_object_from_disk(ref, buffer, sizeof(buffer), get_path_object_size);

    size = get_path_object_size(buffer);

    result = nwos_malloc(size);

    memcpy(result, buffer, size);

    return result;
}

int wrapper_file_path_count(C_struct_File_Path* obj)
{
    return obj->count;
}

char wrapper_file_path_item(C_struct_File_Path* obj, int index)
{
    return obj->storage[index];
}

int get_unix_time(void)
{
    time_t result;

    result = time(NULL);

    return (int) result;
}
