/*
--          This file is part of the New World OS and Objectify projects
--   Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2011-02-19 13:24:40 -0700 (Sat, 19 Feb 2011) $
--   $Revision: 4868 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file and the objectify.h file which
--   these declarations were taken from.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#ifndef REFERENCE_LIST_H
#define REFERENCE_LIST_H


typedef struct {
    ObjRef       class;
    uint32       capacity;
    uint32       count;
    ObjRef       references[0];
} Sorted_Reference_List;

extern Sorted_Reference_List* nwos_get_sorted_reference_list(ObjRef* list_ref, ObjRef* class_ref);
extern int nwos_find_object_in_sorted_reference_list(Sorted_Reference_List* list, ObjRef* temp_ref);

extern void nwos_create_reference_list(ObjRef* for_obj, ObjRef* ref_list);
extern void nwos_create_reference_list_with_existing_id(ObjRef* for_obj, ObjRef* ref_list);
extern void nwos_read_reference_list_from_disk(ObjRef* ref, ReferenceList* object, size_t size);

extern void nwos_add_to_references(ObjRef* ref, ObjRef* obj);
extern void nwos_add_to_reference_list(ObjRef* ref, ObjRef* ref_list);
extern void nwos_remove_from_references(ObjRef* ref, ObjRef* obj);
extern void nwos_remove_from_reference_list(ObjRef* ref, ObjRef* ref_list);

extern size_t nwos_reference_list_size(ObjRef* ref);
extern ReferenceList* nwos_malloc_reference_list(ObjRef* ref);
extern void nwos_free_reference_list(ReferenceList* ref_list);

extern void nwos_flush_dirty_ref_lists();
extern void nwos_free_ref_lists();

#endif

