/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  Since this file was originally
--   copied from the file in the root directory I have left the CVS log from
--   that file below.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.24  2006/12/01 14:31:30  jsedwards
-- Changed to use new malloc_reference_list and free_reference_list functions
-- instead of inlining the code.
--
-- Revision 1.23  2006/11/18 15:09:10  jsedwards
-- Added "max_size" parameter to read_variable_sized_object_from_disk because
-- objects are no longer limited to one file block.
--
-- Revision 1.22  2006/11/11 12:01:04  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.21  2006/10/26 01:51:27  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.20.2.3  2006/09/01 13:27:20  jsedwards
-- Changed "nwos_object_size" to "nwos_reference_list_size" and added the
-- object reference to "nwos_fill_in_common_header" so it can put the "id"
-- in the header now.
--
-- Revision 1.20.2.2  2006/08/18 12:53:48  jsedwards
-- Changed hard coded 512 for block size to FILE_BLOCK_SIZE.
--
-- Revision 1.20.2.1  2006/08/16 12:43:58  jsedwards
-- Changed to use temporary buffers to reconvert to string instead of reusing
-- the "kludge" buffer, so that new versions of GCC don't complain about the
-- signedness of pointers.
--
-- Revision 1.20  2006/01/12 02:56:27  jsedwards
-- Added code to make first letter upper case, because spellings are now
-- always stored as lower case.
--
-- Revision 1.19  2006/01/09 02:45:18  jsedwards
-- Fix bug where it tried to verify the name on objects it didn't find.  Now
-- it only reassembles the object and verifies it, if it finds it.
--
-- Revision 1.18  2006/01/04 18:53:02  jsedwards
-- Fixed bug in matching name object number of words.  It was not correctly
-- comparing the number of words, so it would match one with the wrong number
-- of words.  For example when searching for "Los Angeles" it would match up
-- with "East Los Angeles".
--
-- Revision 1.17  2006/01/04 18:37:44  jsedwards
-- Changed to allow abbreviations (such as St. for Saint) in names.
-- Changed reassembly code to just call "name to string" routine to
-- reassemble the name and then compare it to the original name.
--
-- Revision 1.16  2006/01/02 23:21:56  jsedwards
-- Moved 'ref_to_word' function to an inline function in objectify.h.
-- Changed old 'ref_to_name' calls to use 'ref_to_word' instead.
--
-- Revision 1.15  2006/01/02 21:57:54  jsedwards
-- Fixed two bugs in the finding of names.  The first was it set current_top
-- outside of the compare lists loop, so it didn't get reset back to zero
-- when we started over on list [0].  The second was that when it recomputed
-- the num_spellings after compare lists it indexed the reference list with
-- the "word" index instead of [0] which it was computing.
--
-- Revision 1.14  2006/01/02 21:48:33  jsedwards
-- Removed some of the debugging printf statements and added asserts to check
-- that the new calculated num_spellings is rational.
--
-- Revision 1.13  2006/01/02 21:35:38  jsedwards
-- Added a bunch of debug printf statements.
--
-- Revision 1.12  2005/12/29 17:50:53  jsedwards
-- Commented out printf debugging statements, that aren't useful now.
--
-- Revision 1.11  2005/12/29 17:36:08  jsedwards
-- Changes to make Name and Spelling objects variable sized.  This allows the
-- write object to disk routine to fill in the remainder of the 512 bytes with
-- random data.
--
-- Revision 1.10  2005/12/27 18:26:57  jsedwards
-- Added special routine for the "big_bang" to set the class reference.
-- Changed to look up class definition instead of using a fixed file name.
-- Also changed so that object id is random instead of based upon contents.
--
-- Revision 1.9  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.8  2005/12/21 23:23:03  jsedwards
-- Added 'find_name' and 'name_to_string' routines.
--
-- Revision 1.7  2005/12/21 03:58:00  jsedwards
-- Changed so that a name can have multiple words in it.
--
-- Revision 1.6  2005/12/11 16:32:15  jsedwards
-- Fixed error message to say "name" instead of "year".
--
-- Revision 1.5  2005/12/10 15:03:36  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.4  2005/12/05 05:22:46  jsedwards
-- Change to call read_reference_list_from_disk for reference lists instead
-- of read_object_from_disk.  Also moved calculating checksums down to just
-- before writing object, so that no changes occur after computing them.
--
-- Revision 1.3  2005/12/04 04:13:03  jsedwards
-- Added 'nwos' prefix to create_xxxx function names and eliminated the
-- 'referring' object parameter from all of them.
--
-- Revision 1.2  2005/12/04 00:39:28  jsedwards
-- Changed to use new "spelling" class to store the letters that make up the
-- name (copied the create_word class and adjusted accordingly).
--
-- Revision 1.1  2005/12/03 21:46:47  jsedwards
-- Initial version extracted from create_person.c file.
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>   /* define memset */

#include "../crc32.h"
#include "../objectify_private.h"
#include "objectify_0014.h"

#if 0
static ObjRef class_ref;

static ObjRef* name_class_ref()
{
    if (is_void_reference(&class_ref))
    {
	nwos_find_class_definition_0014("NAME", &class_ref);
    }

    assert(!is_void_reference(&class_ref));

    return &class_ref;
}


static int split_name(char* name, char words[21][20])
{
    int result = 0; 
    int i;
    char* p;

    i = 0;
    for (p = name; *p != '\0'; p++)
    {
	if (*p == ' ')
	{
	    assert(i > 0);
	    words[result][i] = '\0';
	    i = 0;
	    result++;
	}
	else
	{
	    assert(isalnum(*p) || *p == '.');   /* allow abbreviation in name */
	    assert(result <= 21);
	    assert(i <= 19);         /* leave room for null */
	    words[result][i] = *p;
	    i++;
	}
    }

    assert(i > 0);
    words[result][i] = '\0';
    result++;

    return result;
}
#endif

static size_t get_name_object_size(void* name_obj)
{
    assert(((C_struct_Name*)name_obj)->count > 0);

    return sizeof(C_struct_Name) + (((C_struct_Name*)name_obj)->count * sizeof(ObjRef));
}

#if 0
bool nwos_find_name_0014(char* name, ObjRef* ref)
{
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Name* ptr_name_obj = (C_struct_Name*)kludge;
    EveryObject spelling_header;
    ObjRef spelling_ref[21];
    ObjRef object_class;
    ReferenceList* spelling_ref_list[21];
    ObjRef* current_top;
    int num_spellings[21];
    int old_num_spellings;
    int word;
    int j;
    int k;
    bool result = true;
    int num_words;
    char words[21][20];
    char temp_name[256];

    num_words = split_name(name, words);

#ifdef DEBUG_NAME
    printf("num_words: %d\n", num_words);
    for (j = 0; j < num_words; j++)
      {
	printf("word[%d]: %s\n", j, words[j]);
      }
#endif

    assert(num_words > 0);

    for (word = 0; word < num_words; word++)
    {
	if (!nwos_find_spelling_0014(words[word], &spelling_ref[word]))
	{
#ifdef DEBUG_NAME
	    printf("did not find word: %s\n", words[word]);
#endif
	    result = false;
	    break;
	}
#ifdef DEBUG_NAME
	else
	{
	    printf("word: %s - %08lx\n", words[word], 
		   nwos_ref_to_word(&spelling_ref[word]));
	}
#endif
    }

    if (result)  /* we found all the words */
    {
#ifdef DEBUG_NAME
	printf("found all words\n");
#endif
	for (word = 0; word < num_words; word++)
	{
	    nwos_read_object_headers_from_disk_0014(&spelling_ref[word], &spelling_header);

	    spelling_ref_list[word] = nwos_malloc_reference_list_0014(&spelling_header.object.references);

	    num_spellings[word] = spelling_ref_list[word]->common_header.num_refs;

#ifdef DEBUG_NAME
	    printf("word: %s  num_spellings: %d\n", words[word], num_spellings[word]);
	    for (j = 0; j < num_spellings[word]; j++)
	    {
		printf("spelling_ref_list[%d]->references[%d]: %08lx\n", word, j, nwos_ref_to_word(&spelling_ref_list[word]->references[j]));
	    }
#endif
	}

	/* now go through each reference list and find the name objects and place them at the beginning */

	/* NOTE: We won't have to do this when the reference list is divided up by classes!! */

	for (word = 0; result && word < num_words; word++)
	{
	    current_top = &spelling_ref_list[word]->references[0];   /* create a pointer of where we want to put the good ones */

	    for (j = 0; j < num_spellings[word]; j++)
	    {
		nwos_get_object_class_0014(&spelling_ref_list[word]->references[j], &object_class);   /* find out what kind of object it is */
		if (is_same_object(&object_class, name_class_ref()))   /* it is a name object */
		{
		    /* found a name, if we have eliminated any, copy this one to the good ones */
		    if (current_top != &spelling_ref_list[word]->references[j])
		    {
			memcpy(current_top, &spelling_ref_list[word]->references[j], sizeof(ObjRef));
		    }
		    current_top++;   /* another good one */
		}
	    }

	    if (current_top != &spelling_ref_list[word]->references[j])   /* recompute how many name objects we have */
	    {
		old_num_spellings = num_spellings[word];   /* save it to make sure the new one is sane */ 
		num_spellings[word] = current_top - &spelling_ref_list[word]->references[0];
		assert(0 <= num_spellings[word] && num_spellings[word] <= old_num_spellings);
	    }

	    if (num_spellings[word] == 0)    /* no use continuing if there are no name objects for this word */
	    {
		result = false;
	    }

#ifdef DEBUG_NAME
	    printf("word: %s  num_name_refs: %d\n", words[word], num_spellings[word]);
#endif
	}

	/* Now go through what we have left and see if there is a name that has all of the words in it.  */
	/* I.E. if there aren't any common names in all of the reference lists, then there isn't a name  */
        /* that conatins all of these words and we can quit looking.  The advantage to this is then we   */
	/* don't have to actually read the objects yet, we can do this with just the reference lists.    */
	/* This can be done two lists at a time, compare two lists and eliminate all of the ones that    */
	/* aren't in both lists.  When it is finished both lists have to be identical and we no longer   */
	/* have to look at the second list and can just compare the 1st list and the 3rd list and so on. */

	for (word = 1; result && word < num_words; word++)
	{
	    current_top = &spelling_ref_list[0]->references[0];   /* create a pointer of where we want to put the good ones */

#ifdef DEBUG_NAME
	    printf("current_top: %p in the beginning\n", current_top);
#endif

	    for (j = 0; j < num_spellings[0]; j++)     /* for each reference in the first word's reference list */
	    {
		for (k = 0; k < num_spellings[word]; k++)     /* for each reference in the i'th word's reference list */
		{
#ifdef DEBUG_NAME
	    printf("word[%d]: %s - refs[%d]: %08lx - refs[%d]: %08lx\n", word, words[word],
		   j, nwos_ref_to_word(&spelling_ref_list[0]->references[j]),
		   k, nwos_ref_to_word(&spelling_ref_list[word]->references[k]));
#endif
		    if (is_same_object(&spelling_ref_list[0]->references[j], &spelling_ref_list[word]->references[k])) /* same */
		    {
			/* found a name in both lists, if we have eliminated any, copy this one to the good ones */
			if (current_top != &spelling_ref_list[0]->references[j])
			{
			    memcpy(current_top, &spelling_ref_list[0]->references[j], sizeof(ObjRef));
			}
			current_top++;   /* another one in both lists */
		    }
		}
	    }

	    if (current_top != &spelling_ref_list[0]->references[j])   /* recompute how many name objects we have */
	    {
		old_num_spellings = num_spellings[0];   /* save it to make sure the new one is sane */ 
		num_spellings[0] = current_top - &spelling_ref_list[0]->references[0];
		assert(0 <= num_spellings[0] && num_spellings[0] <= old_num_spellings);
	    }
#ifdef DEBUG_NAME
	    printf("num_spellings[0]: %d\n", num_spellings[0]);
#endif
	}

	/* We should now have a list in the first words reference list of all the names that contain all of the words. */
	/* We can now open each one of those an see if the words are in the right order. */

	result = false;   /* assume we won't find it */

	/* Note we won't go through this list at all if all of the references were eliminated in the first word */

	for (j = 0; j < num_spellings[0]; j++)
	{
	    nwos_read_variable_sized_object_from_disk_0014(&spelling_ref_list[0]->references[j], kludge, sizeof(kludge), &get_name_object_size);

	    /* remember ptr_name_obj points to the kludge buffer */

	    if (ptr_name_obj->count == num_words)    /* right number of words */
	    {
		for (word = 0; word < num_words; word++)
		{
		    if (!is_same_object(&ptr_name_obj->spelling[word], &spelling_ref[word])) break;  /* it is not the right word */
		}

		if (word == num_words)   /* found it */
		{
		    result = true;
		    memcpy(ref, &spelling_ref_list[0]->references[j], sizeof(ObjRef));
		    break;
		}
	    }
	}

	for (word = 0; word < num_words; word++)
	{
	    nwos_free_reference_list_0014(spelling_ref_list[word]);
	    spelling_ref_list[word] = NULL;
	}
    }

    if (result)  /* assemble the object to make sure it matches the original string */
    {
	nwos_name_to_string_0014(ref, temp_name, sizeof(temp_name));
	assert(strcasecmp(name, temp_name) == 0);
    }

    return result;
}
#endif

/* This is horrible - FIX THIS!! */

static size_t get_spelling_object_size(void* spelling_obj)
{
    assert(((C_struct_Spelling*)spelling_obj)->count > 0);

    return sizeof(C_struct_Spelling) + ((C_struct_Spelling*)spelling_obj)->count;
}


bool nwos_name_to_string_0014(ObjRef* ref, char* string, size_t size)
{
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Name* ptr_name_obj;
    C_struct_Spelling* ptr_spelling_obj;
    int word;
    int i;
    int j;
    size_t name_obj_size;

    /* read the name object into the kludge buffer and then after we know what size it is malloc space and copy it there */
    nwos_read_variable_sized_object_from_disk_0014(ref, kludge, sizeof(kludge), &get_name_object_size);
    ptr_name_obj = (C_struct_Name*)kludge;
    name_obj_size = sizeof(C_struct_Name) + (ptr_name_obj->count * sizeof(ObjRef));
    /* printf("name_obj_size: %d\n", name_obj_size); */
    assert(name_obj_size > sizeof(C_struct_Name));
    ptr_name_obj = malloc(name_obj_size);
    memcpy(ptr_name_obj, kludge, name_obj_size);

    ptr_spelling_obj = (C_struct_Spelling*)kludge;

    i = 0;
    for (word = 0; word < ptr_name_obj->count; word++)
    {
	assert(!is_void_reference(&ptr_name_obj->spelling[word]));
	nwos_read_variable_sized_object_from_disk_0014(&ptr_name_obj->spelling[word], kludge, sizeof(kludge), &get_spelling_object_size);

	string[i++] = toupper(ptr_spelling_obj->storage[0]);    /* first letter is upper case */

	for (j = 1; j < ptr_spelling_obj->count; j++) 
	{
	    assert(i < size);
	    string[i++] = ptr_spelling_obj->storage[j];
	}

	assert(i < size);

	if (word + 1 == ptr_name_obj->count)   /* it's the last word */
	{
	    string[i++] = '\0';
	}
	else
	{
	    string[i++] = ' ';
	}
    }

    free(ptr_name_obj);

    return true;
}

