/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: reference_list.h,v $
-- Revision 1.2  2009/03/14 22:45:10  jsedwards
-- Created with declarations taken from the disk_io.h and objectify.h files.
--
-- Revision 1.1  2009/03/13 13:27:29  jsedwards
-- Created with nwos_reference_list_size, nwos_malloc_reference_list,
-- nwos_free_reference_list, and nwos_create_reference_list_with_existing_id,
-- taken from objectify.h.
--
*/


#ifndef REFERENCE_LIST_H
#define REFERENCE_LIST_H

extern void nwos_create_reference_list(ObjRef* for_obj, ObjRef* ref_list);
extern void nwos_create_reference_list_with_existing_id(ObjRef* for_obj, ObjRef* ref_list);
extern void nwos_read_reference_list_from_disk(ObjRef* ref, ReferenceList* object, size_t size);

extern void nwos_add_to_references(ObjRef* ref, ObjRef* obj);
extern void nwos_add_to_reference_list(ObjRef* ref, ObjRef* ref_list);
extern void nwos_remove_from_references(ObjRef* ref, ObjRef* obj);
extern void nwos_remove_from_reference_list(ObjRef* ref, ObjRef* ref_list);

extern size_t nwos_reference_list_size(ObjRef* ref);
extern ReferenceList* nwos_malloc_reference_list(ObjRef* ref);
extern void nwos_free_reference_list(ReferenceList* ref_list);

extern void nwos_flush_dirty_ref_lists();

#endif

