# 
#              This file is part of the New World OS project
#                     Copyright (C) 2007 QRW Software
#            J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#                       http://www.qrwsoftware.com
#                       http://nwos.sourceforge.com
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program, in the file LICENSE.  If not, see 
#    <http://www.gnu.org/licenses/>.
# 
#    You can also contact me via paper mail at:
# 
#       QRW Software
#       P.O. Box 27511
#       Salt Lake City, UT 84127-0511, USA.
# 
# 
#  This script runs one test of of the remove_file program.
# 
#  $Log: test_remove.sh,v $
#  Revision 1.2  2007/09/15 15:50:03  jsedwards
#  Fixed comment about what this is and added another about what the arguments
#  are.
#
#  Revision 1.1  2007/09/15 15:46:39  jsedwards
#  Initial version, script to do one test of the remove_file program.
#
# 

# Arguments: number-of-files file-to-remove

echo "Testing: " $1 $2

# remember where we are (in the attic)
attic=$PWD

# create a new archive
$attic/../prep_disk 32M > /tmp/output.txt

# generate the test files
mkdir /tmp/test
$attic/gen_n_files $1 /tmp/test

# import them into the archive
cd /tmp/test
$attic/../import_file * >> /tmp/output.txt
cd $attic

# get rid of the test files
rm -r /tmp/test

# save the file list before
$attic/../list_files > /tmp/before.txt

# remove the file
$attic/../remove_file --all-traces $2 >> /tmp/output.txt

# save the file list after
$attic/../list_files > /tmp/after.txt

# compare the before and after
diff /tmp/before.txt /tmp/after.txt > /tmp/diff.txt

# display results

if grep "< $2$" /tmp/diff.txt; then
   echo "PASS!"
else
   echo "FAILED!!"
fi

