#

#          This file is part of the New World OS and Objectify projects
#                     Copyright (C) 2009, 2010  QRW Software
#               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program, in the file LICENSE.  If not, see 
#   <http://www.gnu.org/licenses/>.
#
#   For the latest information, source code (SVN), releases, and bug tracking
#   go to:
#      http://savannah.nongnu.org/projects/objectify
#
#   For releases from Alpha_30 and up, bug and feature request tracking go to:
#      http://sourceforge.net/projects/objectify
#
#   For older bug tracking, releases and source code (CVS) prior to the
#   Alpha_30 release go to:
#      http://sourceforge.net/projects/nwos
#
#   Other related websites:
#      http://www.qrwsoftware.com
#      http://www.worldwide-database.org
#
#   You can also contact me via paper mail at:
#
#      QRW Software
#      P.O. Box 27511
#      Salt Lake City, UT 84127-0511, USA.
#
#   $Author: jsedwards $
#   $Date: 2010-01-30 08:57:28 -0700 (Sat, 30 Jan 2010) $
#   $Revision: 4510 $
#
# 


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Rename Files Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

mkdir /tmp/test
cd /tmp/test

echo "----------------------"
echo " creating test files"
echo "----------------------"

#dd if=/dev/random of=x7 bs=7 count=1

echo "WARNING: NOT using random data!!!!!"
echo -n "1234567" > x7

cat          x7          x7 >        x14
cat         x14         x14 >        x28
cat         x28         x28 >        x56
cat         x56         x56 >       x112
cat        x112        x112 >       x224
cat        x224        x224 >       x448
cat        x448        x448 >       x896
cat        x896        x896 >      x1792
cat       x1792       x1792 >      x3584
cat       x3584       x3584 >      x7168
cat       x7168       x7168 >     x14336
cat      x14336      x14336 >     x28672
cat      x28672      x28672 >     x57344
cat      x57344      x57344 >    x114688
cat     x114688     x114688 >    x229376
cat     x229376     x229376 >    x458752
cat     x458752     x458752 >    x917504
cat     x917504     x917504 >   x1835008
cat    x1835008    x1835008 >   x3670016
cat    x3670016    x3670016 >   x7340032


echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/src/apps/util/archive-prep; then
   echo ""
   echo "archive-prep failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x14 x917504 x112; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x7*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x114688; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x4*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x3*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x2*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi


echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x1792 x14336; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x5*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x896; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi


echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x1835008; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi


echo "---------------------------------------"
echo " don't rename if no mode specified..."
echo "---------------------------------------"
if $EXEC/src/apps/file/file-rename x7 f7; then
   echo ""
   echo "file-rename without mode succeeded"
   echo ""
   exit 1
fi

echo "--------------------------------------"
echo " create rename file with same name..."
echo "--------------------------------------"

echo -e "x7\ty7"             >> test_rename_same.txt
echo -e "x14\ty14"           >> test_rename_same.txt
echo -e "x28\ty28"           >> test_rename_same.txt
echo -e "x56\ty56"           >> test_rename_same.txt
echo -e "x112\ty112"         >> test_rename_same.txt
echo -e "x224\ty224"         >> test_rename_same.txt
echo -e "x448\ty448"         >> test_rename_same.txt
echo -e "x896\ty896"         >> test_rename_same.txt
echo -e "x1792\ty1792"       >> test_rename_same.txt
echo -e "x3584\ty3584"       >> test_rename_same.txt
echo -e "x7168\ty7168"       >> test_rename_same.txt
echo -e "x14336\ty14336"     >> test_rename_same.txt
echo -e "x28672\ty28672"     >> test_rename_same.txt
echo -e "x57344\ty57344"     >> test_rename_same.txt
echo -e "x114688\tx114688"   >> test_rename_same.txt
echo -e "x229376\ty229376"   >> test_rename_same.txt
echo -e "x458752\ty458752"   >> test_rename_same.txt
echo -e "x917504\ty917504"   >> test_rename_same.txt
echo -e "x1835008\ty1835008" >> test_rename_same.txt
echo -e "x3670016\ty3670016" >> test_rename_same.txt
echo -e "x7340032\ty7340032" >> test_rename_same.txt


echo "------------------------------------------"
echo " rename multiple files with same name..."
echo "------------------------------------------"
if $EXEC/src/apps/file/file-rename --no-history -f test_rename_same.txt; then
   echo ""
   echo "file-rename --no-history -f test_rename_same.txt succeeded"
   echo ""
   exit 1
fi


echo "-----------------------------------------"
echo " create rename file with dup old name..."
echo "-----------------------------------------"

echo -e "x7\ty7"             >> test_rename_dup_old.txt
echo -e "x14\ty14"           >> test_rename_dup_old.txt
echo -e "x28\ty28"           >> test_rename_dup_old.txt
echo -e "x56\ty56"           >> test_rename_dup_old.txt
echo -e "x112\ty112"         >> test_rename_dup_old.txt
echo -e "x224\ty224"         >> test_rename_dup_old.txt
echo -e "x448\ty448"         >> test_rename_dup_old.txt
echo -e "x896\ty896"         >> test_rename_dup_old.txt
echo -e "x1792\ty1792"       >> test_rename_dup_old.txt
echo -e "x3584\ty3584"       >> test_rename_dup_old.txt
echo -e "x7168\ty7168"       >> test_rename_dup_old.txt
echo -e "x14336\ty14336"     >> test_rename_dup_old.txt
echo -e "x28672\ty28672"     >> test_rename_dup_old.txt
echo -e "x57344\ty57344"     >> test_rename_dup_old.txt
echo -e "x114688\ty114688"   >> test_rename_dup_old.txt
echo -e "x229376\ty229376"   >> test_rename_dup_old.txt
echo -e "x458752\ty458752"   >> test_rename_dup_old.txt
echo -e "x917504\ty917504"   >> test_rename_dup_old.txt
echo -e "x1792\tz1792"       >> test_rename_dup_old.txt
echo -e "x1835008\ty1835008" >> test_rename_dup_old.txt
echo -e "x3670016\ty3670016" >> test_rename_dup_old.txt
echo -e "x7340032\ty7340032" >> test_rename_dup_old.txt


echo "--------------------------------------------------"
echo " rename multiple files with duplicate old name..."
echo "--------------------------------------------------"
if $EXEC/src/apps/file/file-rename --no-history -f test_rename_dup_old.txt; then
   echo ""
   echo "file-rename --no-history -f test_rename_dup_old.txt succeeded"
   echo ""
   exit 1
fi


echo "-----------------------------------------"
echo " create rename file with dup new name..."
echo "-----------------------------------------"

echo -e "x7\ty7"             >> test_rename_dup_new.txt
echo -e "x14\ty14"           >> test_rename_dup_new.txt
echo -e "x28\ty28"           >> test_rename_dup_new.txt
echo -e "x56\ty56"           >> test_rename_dup_new.txt
echo -e "x112\ty112"         >> test_rename_dup_new.txt
echo -e "x224\ty224"         >> test_rename_dup_new.txt
echo -e "x448\ty448"         >> test_rename_dup_new.txt
echo -e "x896\ty896"         >> test_rename_dup_new.txt
echo -e "x1792\ty1792"       >> test_rename_dup_new.txt
echo -e "x3584\ty3584"       >> test_rename_dup_new.txt
echo -e "x7168\ty7168"       >> test_rename_dup_new.txt
echo -e "x14336\ty14336"     >> test_rename_dup_new.txt
echo -e "x28672\ty28672"     >> test_rename_dup_new.txt
echo -e "x57344\ty57344"     >> test_rename_dup_new.txt
echo -e "x114688\ty114688"   >> test_rename_dup_new.txt
echo -e "x229376\ty229376"   >> test_rename_dup_new.txt
echo -e "x458752\ty458752"   >> test_rename_dup_new.txt
echo -e "x917504\ty917504"   >> test_rename_dup_new.txt
echo -e "z1792\ty1792"       >> test_rename_dup_new.txt
echo -e "x1835008\ty1835008" >> test_rename_dup_new.txt
echo -e "x3670016\ty3670016" >> test_rename_dup_new.txt
echo -e "x7340032\ty7340032" >> test_rename_dup_new.txt


echo "---------------------------------------------------"
echo " rename multiple files with duplicate new name..."
echo "---------------------------------------------------"
if $EXEC/src/apps/file/file-rename --no-history -f test_rename_dup_new.txt; then
   echo ""
   echo "file-rename --no-history -f test_rename_dup_new.txt succeeded"
   echo ""
   exit 1
fi


echo "-------------------------------"
echo " rename non-existant file..."
echo "-------------------------------"
if $EXEC/src/apps/file/file-rename --no-history f7 y7; then
   echo ""
   echo "file-rename non-existant file succeeded"
   echo ""
   exit 1
fi


echo "-------------------------------------"
echo " rename file to name that exists..."
echo "-------------------------------------"
if $EXEC/src/apps/file/file-rename --no-history x1792 x7168; then
   echo ""
   echo "file-rename to existing name succeeded"
   echo ""
   exit 1
fi


echo "------------------------------------------"
echo " rename no history on the command line..."
echo "------------------------------------------"
if ! $EXEC/src/apps/file/file-rename --no-history x7 y7; then
   echo ""
   echo "file-rename --no-history failed"
   echo ""
   exit 1
fi


echo "----------------------------------"
echo " create rename file x* -> y* ..."
echo "----------------------------------"

echo -e "x14\ty14"           >> test_rename_x_to_y.txt
echo -e "x28\ty28"           >> test_rename_x_to_y.txt
echo -e "x56\ty56"           >> test_rename_x_to_y.txt
echo -e "x112\ty112"         >> test_rename_x_to_y.txt
echo -e "x224\ty224"         >> test_rename_x_to_y.txt
echo -e "x448\ty448"         >> test_rename_x_to_y.txt
echo -e "x896\ty896"         >> test_rename_x_to_y.txt
echo -e "x1792\ty1792"       >> test_rename_x_to_y.txt
echo -e "x3584\ty3584"       >> test_rename_x_to_y.txt
echo -e "x7168\ty7168"       >> test_rename_x_to_y.txt
echo -e "x14336\ty14336"     >> test_rename_x_to_y.txt
echo -e "x28672\ty28672"     >> test_rename_x_to_y.txt
echo -e "x57344\ty57344"     >> test_rename_x_to_y.txt
echo -e "x114688\ty114688"   >> test_rename_x_to_y.txt
echo -e "x229376\ty229376"   >> test_rename_x_to_y.txt
echo -e "x458752\ty458752"   >> test_rename_x_to_y.txt
echo -e "x917504\ty917504"   >> test_rename_x_to_y.txt
echo -e "x1835008\ty1835008" >> test_rename_x_to_y.txt
echo -e "x3670016\ty3670016" >> test_rename_x_to_y.txt
echo -e "x7340032\ty7340032" >> test_rename_x_to_y.txt


echo "------------------------------------------"
echo " rename multiple files no history..."
echo "------------------------------------------"
if ! $EXEC/src/apps/file/file-rename --no-history -f test_rename_x_to_y.txt; then
   echo ""
   echo "file-rename --no-history -f test_rename_x_to_y.txt failed"
   echo ""
   exit 1
fi


echo "---------------------"
echo " export..."
echo "---------------------"

if ! $EXEC/src/apps/file/file-export "*"; then
   echo ""
   echo "file-export failed"
   echo ""
   exit 1
fi


echo "--------------------------------------"
echo " compare with the original files..."
echo "--------------------------------------"

for file in x*; do diff -s $file y${file#x}; done


echo "--------------------------------------------"
echo " rename keep history on the command line..."
echo "--------------------------------------------"
if ! $EXEC/src/apps/file/file-rename --keep-history y7 x7; then
   echo ""
   echo "file-rename --keep-history failed"
   echo ""
   exit 1
fi


echo "----------------------------------"
echo " create rename file y* -> x* ..."
echo "----------------------------------"

echo -e "y14\tx14"           >> test_rename_y_to_x.txt
echo -e "y28\tx28"           >> test_rename_y_to_x.txt
echo -e "y56\tx56"           >> test_rename_y_to_x.txt
echo -e "y112\tx112"         >> test_rename_y_to_x.txt
echo -e "y224\tx224"         >> test_rename_y_to_x.txt
echo -e "y448\tx448"         >> test_rename_y_to_x.txt
echo -e "y896\tx896"         >> test_rename_y_to_x.txt
echo -e "y1792\tx1792"       >> test_rename_y_to_x.txt
echo -e "y3584\tx3584"       >> test_rename_y_to_x.txt
echo -e "y7168\tx7168"       >> test_rename_y_to_x.txt
echo -e "y14336\tx14336"     >> test_rename_y_to_x.txt
echo -e "y28672\tx28672"     >> test_rename_y_to_x.txt
echo -e "y57344\tx57344"     >> test_rename_y_to_x.txt
echo -e "y114688\tx114688"   >> test_rename_y_to_x.txt
echo -e "y229376\tx229376"   >> test_rename_y_to_x.txt
echo -e "y458752\tx458752"   >> test_rename_y_to_x.txt
echo -e "y917504\tx917504"   >> test_rename_y_to_x.txt
echo -e "y1835008\tx1835008" >> test_rename_y_to_x.txt
echo -e "y3670016\tx3670016" >> test_rename_y_to_x.txt
echo -e "y7340032\tx7340032" >> test_rename_y_to_x.txt


echo "------------------------------------------"
echo " rename multiple files no history..."
echo "------------------------------------------"
if ! $EXEC/src/apps/file/file-rename --keep-history -f test_rename_y_to_x.txt; then
   echo ""
   echo "file-rename --keep-history -f test_rename_y_to_x.txt failed"
   echo ""
   exit 1
fi


echo "------------------------------------------"
echo " verify and remove both x and y files..."
echo "------------------------------------------"
if ! $EXEC/src/apps/file/file-verify --remove-no-shred x* y*; then
   echo ""
   echo "file-verify --remove-no-shred failed"
   echo ""
   exit 1
fi


echo ""
echo "All tests passed!"
echo ""

exit 0

