--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.9  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.8  2006/02/13 04:32:31  jsedwards
-- Renamed "character" to "symbol" in NWOS_CHARACTER class, so had to change
-- "rename" here.  Also added redefines because NWOS_CHARACTER class is no
-- longer deferred and now has it's own class_revision and class_reference.
--
-- Revision 1.7  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.6  2006/02/09 12:51:27  jsedwards
-- Changed to the new method of doing the class defintion stuff, with the
-- "class reference" and "class revision".
--
-- Revision 1.5  2006/02/08 14:21:10  jsedwards
-- Added "load" to creation clause and predefined reference to class
-- definition "make" call.
--
-- Revision 1.4  2006/02/04 14:56:09  jsedwards
-- Changed from the class_ref to the deferred class_definition.
--
-- Revision 1.3  2006/02/04 03:46:18  jsedwards
-- Remove old unused stuff.
--
-- Revision 1.2  2006/01/31 19:31:08  jsedwards
-- Added new kludgy class definition stuff.
--
-- Revision 1.1  2006/01/29 18:17:06  jsedwards
-- Initial version.
--


class NWOS_LOWER_CASE_CHARACTER

inherit NWOS_CHARACTER
           rename
              symbol as letter
           redefine
              class_revision,
              class_reference
           end

creation make, make_unresolved


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 4384 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_lower_case_ref
      end

end

