/*
--          This file is part of the New World OS and Objectify projects
--         Copyright (C) 2004, 2005, 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file and the objecitfy.h file which this
--   file was derived from.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#ifndef OBJECTS_H
#define OBJECTS_H

#include "reference.h"
#include "time_stamp.h"


typedef struct {
    uint32    flags;                      /*   4 */  /* flags / version */
    ObjRef    id;                         /*   8 */  /* reference id */
    union {
      uint8     header_chksum[4];         /*  12 */  /* CRC32 of header */
      uint32    num_refs;                            /* used by reference lists only */
    };
    uint8     data_chksum[4];             /*  16 */  /* CRC32 of data   */
    TimeStamp creation_time;              /*  24 */
    TimeStamp access_time;                /*  32 */  /* used when in memory for caching */
    ObjRef    class_definition;           /*  36 */
} CommonHeader;


typedef struct {
    ObjRef    clone_of;                   /*   4 */
    ObjRef    references;                 /*   8 */
    ObjRef    context;                    /*  12 */
    ObjRef    creation;                   /*  16 */
    ObjRef    source;                     /*  20 */
    ObjRef    prev_version;               /*  24 */
    ObjRef    next_version;               /*  28 */
} ObjectHeader;


typedef struct {
    CommonHeader common;                  /*  36 */
    ObjectHeader object;                  /*  64 */
} EveryObject;

typedef struct {
    CommonHeader common_header;           /*  36 */
    ObjRef       references[0];
} ReferenceList;


typedef struct {
    CommonHeader  header;                 /*   36 */
    uint32        index[256];             /*  ??? */
    ObjRef        references[256];        /* ???? */
} IndexedReferenceList;


/* If we are making the export_c_structs program, c_structs.h doesn't   */
/* exist yet, so these need to be defined for it to build successfully. */

#ifdef USE_PREDEFINED_STRUCTS

typedef struct {
    EveryObject header;
    ObjRef name;
    uint8 count;
    ObjRef feature[0];
} C_struct_Class_Definition;

typedef struct {
    EveryObject header;
    ObjRef character_set;
    uint8 count;
    char storage[0];
} C_struct_Spelling;

typedef struct {
    EveryObject header;
    uint8 count;
    ObjRef spelling[0];
} C_struct_Name;

typedef struct {
    EveryObject header;
    ObjRef inherit;
    ObjRef class;
    ObjRef label;
    uint8 count;
} C_struct_Feature_Definition;

typedef struct {
    EveryObject header;
    ObjRef class_definition_class;
    ObjRef reference_list_class;
} C_struct_Root;

#else
#include "c_structs.h"
#endif

extern void nwos_get_object_class(ObjRef* obj, ObjRef* object_class);
extern void nwos_get_object_class_without_update(ObjRef* obj, ObjRef* object_class);
extern void nwos_fill_in_common_header(CommonHeader* common, ObjRef* ref, ObjRef* class_definition_ref);

extern void nwos_read_object_headers_from_disk(ObjRef* ref, EveryObject* header);
extern bool nwos_read_object_from_disk(ObjRef* ref, void* object, size_t size);
extern bool nwos_read_variable_sized_object_from_disk(ObjRef* ref, void* obj, size_t max_size, size_t (*size_function)(void*));
extern void nwos_write_object_to_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_write_public_object_to_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_overwrite_object_to_disk(ObjRef* ref, void* object, size_t size);
extern void nwos_remove_object(ObjRef* ref);

#endif

