#
#          This file is part of the New World OS and Objectify projects
#                     Copyright (C) 2008, 2009  QRW Software
#               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program, in the file LICENSE.  If not, see 
#   <http://www.gnu.org/licenses/>.
#
#   For the latest information, source code (SVN), releases, bug and feature
#   request tracking go to:
#      http://sourceforge.net/projects/objectify
#
#   For older bug tracking, releases and source code (CVS) prior to the
#   Alpha_30 release go to:
#      http://sourceforge.net/projects/nwos
#
#   Other related websites:
#      http://www.qrwsoftware.com
#      http://www.worldwide-database.org
#
#   You can also contact me via paper mail at:
#
#      QRW Software
#      P.O. Box 27511
#      Salt Lake City, UT 84127-0511, USA.
#
#   $Author: jsedwards $
#   $Date: 2009-09-20 13:04:12 -0600 (Sun, 20 Sep 2009) $
#   $Revision: 4372 $
#
#   NOTE: Subversion does not support the Log keyword so I have removed the
#   logs that were here when I was using CVS.  Use the "svn log" command to
#   see the revision history of this file.
#   (See http://subversion.tigris.org/faq.html#log-in-source)
# 


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Import Export Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

mkdir /tmp/test
cp -p src/*/*/*.[ch] /tmp/test
cd /tmp/test

echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/src/apps/util/prep_archive; then
   echo ""
   echo "prep_archive failed"
   echo ""
   exit 1
fi

sleep 2

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/src/apps/file/import_file *.[ch] > /tmp/test1.out; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi


echo "-----------------"
echo " export_files..."
echo "-----------------"

mkdir test
cd test

if ! $EXEC/src/apps/file/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done
sleep 2

echo "-------------------"
echo " md5 checksums..."
echo "-------------------"

if ! $EXEC/src/apps/file/list_files --md5  | tee ../a.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c ../a.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi


echo "-------------------"
echo " sha1 checksums..."
echo "-------------------"

if ! $EXEC/src/apps/file/list_files --sha1  | tee ../a.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c ../a.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " sha256 checksums..."
echo "---------------------"

if ! $EXEC/src/apps/file/list_files --sha256  | tee ../a.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c ../a.sha256; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

echo "---------------------"
echo " sha512 checksums..."
echo "---------------------"

if ! $EXEC/src/apps/file/list_files --sha512  | tee ../a.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c ../a.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " file revision..."
echo "---------------------"
sed -i -e "s/Copyright/Copyleft/" computer.c

echo "---------------------"
echo " verify and remove..."
echo "---------------------"

if $EXEC/src/apps/file/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred succeeded when one changed file was not removed"
   echo ""
   exit 1
fi

echo "---------------------"
echo " files left: "
ls

echo "---------------------"
echo " add-revision..."
echo "---------------------"
if ! $EXEC/src/apps/file/import_file --add-revision computer.c; then
   echo ""
   echo "import_file --add-revision failed"
   echo ""
   exit 1
fi

cp -piv computer.c ../computer.c.save


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/src/apps/file/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred succeeded"
   echo ""
   exit 1
fi

echo "---------------------"
echo " export files..."
echo "---------------------"
if ! $EXEC/src/apps/file/export_file computer.c; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

rmdup ../computer.c.save computer.c


echo "---------------------"
echo " compress..."
echo "---------------------"
if ! $EXEC/src/apps/util/compress_archive ../compressed; then
   echo ""
   echo "compress_archive failed"
   echo ""
   exit 1
fi


echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
if ! $EXEC/src/apps/util/prep_archive --no-private; then
   echo ""
   echo "prep_archive --no-private failed"
   echo ""
   exit 1
fi


echo "---------------------"
echo " expand..."
echo "---------------------"
if ! $EXEC/src/apps/util/restore_archive ../compressed; then
   echo ""
   echo "restore_archive failed"
   echo ""
   exit 1
fi



if ! $EXEC/src/apps/file/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done


echo "-------------------"
echo " md5 checksums..."
echo "-------------------"

if ! $EXEC/src/apps/file/list_files --md5  | tee ../a.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c ../a.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi


echo "-------------------"
echo " sha1 checksums..."
echo "-------------------"

if ! $EXEC/src/apps/file/list_files --sha1  | tee ../a.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c ../a.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " sha256 checksums..."
echo "---------------------"

if ! $EXEC/src/apps/file/list_files --sha256  | tee ../a.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c ../a.sha256; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

echo "---------------------"
echo " sha512 checksums..."
echo "---------------------"

if ! $EXEC/src/apps/file/list_files --sha512  | tee ../a.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c ../a.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/src/apps/file/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred failed"
   echo ""
   exit 1
fi

echo "---------------------"
echo " files left: "
ls

echo "---------------------------"
echo " list revision and time..."
echo "---------------------------"
if ! $EXEC/src/apps/file/list_files --time --revision; then
   echo ""
   echo "list_files --time --revision failed"
   echo ""
   exit 1
fi

echo ""
echo "All tests passed!"
echo ""

exit 0

