/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.3  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/01/22 18:16:32  jsedwards
-- Added code to set character set name.
--
-- Revision 1.1  2006/01/22 17:14:03  jsedwards
-- Run once app to create the ascii character set object to translate ascii
-- characters to binary codes.
--
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>

#include "objectify.h"
#include "c_structs.h"
#include "objectify_private.h"



int main()
{
    C_struct_Ascii_Char_Set ascii_char_set_object;
    ObjRef binary_code_ref;
    ObjRef ascii_chars_ref;
    uint8 base_char_ref;
    int i;

    printf("Creating ASCII character set object...\n");

    memset(&ascii_char_set_object, 0, sizeof(ascii_char_set_object));

    nwos_fill_in_any(&ascii_char_set_object.any, Char_Set_Class_Ref, User_Ref, Create_Ascii_Char_Set_Ref);

    nwos_copy_reference(ascii_char_set_object.name, Ascii_Name_Ref);

    nwos_copy_reference(binary_code_ref, Binary_Codes_Ref);
    nwos_copy_reference(ascii_chars_ref, Ascii_Chars_Ref);

    base_char_ref = ascii_chars_ref[sizeof(ObjRef)-1];   /* save this value */

    for (i = 0; i < 128; i++)
    {
	ascii_chars_ref[sizeof(ObjRef)-1] = base_char_ref | i;
	binary_code_ref[sizeof(ObjRef)-1] = i;

	nwos_copy_reference(ascii_char_set_object.pair[i].character, ascii_chars_ref);
	nwos_copy_reference(ascii_char_set_object.pair[i].binary_code, binary_code_ref);
    }

    nwos_write_public_object_to_disk(Ascii_Char_Set_Ref, &ascii_char_set_object, sizeof(ascii_char_set_object));

    printf("Done!\n");

    return 0;
}

