/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-01 08:34:47 -0600 (Sat, 01 Aug 2009) $
--   $Revision: 4227 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revisions of this file and the objectify.h file which this file
--   was taken from.  (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#ifndef BIT_MAP_H
#define BIT_MAP_H

#include "reference.h"
#include "types.h"


extern void nwos_set_bit_in_map(uint32 block);
extern void nwos_clear_bit_in_map(uint32 block);
extern bool nwos_test_bit_in_map(uint32 block);

extern bool nwos_block_used(ObjRef* ref);

extern uint32 nwos_find_random_block_in_chunk(int info_index);
extern int    nwos_find_low_density_in_chunk(int info_index, int density);
extern uint32 nwos_find_next_empty_block(uint32 start_block, int density);

extern void nwos_flush_bit_maps();

extern void nwos_terminate_bit_map(void);

extern void nwos_calculate_chunk_md5sum(uint32 chunk_index, uint8 md5_digest[MD5_DIGEST_SIZE]);

#endif

