#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by:
--------------------------------------------------------------------
 Fine - Release 0.11x18 [alpha] (Sunday 01-Mar-2004)
  Copyright (C) 2001-2003 QRW Software - http://www.qrwsoftware.com
  J. Scott Edwards - sedwards@qrwsoftware.com
  http://fine.sourceforge.net
 Based upon SmallEiffel Release -0.76
  Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
  Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
  http://SmallEiffel.loria.fr
--------------------------------------------------------------------
*/
#ifdef __cplusplus
}
#endif
#include "gen_n_files.h"
#ifdef __cplusplus
extern "C" {
#endif

/*
  This file (fine/lib/runtime/base.c) is included for ALL modes of 
  compilation (-no_check, -system_check ... -all_check, -debug_check).
*/

/*
  The wrapper for `malloc' (generated C code is supposed to use 
  only `se_malloc' instead of direct `malloc').
*/
void* se_malloc(size_t size) {
  void *result = malloc(size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
#endif
  }
  return result;
}

/*
  The wrapper for `calloc' (generated C code is supposed to use 
  only `se_calloc' instead of direct `calloc').
*/
void* se_calloc(size_t nmemb, size_t size) {
  void *result = calloc(nmemb,size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
#endif
  }
  return result;
}

void se_exit(int exit_code)
{
#ifdef SE_DEBUGGER
  debugger();
#else
  exit(exit_code);
#endif
}

T6 se_is_reg(T8 path)
{
  int result = 0;
  struct stat buf;
  if (stat((char*)path, &buf) == 0) result = S_ISREG(buf.st_mode);
  return result;
}

T6 se_is_dir(T8 path)
{
  int result = 0;
  struct stat buf;
  if (stat((char*)path, &buf) == 0) result = S_ISDIR(buf.st_mode);
  return result;
}

T6 se_is_lnk(T8 path)
{
  int result = 0;
  struct stat buf;
  if (lstat((char*)path, &buf) == 0) result = S_ISLNK(buf.st_mode);
  return result;
}


int machine_is_little_endian()
{
  int word = 1;
  char *cptr = (char*) &word;
  return (int) *cptr;
}

/* $Revision: 4303 $ */



void se_prinT8(T8*o){
 if (*o == NULL) {
   fputs("NULL",SE_ERR);
 }
 else {
   fprintf(SE_ERR,"POINTER#%p",*o);
 }
}


void se_prinT6(T6*o){
 fprintf(SE_ERR,(*o)?"True":"False");
}


void se_prinT3(T3*o){
 if (*o == '\'') {
   fputs("'%''",SE_ERR);
 } else {
   fputc('\'',SE_ERR);
   se_puTchar(*o,SE_ERR);
   fputc('\'',SE_ERR);
 }
}
T26 M26={26,NULL,NULL};


void se_prinT26(T26**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STD_FILE_WRITE");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"path = ");
se_prinT7((EIF_STRING*)(&((*o)->_path)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"output_stream = ");
se_prinT8((&((*o)->_output_stream)));
fprintf(SE_ERR,"\n\t]");
}
T36 M36={36,NULL,0,0};


void se_prinT36(T36**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[STRING]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT37((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT37(T37*o){
fprintf(SE_ERR,"NATIVE_ARRAY[STRING]");
fprintf(SE_ERR,"#%p",*o);
}
T18 M18={18};


void se_prinT18(T18**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"GEN_N_FILES");
fprintf(SE_ERR,"#%p",*o);
}
T7 M7={7,NULL,0,0,0};


void se_prinT7(T7**o){
 if (*o == NULL) {
   fputs("Void",SE_ERR);
 }
 else {
   char* storage = (char*)(*o)->_storage;
   int count = (*o)->_count;
   int key = (*o)->_key;
   fprintf(SE_ERR,"STRING#%p\n",*o);
   fprintf(SE_ERR,"\t\t[ key = %d (%s)\n",
     key,(key==0)?"mutable":"immutable");
   fprintf(SE_ERR,"\t\t  capacity = %d\n",(*o)->_capacity);
   fprintf(SE_ERR,"\t\t  count = %d\n",count);
   fputs("\t\t  storage = \"",SE_ERR);
   if (se_longesTline(storage,count) <= 48)
     se_puTshortlines(SE_ERR,storage,count,"%\n\t\t            %");
   else
     se_puTlonglines(SE_ERR,storage,count,"%\n\t\t            %",48);
   fputs("\"\n\t\t]",SE_ERR);
 }
}


void se_prinT9(T9*o){
fprintf(SE_ERR,"NATIVE_ARRAY[CHARACTER]");
fprintf(SE_ERR,"#%p",*o);
}


void se_prinT2(T2*o){
 fprintf(SE_ERR,"%d",*o);
}
T32 M32={32};


void se_prinT32(T32**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STD_ERROR");
fprintf(SE_ERR,"#%p",*o);
}


/*
  This file (fine/lib/runtime/check.c) is automatically included 
  when `system_check' is true (ie. all modes except -no_check).
*/

/* 
   To print object into the trace-stack :
*/
void se_prinT0(T0** o) {
  if (*o == NULL) {
    fprintf(SE_ERR,"Void");
  }
  else {
    fprintf(SE_ERR,"#%p",(void*)*o);
  }
}


/* Special routines to assist in printing characters and strings. */
/* They are called by the se_prinTn routines, which are generated */
/* by the TYPE_CHARACTER and TYPE_STRING classes in the compiler. */

#include <ctype.h>  /* define isprint function */

/* returns number of characters that are output in a string for this char */
int se_counTchar(unsigned char c) {
  int n = 4;
  if (c == '\0' || strchr("\b\f\n\r\t\"%",c) != NULL) return 2;
  if (isprint(c)) return 1;
  if (c > 9) n++;
  if (c > 99) n++;
  return n;
}

/* Output a character in Eiffel format, it is called by the            */
/* se_prinT<character id> routine generated by the TYPE_CHARACTER      */
/* class and the se_puTshortlines and se_puTlonglines functions below. */
void se_puTchar(unsigned char c, FILE* stream) {
  switch (c) {
    case '\0': fputs("%U",stream); break;
    case '\b': fputs("%B",stream); break;
    case '\f': fputs("%F",stream); break;
    case '\n': fputs("%N",stream); break;
    case '\r': fputs("%R",stream); break;
    case '\t': fputs("%T",stream); break;
    case '%':  fputs("%%",stream); break;
    default:
      if (isprint(c)) {
	fputc(c, stream);
      }
      else {
	fprintf(stream,"%%/%u/",c);
      }
  }
}

/* This function returns number of characters that will be output for    */
/* the longest line in a string, it is called by the se_prinT<string id> */
/* routine generated by the TYPE_STRING class in the compiler.           */
int se_longesTline(char* storage, int count) {
  int len = 0;
  int max = 0;
  int nl = 0;
  char c;
  while (count--) {
    c = *storage++;
    len += se_counTchar(c);
    if (c == '\n' || c == '\r') {
      nl = 1;
    }
    else if (nl) {
      if (len > max) max = len;
      len = 0;
      nl = 0;
    }
  }
  if (len > max) max = len;
  return max;
}

/* Output a string in Eiffel format, where each line of the string is */
/* printed on it's own line, it is called by the se_prinT<string id>  */
/* routine generated by the TYPE_STRING class in the compiler.        */
void se_puTshortlines(FILE* stream, char *p, int count, char *nlstr) {
  int nl = 0;
  char c;
  while (count--) {
    c = *p++;
    if (c == '\n' || c == '\r') {
      nl = 1;
    }
    else if (nl) {
      fputs(nlstr,stream);  /* go to next line */
      nl = 0;
    }
    if (c == '"') {
      fputs("%\"", stream);
    }
    else {
      se_puTchar(c, stream);
    }
  }
}

/* Output a string in Eiffel format, where the string is       */
/* printed in a block, it is called by the se_prinT<string id> */
/* routine generated by the TYPE_STRING class in the compiler. */
void se_puTlonglines(FILE *stream, char *p, int count, char* nlstr, int max) {
  int n = max;
  char c;
  while (count--) {
    c = *p++;
    if (n < se_counTchar(c)) {
      fputs(nlstr,stream);  /* go to next line */
      n = max;
    }
    if (c == '"') {
      fputs("%\"", stream);
    }
    else {
      se_puTchar(c, stream);
    }
    n -= se_counTchar(c);
  }
}


EIF_INTEGER se_position2line(se_position position) {
  /* 
     Computes the line number using the given `position'.
  */
  if (position & 1) {
    return ((EIF_INTEGER)((position >> 1) & 0x7FFF));
  }
  else{
    return ((EIF_INTEGER)((position >> 8) & 0x1FFF));
  }
}

EIF_INTEGER se_position2column(se_position position) {
  /* 
     Computes the column number using the given `position'.
  */
  if (position & 1) {
    return 0; /* Not memorized. */
  }
  else{
    return ((EIF_INTEGER)((position >> 1) & 0x7F));
  }
}

EIF_INTEGER se_position2path_id(se_position position) {
  /* 
     Computes the file path id using the given `position'.
  */
  return ((EIF_INTEGER)((position & 1) ? 
			(position >> 17) : 
			(position >> 21)));
}

/*
  The upper most context (SmallEiffel Dump stack Top) :
*/
se_dump_stack* se_dst=NULL;

void se_print_run_time_stack(void) {
  /* GENERAL.print_run_time_stack */
  se_dump_stack* ds = NULL;
  se_dump_stack* ds2;
  int frame_count = 1;

  ds = se_dst;
  if (ds == NULL) {
    fprintf(SE_ERR,"Empty stack.\n");
    return ;
  }
  else {
    while (ds->caller != NULL) {
      ds = ds->caller;
      frame_count++;
    }
  }
  fprintf(SE_ERR,"%d frames in current stack.\n",frame_count);
  fprintf(SE_ERR,"=====  Bottom of run-time stack  =====\n");
  while (ds != NULL) {
    if (ds->fd != NULL) {
      se_print_one_frame(ds);
    }
    else {
      fprintf(SE_ERR,"External CECIL call.\n");
    }
    /* Next frame : */
    if (ds == se_dst) {
      ds = NULL;
    }
    else {
      ds2 = se_dst;
      while (ds2->caller != ds) {
	ds2 = ds2->caller;
      }
      ds = ds2;
    }
    if (--frame_count) {
      fprintf(SE_ERR,"======================================\n");
    }
  }
  fprintf(SE_ERR,"=====   Top of run-time stack    =====\n");
}

void se_print_one_frame(se_dump_stack* ds) {
  se_frame_descriptor* fd = ds->fd;
  int i = 0;
  int local_count = 0;
  char* local_format = fd->local_format;
  int expanded;
  int id;
  void** var;
  fprintf(SE_ERR,"%s\n",fd->name);
  if (fd->use_current) {
    fprintf(SE_ERR,"Current = ");
    i = 2;
    id = 0;
    while (local_format[i] != '%') {
      id = (id * 10) + (local_format[i] - '0');
      i++;
    }
    i++;
    (se_prinT[id])(ds->current);
    fprintf(SE_ERR,"\n");
  }
  while (local_count < fd->local_count) {
    while (local_format[i] != '%') {
      fprintf(SE_ERR,"%c",local_format[i]);
      i++;
    }
    i++;
    expanded = ((local_format[i++] == 'E')?1:0);
    fprintf(SE_ERR," = ");
    id = 0;
    while (local_format[i] != '%') {
      id = (id * 10) + (local_format[i] - '0');
      i++;
    }
    i++;
    var = (ds->locals)[local_count];
    if (expanded) {
      (se_prinT[id])((void**)(var));
    }
    else if (*var == NULL) {
      fprintf(SE_ERR,"Void");
    }
    else {
      (se_prinT[((T0*)(*var))->id])((void**)(var));
    }
    fprintf(SE_ERR,"\n");
    local_count++;
  }
  if (ds->p != 0) {
    fprintf(SE_ERR,"line %d ",se_position2line(ds->p));
    fflush(SE_ERR);
    fprintf(SE_ERR,"column %d ",se_position2column(ds->p));
    fflush(SE_ERR);
    fprintf(SE_ERR,"file %s \n",p[se_position2path_id(ds->p)]);
    fflush(SE_ERR);
  }
}

void se_core_dump(char*msg) {
  if (msg != NULL) {
    fprintf(SE_ERR,"%s\n",msg);
  }
#ifdef SE_EXCEPTIONS
  print_exception();
#endif
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

int se_require_uppermost_flag;

/*
  Require Last Result :
*/
int se_require_last_result;

int se_rci(void*C) {
  /* Return 1 if class invariant must be checked for Current 
     before leaving the routine.
  */
  se_dump_stack*ds = se_dst;
  ds = ds->caller;
  if (ds != NULL) {
    se_frame_descriptor* fd = ds->fd;
    if (fd == NULL) {
      /* As for example when coming via CECIL. */
      return 0;
    }
    else {
      if (fd->use_current) {
	if (fd->local_format[1] == 'R') {
	  if (((void*)*(ds->current)) == C) {
	    return 0;
	  }
	}
      }
    }
  }
  return 1;
}

void error0(char*m,char*vv) {
  static char*f1="*** Error at Run Time *** : %s\n";
  static char*f2="*** Error at Run Time *** : %s\n";
  fprintf(SE_ERR,f1,m);
  if (vv!=NULL)
     fprintf(SE_ERR,f2,vv);
#ifdef SE_EXCEPTIONS
  print_exception();
#endif
  se_print_run_time_stack();
  fprintf(SE_ERR,f1,m);
  if (vv!=NULL)
     fprintf(SE_ERR,f2,vv);
  se_exit(EXIT_FAILURE);
}

void error1(char*m,se_position position) {
  int l = se_position2line(position);
  int c = se_position2column(position);
  int f = se_position2path_id(position);
  char* f1 = "Line : %d column %d in %s.\n";
  char* f2 = "*** Error at Run Time *** : %s\n";
  
  fprintf(SE_ERR,f1,l,c,p[f]);
  fprintf(SE_ERR,f2,m);
#ifdef SE_EXCEPTIONS
  print_exception();
#endif
  se_print_run_time_stack();
  fprintf(SE_ERR,f1,l,c,p[f]);
  fprintf(SE_ERR,f2,m);
  se_exit(EXIT_FAILURE);
}

void se_print_string(FILE*stream, EIF_STRING s) {
  /* To print some Eiffel STRING. */
  if (s == NULL) {
    fprintf(stream,"Void");
  }
  else {
    int count = s->_count;
    EIF_CHARACTER* storage = s->_storage;
    int i = 0;
    fprintf(stream,"\"");
    while (count != 0) {
      fprintf(stream,"%c",storage[i]);
      i++;
      count--;
    }
    fprintf(stream,"\"");
  }
}

void se_print_bad_target(FILE*stream, int id, T0* o, int l, int c, int f) {
  /* Print Bad Target Type Error Message. */
  if (l != 0) {
    fprintf(stream,"Line : %d column %d in %s.\n",l,c,p[f]);
  }
  fprintf(stream,"*** Error at Run Time *** :\n");
  fprintf(stream,"   Target is not valid (not the correct type).\n");
  fprintf(stream,"   Expected: ");
  se_print_string(stream,t[id]);
  fprintf(stream,", Actual: ");
  se_print_string(stream,t[o->id]);
  fprintf(stream,".\n");
}

void error2(T0*o, se_position position) {
  fprintf(SE_ERR,"Target Type ");
  se_print_string(SE_ERR,t[o->id]);
  fprintf(SE_ERR," is not valid.\n");
  error1("Bad target.",position);
}

T0* vc(void*o,se_position position) {
  /*
    VoidCheck for reference target.
  */
  if (o != NULL) {
    return ((T0*)o);
  }
  else {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Void_call_target);
#else
    error1("Call with a Void target.",position);
#endif
    return NULL;
  }
}

T0* ci(int id,void*o,se_position position) {
  /*
    Check Id for reference target.
  */
  vc(o,position);
  if (id == (((T0*)o)->id)) {
    return ((T0*)o);
  }
  else {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Routine_failure);
#else
    int l = se_position2line(position);
    int c = se_position2column(position);
    int f = se_position2path_id(position);

    se_print_bad_target(SE_ERR,id,(T0*)o,l,c,f);
    se_print_run_time_stack();
    se_print_bad_target(SE_ERR,id,(T0*)o,l,c,f);
    se_exit(EXIT_FAILURE);
#endif
  }
  return ((T0*)o);
}

void ac_req(int v,char*vv) {
  if (!v && se_require_uppermost_flag) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Precondition);
#else
    error0("Require Assertion Violated.",vv);
#endif
  }
  se_require_last_result=se_require_last_result&&v;
}

void ac_ens(int v,char*vv) {
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Postcondition);
#else
    error0("Ensure Assertion Violated.",vv);
#endif
  }
}

void ac_inv(int v,char*vv) {
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Class_invariant);
#else
    error0("Class Invariant Violation.",vv);
#endif
  }
}

void ac_liv(int v,char*vv) {
  /* Assertion Check : Loop Invariant check. */
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Loop_invariant);
#else
    error0("Loop Invariant Violation.",vv);
#endif
  }
}

int ac_lvc(int lc,int lv1,int lv2) {
  /* Assertion Check : Loop Variant check. */
  if (lc == 0) {
    if (lv2 < 0) {
#ifdef SE_EXCEPTIONS
      internal_exception_handler(Loop_variant);
#else
      se_print_run_time_stack();
      fprintf(SE_ERR,"Bad First Variant Value = %d\n",lv2);
      se_exit(EXIT_FAILURE);
#endif
    }
    else {
      return lv2;
    }
  }
  else if ((lv2 < 0) || (lv2 >= lv1)) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Loop_variant);
#else
    se_print_run_time_stack();
    fprintf(SE_ERR,"Loop Body Count = %d (done)\n",lc);
    fprintf(SE_ERR,"New Variant = %d\n",lv2);
    fprintf(SE_ERR,"Previous Variant = %d\n",lv1);
    se_exit(EXIT_FAILURE);
#endif
  }
  return lv2;
}

void ac_civ(int v,char*vv) {
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Check_instruction);
#else
    error0("Check Assertion Violated.",vv);
#endif
  }
}

void se_evobt(void*o,se_position position) {
  /*
    Error Void Or Bad Type.
  */
  if (!o) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Void_call_target);
#else
    error1("Target is Void.",position);
#endif
  }
  else {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Void_call_target);
#else
    error2(((T0*)o),position);
#endif
  }
}

void sigrsp(int sig) {
  printf("Received signal %d (man signal).\n",sig);
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

void se_gc_check_id(void*o,int id) {
  if (id != (((T0*)o)->id)) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Routine_failure);
#else
    fprintf(SE_ERR,"System-validity error detected during GC cycle.\n");
    se_print_bad_target(SE_ERR,id,(T0*)o,0,0,0);
    se_print_run_time_stack();
    fprintf(SE_ERR,"System-validity error detected during GC cycle.\n");
    se_print_bad_target(SE_ERR,id,(T0*)o,0,0,0);
    se_exit(EXIT_FAILURE);
#endif
  }
}

/* $Revision: 4303 $ */



/*
  This file (sys/runtime/trace.c) is automatically included when 
  `system_check' is true (ie. all modes except -no_check).
  This file comes after no_check.[hc] to implements the -trace flag.
*/


#ifdef SE_WEDIT
/* 
   Smooth interface with the Wedit debugger.
*/
#define MAXBREAKPOINTS 256
static int __BreakpointsList[MAXBREAKPOINTS];
void SE_CallDebugger(void) {
}

se_position se_trace(se_position p) {
  int l = se_position2line(p);
  int c = se_position2column(p);
  int f = se_position2path_id(p);
  int i,s;
  
  s = (f <<16)|l;
  for (i=0; i< MAXBREAKPOINTS;i++) {
    if (__BreakpointsList[i] == s) {
      SE_CallDebugger();
    }
    else if (__BreakpointsList[i] == 0)
      break;
  }
  return p;
}
#elif SE_TRACE
/*
  The SmallEiffel -trace is used, so the command line SmallEiffel 
  step-by-step se_trace function is defined.
*/
static FILE* se_trace_file = NULL;
static int se_write_trace_flag = 0;
static int se_trace_ready_flag = 0;
static int se_step_by_step_flag = 1;

int get_answer(void) {
  int result = 0;
  char c = getc(stdin);
  if (c != '\n') {
    result = c;
  }
  while (c != '\n') {
    c = getc(stdin);
  }
  return result;
}

static void sedb_help_command(void) {
  printf("SmallEiffel debugger.\n");
  printf("List of classes of commands:\n");
  printf("   (h) Help.\n");
  printf("   (s) Stack view.\n");
  printf("   (q) Quit.\n");
  printf("   Return to see the current Eiffel source line.");
  printf("   \n");
  printf("Please, feel free to debug or to complete this simple\n");
  printf("step-by-step debugger (see source file in\n");
  printf("\"fine/lib/runtime/trace.c\".\n");
}

static void sedb_show_source_line(int l,int c,int f) {
  static int f_memo = 0;
  if (p[f] == NULL) {
    printf("line %d column %d of ???\t\t",l,c);
  }
  else {
    FILE *file = fopen(p[f],"r");
    if (file != NULL) {
      int line = 1;
      int column = 1;
      char cc;
      while (line < l) {
	cc = fgetc(file);
	if (cc == '\n') {
	  line++;
	}
      }
      cc = fgetc(file);
      while (cc != '\n') {
	if (cc == '\t') {
	  printf("        ");
	  column+=7;
	}
	else {
	  fputc(cc,stdout);
	}
	cc = fgetc(file);
	column++;
      }
      while (column < 72) {
	fputc(' ',stdout);
	column++;
      }
      printf("l%dc%d ",l,c);
      if (f_memo != f) {
	printf(" %s ",p[f]);
      }
      f_memo = f;
      fclose(file);
    }
    else {
      printf("line %d column %d of %s\t\t",l,c,p[f]);
    }
  }
}

void se_trace(se_dump_stack*ds, se_position position) {
  if (se_trace_flag) {
    static char cmd_memo = 1;
    static char cmd;
    int l = se_position2line(position);
    int c = se_position2column(position);
    int f = se_position2path_id(position);
    ds->p = position;
    if (se_trace_ready_flag) {
      if (se_write_trace_flag) {
	fprintf(se_trace_file,"line %d column %d in %s\n",l,c,p[f]);
	fflush(se_trace_file);
      }
    next_command:
      if (se_step_by_step_flag) {
	if (cmd_memo != 0) {
	  printf("(sedb) ");
	}
	fflush(stdout);
	cmd = get_answer();
	cmd_memo = cmd;
	if ((cmd == 'h') || (cmd == 'H') || (cmd == '?')) {
	  sedb_help_command();
	  goto next_command;
	}
	else if ((cmd == 's') || (cmd == 'S')) {
	  se_print_run_time_stack();
	  goto next_command;
	}
	else if ((cmd == 'q') || (cmd == 'Q')) {
	  exit(EXIT_FAILURE);
	}
	else if (cmd == 0) {
	  sedb_show_source_line(l,c,f);
	}
	else {
	  printf("Unknown command.\nTtype H for help\n");
	  goto next_command;
	}
      }
    }
    else {
      se_trace_ready_flag = 1;
      printf("Write the execution trace in \"trace.se\" file (y/n) ? [n]");
      fflush(stdout);
      if (get_answer() == 'y') {
	se_write_trace_flag = 1;
	se_trace_file = fopen("trace.se","w");
      }
      printf("Step-by-step execution (y/n) ? [y]");
      fflush(stdout);
      if (get_answer() == 'n') {
	se_step_by_step_flag = 0;
      }
      else {
	sedb_help_command();
      }
    }
  }
}
#endif

/* $Revision: 4303 $ */


/*
  This file (sys/runtime/exception.c) is automatically included 
  when exception handling is used somewhere in the live code.
*/

/*
  Miscellaneous Notes:
  We are currently using the old signal() system call instead of 
  the prefered sigaction() call.  
  
  On Linux systems at least, signal() is implemented by sigaction() 
  so it doesn't really matter.  Need to investigate this on other
  Unix systems.

  James Graves (ansible@xnet.com)
*/

/* 
   Top of the rescue context stack (or NULL if there is no current
   context) :
*/
struct rescue_context *rescue_context_top = NULL;

/* 
   Set to nonzero if the exception was internally generated, as with an
   assertion violation.  It is Os_signal (11) for an OS signal.
*/
int internal_exception_number;
int original_internal_exception_number;

/* 
   Set to nonzero if the exception was a signal (external).  It is 0
   for an internal exception.
*/
int signal_exception_number;

/*
   Used by some internal exceptions to print additional debugging
   information when the exception is not handled and a dump is done.
*/
char *additional_error_message;

static void critical_error_exit(void) {
/* This is called whenever a critical error in the SmallEiffel
   is encountered.  This kind of error cannot be handled by the
   exception handler.
   
   For instance, this routine is called if there is an error in the
   operation of the exception handler routines themselves.
*/
  fprintf(SE_ERR, "There was a critical error in the SmallEiffel runtime.\n");
  se_exit(EXIT_FAILURE);
}

void setup_signal_handler() {
/*
  Sets up the reception of signals.  If exception handling is enabled
  (by the existance of a rescue clause somewhere), then all OS signals
  now go to exception_handler instead of se_print_run_time_stack().
*/
#ifdef SIG_ERR
/* Check signal() call for errors.  Posix compliant systems should
   define SIG_ERR which is returned by signal() on an error. All Unix 
   signals are included except * for SIGKILL and SIGSTOP.  
   
   The other signals SmallEiffel traps for
   other OSs (like SIGBREAK) are not included here, but are below
   in the #else part, for non-Posix systems.
*/

#ifdef SIGHUP
   if ( SIG_ERR == signal( SIGHUP, signal_exception_handler ) ) 
      {
      fprintf(SE_ERR, "Error setting up signal handler for SIGHUP.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGINT
   if ( SIG_ERR == signal( SIGINT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGINT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGQUIT
   if ( SIG_ERR == signal( SIGQUIT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGQUIT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGILL
   if ( SIG_ERR == signal( SIGILL, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGILL.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTRAP
   if ( SIG_ERR == signal( SIGTRAP, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTRAP.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGIOT
   if ( SIG_ERR == signal( SIGIOT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGIOT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGBUS
   if ( SIG_ERR == signal( SIGBUS, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGBUS.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGFPE
   if ( SIG_ERR == signal( SIGFPE, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGFPE.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGUSR1
   if ( SIG_ERR == signal( SIGUSR1, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGUSR1.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGSEGV
   if ( SIG_ERR == signal( SIGSEGV, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGSEGV.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGUSR2
   if ( SIG_ERR == signal( SIGUSR2, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGUSR2.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGPIPE
   if ( SIG_ERR == signal( SIGPIPE, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGPIPE.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGALRM
   if ( SIG_ERR == signal( SIGALRM, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGALRM.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTERM
   if ( SIG_ERR == signal( SIGTERM, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTERM.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGCHLD
   if ( SIG_ERR == signal( SIGCHLD, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGCHLD.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGCONT
   if ( SIG_ERR == signal( SIGCONT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGCONT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTSTP
   if ( SIG_ERR == signal( SIGTSTP, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTSTP.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTTIN
   if ( SIG_ERR == signal( SIGTTIN, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTTIN.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTTOU
   if ( SIG_ERR == signal( SIGTTOU, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTTOU.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGURG
   if ( SIG_ERR == signal( SIGURG, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGURG.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGXCPU
   if ( SIG_ERR == signal( SIGXCPU, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGXCPU.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGXFSZ
   if ( SIG_ERR == signal( SIGXFSZ, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGXFSZ.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGVTALRM
   if ( SIG_ERR == signal( SIGVTALRM, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGVTALRM.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGPROF
   if ( SIG_ERR == signal( SIGPROF, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGPROF.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGWINCH
   if ( SIG_ERR == signal( SIGWINCH, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGWINCH.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGIO
   if ( SIG_ERR == signal( SIGIO, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGIO.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGPWR
   if ( SIG_ERR == signal( SIGPWR, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGPWR.\n");
      critical_error_exit();
      }
#endif
       
#else   /* SIG_ERR not defined, non-Posix system? */

/* These don't check return code for the signal() OS call.  Bad practice,
   but what can be done?  */

#ifdef SIGBREAK
   /* This signal does not exist on Unix systems. */
   signal( SIGBREAK, signal_exception_handler );
#endif

#ifdef SIGHUP
   signal( SIGHUP, signal_exception_handler );
#endif

#ifdef SIGINT
   signal( SIGINT, signal_exception_handler );
#endif

#ifdef SIGQUIT
   signal( SIGQUIT, signal_exception_handler );
#endif

#ifdef SIGILL
   signal( SIGILL, signal_exception_handler );
#endif

#ifdef SIGTRAP
   signal( SIGTRAP, signal_exception_handler );
#endif

#ifdef SIGIOT
   signal( SIGIOT, signal_exception_handler );
#endif

#ifdef SIGBUS
   signal( SIGBUS, signal_exception_handler );
#endif

#ifdef SIGFPE
   signal( SIGFPE, signal_exception_handler );
#endif

#ifdef SIGKILL
   /* This should silently fail on Unix systems, but is reported to work
      on other non-Unix systems.  You have been warned. */
   signal( SIGKILL, signal_exception_handler );
#endif

#ifdef SIGUSR1
   signal( SIGUSR1, signal_exception_handler );
#endif

#ifdef SIGSEGV
   signal( SIGSEGV, signal_exception_handler );
#endif

#ifdef SIGUSR2
   signal( SIGUSR2, signal_exception_handler );
#endif

#ifdef SIGPIPE
   signal( SIGPIPE, signal_exception_handler );
#endif

#ifdef SIGALRM
   signal( SIGALRM, signal_exception_handler );
#endif

#ifdef SIGTERM
   signal( SIGTERM, signal_exception_handler );
#endif

#ifdef SIGCHLD
   signal( SIGCHLD, signal_exception_handler );
#endif

#ifdef SIGCONT
   signal( SIGCONT, signal_exception_handler );
#endif

#ifdef SIGSTOP
   /* This should also silently fail on all Unix systems, but it may
      be effective on other OSs. */
   signal( SIGSTOP, signal_exception_handler );
#endif

#ifdef SIGTSTP
   signal( SIGTSTP, signal_exception_handler );
#endif

#ifdef SIGTTIN
   signal( SIGTTIN, signal_exception_handler );
#endif

#ifdef SIGTTOU
   signal( SIGTTOU, signal_exception_handler );
#endif

#ifdef SIGURG
   signal( SIGURG, signal_exception_handler );
#endif

#ifdef SIGXCPU
   signal( SIGXCPU, signal_exception_handler );
#endif

#ifdef SIGXFSZ
   signal( SIGXFSZ, signal_exception_handler );
#endif

#ifdef SIGTALRM
   signal( SIGTALRM, signal_exception_handler );
#endif

#ifdef SIGPROF
   signal( SIGPROF, signal_exception_handler );
#endif

#ifdef SIGWINCH
   signal( SIGWINCH, signal_exception_handler );
#endif

#ifdef SIGIO
   signal( SIGIO, signal_exception_handler );
#endif

#ifdef SIGPWR
   signal( SIGPWR, signal_exception_handler );
#endif

#endif  /* ifdef SIG_ERR */

}

#ifdef SE_CHECK
static void reset_assertion_checking(struct rescue_context * current_context) {
  /* Unwind the dump stack, resetting assertion checking when a rescue
     clause is invoked.  
     This function must be called just before the LONGJMP to the 
     enclosing rescue context.
  */
  while(se_dst!=current_context->top_of_ds){
    if(se_dst->fd!=NULL)se_dst->fd->assertion_flag=1;
    se_dst = se_dst->caller;
  }
}
#endif

void signal_exception_handler(int signal_number) {
  /* Set up to be called whenever an OS signal has been received.
     Checks to see if there is a rescue clause active (somewhere on the
     call stack), and if so, transfer control to that.
  */
  struct rescue_context *current_context;

#ifdef SIG_ERR
  /* some OS implementations automatically block a signal while
   * executing the signal handler, but some do not. */
  if ( SIG_ERR == signal( signal_number, SIG_IGN ) ) {
    fprintf(SE_ERR, "In signal_exception_handler: ");
    fprintf(SE_ERR, "Error turning off signal %d.\n", signal_number );
    critical_error_exit();
  }
#else
  signal( signal_number, SIG_IGN );
#endif

  internal_exception_number = Os_signal;
  original_internal_exception_number = 0;
  signal_exception_number = signal_number;
       
  if ( rescue_context_top != NULL ) {
    current_context = rescue_context_top;
    rescue_context_top = rescue_context_top->next;

    /* now re-enable that signal */
#ifdef SIG_ERR
    if ( SIG_ERR == signal( signal_number, signal_exception_handler ) ) {
      fprintf(SE_ERR, "In signal_exception_handler: ");
      fprintf(SE_ERR, "Error turning on signal %d.\n", signal_number );
      critical_error_exit();
    }
#else
    signal( signal_number, signal_exception_handler );
#endif

#ifdef SE_CHECK
    /* Unwind dump_stack structures PRIOR to jumping :
     */
    reset_assertion_checking(current_context) ;
#endif
    LONGJMP( current_context->jb, internal_exception_number );
  }

  /* No current rescue clause, exit with a dump : */
  print_exception();
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

void internal_exception_handler(int exception_number) {
  /* Called whenever an internal (to SmallEiffel) exception is to
     be raised (`raise' feature, assertion violation, etc.).  

     Checks to see if there is a current rescue clause (somewhere 
     in the call stack), and transfers control to it.
     Else exit with a stack trace (if enabled).
  */
  struct rescue_context *current_context;

  /* UNCOMMENT THIS PART TO DEBUG WITH EXCEPTION:
     print_exception(); se_print_run_time_stack();
  */



  /* If this is not a routine failure, clear out old exception
   * information. */
  if ( exception_number != Routine_failure ) {
    internal_exception_number = exception_number;
    original_internal_exception_number = 0;
    signal_exception_number = 0;
  }
  else {
    original_internal_exception_number = internal_exception_number;
  }

  if ( rescue_context_top != NULL ) {
    current_context = rescue_context_top;
    rescue_context_top = rescue_context_top->next;
#ifdef SE_CHECK
    /* Unwind dump_stack structures PRIOR to jumping :
     */
    reset_assertion_checking(current_context) ;
#endif
    LONGJMP( current_context->jb, exception_number );
  }
  
  /* No current rescue clause, exit with a dump : */
  print_exception();
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

#ifdef SE_CHECK
static void print_exception_case( int ex_num ) {
  switch( ex_num ) {
  case Check_instruction:
    fprintf(SE_ERR, "Check instruction failed.\n");
    break;
  case Class_invariant:
    fprintf(SE_ERR, "Class invariant not maintained.\n");
    break;
  case Developer_exception:
    fprintf(SE_ERR, "Developer exception:\n");
    break;
  case Incorrect_inspect_value:
    fprintf(SE_ERR, "Incorrect inspect value.\n");
    break;
  case Loop_invariant:
    fprintf(SE_ERR, "Loop invariant failed.\n");
    break;
  case Loop_variant:
    fprintf(SE_ERR, "Loop variant failed to decrease.\n");
    break;
  case No_more_memory:
    fprintf(SE_ERR, "Failed to allocate additional memory.\n");
    break;
  case Postcondition:
    fprintf(SE_ERR, "Postcondition (ensure clause) failed.\n");
    break;
  case Precondition:
    fprintf(SE_ERR, "Precondition (require clause) failed.\n");
    break;
  case Routine_failure:
    fprintf(SE_ERR, "Routine failure.\n");
    break;
  case Os_signal:
    fprintf(SE_ERR, "OS Signal (%d) received.\n", 
	    signal_exception_number );
    break;
  case Void_attached_to_expanded:
    fprintf(SE_ERR, "A Void became attached to an expanded object.\n");
    fprintf(SE_ERR, "Please report this problem to the SmallEiffel team.\n");
    break;
  case Void_call_target:
    fprintf(SE_ERR, "Feature call attempted on a Void reference.\n");
    break;
  default:
    fprintf(SE_ERR, "There was an unknown exception.\n");
    fprintf(SE_ERR, "Please report this problem to the SmallEiffel team.\n");
  }
}
#endif

void print_exception(void) {
  /* Display some information about last not handled exception. */
#ifdef SE_CHECK
  fprintf(SE_ERR,"Exception number %d not handled.\n",internal_exception_number);
  if ( internal_exception_number == Routine_failure ) {
    fprintf(SE_ERR, "Routine failure.  Original exception: \n");
    print_exception_case( original_internal_exception_number );
  }
  else {
    print_exception_case( internal_exception_number );
  }
  if ( additional_error_message != NULL ) {
    fprintf(SE_ERR, "%s\n", additional_error_message );
  }
#endif
}

/* $Revision: 4303 $ */



T6 r6_ix_not(se_dump_stack*caller,T6 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f6_ix_not;
ds.current=((void**)&C);
ds.p=12608792;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(C){
}
else{
(ds.p=12610074);
R=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_ix_not={"prefix not of BOOLEAN",1,1,"%E6%Result%E6%",1};


T6 r6_px_or(se_dump_stack*caller,T6 C,T6 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f6_px_or;
ds.current=((void**)&C);
ds.p=12602376;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=12604180);
R=(C)||(a1);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_px_or={"infix or of BOOLEAN",1,2,"%E6%other%E6%Result%E6%",1};


T6 r6_px_and(se_dump_stack*caller,T6 C,T6 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f6_px_and;
ds.current=((void**)&C);
ds.p=12597256;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=12599060);
R=(C)&&(a1);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_px_and={"infix and of BOOLEAN",1,2,"%E6%other%E6%Result%E6%",1};


T6 r3_px_6061(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3_px_6061;
ds.current=((void**)&C);
ds.p=6316296;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=6317076);
R=(T3code(C))<=(T3code(a1));
if(f3_px_6061.assertion_flag){
f3_px_6061.assertion_flag=0;
(ds.p=41961018);
ac_ens((R)==(r6_px_or(&ds,r3_px_60(&ds,C,a1),r3is_equal(&ds,C,a1))),"definition");
f3_px_6061.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3_px_6061={"infix <= of CHARACTER",1,2,"%E3%other%E3%Result%E6%",1};


T6 r3is_equal(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3is_equal;
ds.current=((void**)&C);
ds.p=41955080;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=41955590);
R=(r6_ix_not(&ds,r3_px_60(&ds,C,a1)))&&(r6_ix_not(&ds,r3_px_60(&ds,a1,C)));
if(f3is_equal.assertion_flag){
f3is_equal.assertion_flag=0;
(ds.p=41956140);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,r3_px_60(&ds,C,a1)),r6_ix_not(&ds,r3_px_60(&ds,a1,C)))),"trichotomy");
(ds.p=2139486);
ac_ens((!((C)==(a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r3is_equal(&ds,a1,C)),"symmetric");
f3is_equal.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3is_equal={"is_equal of COMPARABLE",1,2,"%E3%other%E3%Result%E6%",1};


T6 r3is_digit(se_dump_stack*caller,T3 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3is_digit;
ds.current=((void**)&C);
ds.p=6347016;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(((ds.p=6347818),r3_px_6261(&ds,C,((T3)'0')))){
(ds.p=6348058);
R=r3_px_6061(&ds,C,((T3)'9'));
}
if(f3is_digit.assertion_flag){
f3is_digit.assertion_flag=0;
(ds.p=6348832);
ac_ens((R)==(r3in_range(&ds,C,((T3)'0'),((T3)'9'))),NULL);
f3is_digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3is_digit={"is_digit of CHARACTER",1,1,"%E3%Result%E6%",1};


T6 r3is_separator(se_dump_stack*caller,T3 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3is_separator;
ds.current=((void**)&C);
ds.p=6363912;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
/*[INSPECT*/
{int z1=C;
switch(z1){
case 0:
case 9:
case 10:
case 12:
case 13:
case 32:
(ds.p=6365466);
R=1;
break;
}
}/*INSPECT]*/
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3is_separator={"is_separator of CHARACTER",1,1,"%E3%Result%E6%",1};


T6 r3in_range(se_dump_stack*caller,T3 C,T3 a1,T3 a2){
T6 R=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f3in_range;
ds.current=((void**)&C);
ds.p=41966856;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=41967636);
R=(r3_px_6261(&ds,C,a1))&&(r3_px_6061(&ds,C,a2));
if(f3in_range.assertion_flag){
f3in_range.assertion_flag=0;
(ds.p=41968162);
ac_ens((R)==(r6_px_and(&ds,r3_px_6261(&ds,C,a1),r3_px_6061(&ds,C,a2))),NULL);
f3in_range.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3in_range={"in_range of COMPARABLE",1,3,"%E3%lower%E3%upper%E3%Result%E6%",1};


T6 r3_px_6261(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3_px_6261;
ds.current=((void**)&C);
ds.p=6319368;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=6320148);
R=(T3code(C))>=(T3code(a1));
if(f3_px_6261.assertion_flag){
f3_px_6261.assertion_flag=0;
(ds.p=41966138);
ac_ens((R)==(r3_px_6061(&ds,a1,C)),"definition");
f3_px_6261.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3_px_6261={"infix >= of CHARACTER",1,2,"%E3%other%E3%Result%E6%",1};


T2 r3value(se_dump_stack*caller,T3 C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3value;
ds.current=((void**)&C);
ds.p=6320904;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f3value.assertion_flag){
f3value.assertion_flag=0;
(ds.p=6321684);
ac_req(r3is_digit(&ds,C),NULL);
f3value.assertion_flag=1;
}
(ds.p=6322196);
R=(T3code(C))-(T3code(((T3)'0')));
if(f3value.assertion_flag){
f3value.assertion_flag=0;
(ds.p=6322722);
ac_ens(r2in_range(&ds,R,0,9),NULL);
f3value.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3value={"value of CHARACTER",1,1,"%E3%Result%E2%",1};


T6 r3_px_60(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3_px_60;
ds.current=((void**)&C);
ds.p=6314760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=6315540);
R=(T3code(C))<(T3code(a1));
if(f3_px_60.assertion_flag){
f3_px_60.assertion_flag=0;
(ds.p=41958458);
ac_ens((!(R))||(r6_ix_not(&ds,r3_px_60(&ds,a1,C))),"asymmetric");
f3_px_60.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3_px_60={"infix < of CHARACTER",1,2,"%E3%other%E3%Result%E6%",1};


T2 r3decimal_value(se_dump_stack*caller,T3 C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3decimal_value;
ds.current=((void**)&C);
ds.p=6320904;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f3decimal_value.assertion_flag){
f3decimal_value.assertion_flag=0;
(ds.p=6321684);
ac_req(r3is_digit(&ds,C),NULL);
f3decimal_value.assertion_flag=1;
}
(ds.p=6322196);
R=(T3code(C))-(T3code(((T3)'0')));
if(f3decimal_value.assertion_flag){
f3decimal_value.assertion_flag=0;
(ds.p=6322722);
ac_ens(r2in_range(&ds,R,0,9),NULL);
f3decimal_value.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3decimal_value={"decimal_value (value of CHARACTER)",1,1,"%E3%Result%E2%",1};


T6 r2is_equal(se_dump_stack*caller,T2 C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f2is_equal;
ds.current=((void**)&C);
ds.p=41955080;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=41955590);
R=(r6_ix_not(&ds,(C)<(a1)))&&(r6_ix_not(&ds,(a1)<(C)));
if(f2is_equal.assertion_flag){
f2is_equal.assertion_flag=0;
(ds.p=2139486);
ac_ens((!((C)==(a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r2is_equal(&ds,a1,C)),"symmetric");
(ds.p=41956140);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,(C)<(a1)),r6_ix_not(&ds,(a1)<(C)))),"trichotomy");
f2is_equal.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2is_equal={"is_equal of COMPARABLE",1,2,"%E2%other%E2%Result%E6%",1};


T6 r2divisible(se_dump_stack*caller,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f2divisible;
ds.current=NULL;
ds.p=48267784;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=48268308);
R=((/*RF2*/a1))!=(0);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2divisible={"divisible of INTEGER_REF",0,2,"other%E2%Result%E6%",1};


T6 r2in_range(se_dump_stack*caller,T2 C,T2 a1,T2 a2){
T6 R=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f2in_range;
ds.current=((void**)&C);
ds.p=41966856;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=41967636);
R=((C)>=(a1))&&((C)<=(a2));
if(f2in_range.assertion_flag){
f2in_range.assertion_flag=0;
(ds.p=41968162);
ac_ens((R)==(r6_px_and(&ds,(C)>=(a1),(C)<=(a2))),NULL);
f2in_range.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2in_range={"in_range of COMPARABLE",1,3,"%E2%lower%E2%upper%E2%Result%E6%",1};


void r2store(se_dump_stack*caller,T2 C,T0* a1){
T2 _dec=0;
T2 _val=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f2store;
ds.current=((void**)&C);
ds.p=4389896;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dec;
locals[2]=(void**)&_val;
se_dst=&ds;/*link*/
if(((ds.p=4391216),(C)<(0))){
(ds.p=4391470);
X27put_character(&ds,4391456,a1,((T3)'\55'));
if(((ds.p=4391734),(C)<(-(9)))){
(ds.p=4391974);
_dec=-(10);
}
else{
(ds.p=4392486);
_dec=-(1);
}
}
else{
(ds.p=4393248);
_dec=1;
}
while (!(((ds.p=4394044),((C)/(_dec))<(10))))
{
(ds.p=4394522);
_dec=(_dec)*(10);
}
(ds.p=4395546);
_val=C;
if(f2store.assertion_flag){
f2store.assertion_flag=0;
(ds.p=4396066);
ac_liv((_dec)!=(0),NULL);
f2store.assertion_flag=1;
}
while (!(((ds.p=4396586),r6_px_or(&ds,(_dec)==(1),(_dec)==(-(1))))))
{
(ds.p=4397096);
X27put_character(&ds,4397082,a1,r2digit(&ds,(_val)/(_dec)));
(ds.p=4397338);
_val=(_val)%(_dec);
(ds.p=4397594);
_dec=(_dec)/(10);
if(f2store.assertion_flag){
f2store.assertion_flag=0;
(ds.p=4396066);
ac_liv((_dec)!=(0),NULL);
f2store.assertion_flag=1;
}
}
(ds.p=4398370);
X27put_character(&ds,4398356,a1,r2digit(&ds,(_val)/(_dec)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f2store={"store of INTEGER",1,3,"%E2%stream%R27%dec%E2%val%E2%",1};


T3 r2digit(se_dump_stack*caller,T2 C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f2digit;
ds.current=((void**)&C);
ds.p=4359944;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f2digit.assertion_flag){
f2digit.assertion_flag=0;
(ds.p=4360724);
ac_req(r2in_range(&ds,C,0,9),NULL);
f2digit.assertion_flag=1;
}
(ds.p=4361236);
R=((T3)((C)+(T3code(((T3)'0')))));
if(f2digit.assertion_flag){
f2digit.assertion_flag=0;
(ds.p=4361778);
ac_ens(r7has(&ds,ms2_117797837,R),NULL);
(ds.p=4362030);
ac_ens((r3value(&ds,R))==(C),NULL);
f2digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2digit={"digit (decimal_digit of INTEGER)",1,1,"%E2%Result%E3%",1};


void r2append_in(se_dump_stack*caller,T2 C,T0* a1){
T2 _dec=0;
T2 _val=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f2append_in;
ds.current=((void**)&C);
ds.p=4295944;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dec;
locals[2]=(void**)&_val;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f2append_in.assertion_flag){
f2append_in.assertion_flag=0;
(ds.p=4296994);
ac_req((a1)!=((void*)(NULL)),NULL);
f2append_in.assertion_flag=1;
}
if(((ds.p=4298288),(C)<(0))){
(ds.p=4298542);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,a1,4298528))),((T3)'\55'));
if(((ds.p=4298806),(C)<(-(9)))){
(ds.p=4299046);
_dec=-(10);
}
else{
(ds.p=4299558);
_dec=-(1);
}
}
else{
(ds.p=4300320);
_dec=1;
}
while (!(((ds.p=4301116),((C)/(_dec))<(10))))
{
(ds.p=4301594);
_dec=(_dec)*(10);
}
(ds.p=4302618);
_val=C;
if(f2append_in.assertion_flag){
f2append_in.assertion_flag=0;
(ds.p=4303138);
ac_liv((_dec)!=(0),NULL);
f2append_in.assertion_flag=1;
}
while (!(((ds.p=4303658),r6_px_or(&ds,(_dec)==(1),(_dec)==(-(1))))))
{
(ds.p=4304168);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,a1,4304154))),r2digit(&ds,(_val)/(_dec)));
(ds.p=4304410);
_val=(_val)%(_dec);
(ds.p=4304666);
_dec=(_dec)/(10);
if(f2append_in.assertion_flag){
f2append_in.assertion_flag=0;
(ds.p=4303138);
ac_liv((_dec)!=(0),NULL);
f2append_in.assertion_flag=1;
}
}
(ds.p=4305442);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,a1,4305428))),r2digit(&ds,(_val)/(_dec)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f2append_in={"append_in of INTEGER",1,3,"%E2%buffer%R7%dec%E2%val%E2%",1};


T6 r37is_not_null(se_dump_stack*caller,T37 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f37is_not_null;
ds.current=((void**)&C);
ds.p=63064072;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=63064596);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f37is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E37%Result%E6%",1};


void r37clear(se_dump_stack*caller,T37 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f37clear;
ds.current=((void**)&C);
ds.p=63017480;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f37clear.assertion_flag){
f37clear.assertion_flag=0;
(ds.p=63018528);
ac_req((a1)>=(0),NULL);
(ds.p=63018784);
ac_req((a2)>=(a1),NULL);
f37clear.assertion_flag=1;
}
(ds.p=63020314);
_i=a1;
while (!(((ds.p=63020830),(_i)>(a2))))
{
(ds.p=63021338);
(C)[_i]=(_v);
(ds.p=63021594);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f37clear={"clear of NATIVE_ARRAY",1,4,"%E37%lower%E2%upper%E2%i%E2%v%R7%",1};


T6 r37all_default(se_dump_stack*caller,T37 C,T2 a1){
T6 R=0;
T0* _model=NULL;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f37all_default;
ds.current=((void**)&C);
ds.p=63054088;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_model;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f37all_default.assertion_flag){
f37all_default.assertion_flag=0;
(ds.p=63055136);
ac_req((a1)>=(-(1)),NULL);
f37all_default.assertion_flag=1;
}
(ds.p=63056666);
R=1;
(ds.p=63056922);
_i=a1;
while (!(((ds.p=63057446),((_i)<(0))||(r6_ix_not(&ds,R)))))
{
(ds.p=63057946);
R=(_model)==((void*)((C)[_i]));
(ds.p=63058202);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f37all_default={"all_default of NATIVE_ARRAY",1,4,"%E37%upper%E2%Result%E6%model%R7%i%E2%",1};


T9 r9realloc(se_dump_stack*caller,T9 C,T2 a1,T2 a2){
T9 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f9realloc;
ds.current=((void**)&C);
ds.p=62937608;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9realloc.assertion_flag){
f9realloc.assertion_flag=0;
(ds.p=62939412);
ac_req(r9is_not_null(&ds,C),NULL);
(ds.p=62939692);
ac_req((a1)>(0),NULL);
(ds.p=62939948);
ac_req((a1)<(a2),NULL);
f9realloc.assertion_flag=1;
}
(ds.p=62940436);
R=((T9)(se_calloc(a2,sizeof(T3))));
(ds.p=62940706);
r9copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9realloc={"realloc of NATIVE_ARRAY",1,3,"%E9%old_nb_elts%E2%new_nb_elts%E2%Result%E9%",1};


T6 r9fast_memcmp(se_dump_stack*caller,T9 C,T9 a1,T2 a2){
T6 R=0;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f9fast_memcmp;
ds.current=((void**)&C);
ds.p=62947080;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9fast_memcmp.assertion_flag){
f9fast_memcmp.assertion_flag=0;
(ds.p=62947886);
ac_req((!((a2)>(0)))||(r9is_not_null(&ds,a1)),NULL);
f9fast_memcmp.assertion_flag=1;
}
(ds.p=62949146);
_i=(a2)-(1);
while (!(((ds.p=62949670),((_i)<(0))||(((C)[_i])!=((a1)[_i])))))
{
(ds.p=62950170);
_i=(_i)-(1);
}
(ds.p=62950676);
R=(_i)<(0);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9fast_memcmp={"fast_memcmp of NATIVE_ARRAY",1,4,"%E9%other%E9%capacity%E2%Result%E6%i%E2%",1};


T6 r9fast_has(se_dump_stack*caller,T9 C,T3 a1,T2 a2){
T6 R=0;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f9fast_has;
ds.current=((void**)&C);
ds.p=62970888;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9fast_has.assertion_flag){
f9fast_has.assertion_flag=0;
(ds.p=62971936);
ac_req((a2)>=(-(1)),NULL);
f9fast_has.assertion_flag=1;
}
(ds.p=62973210);
_i=a2;
while (!(((ds.p=62973734),((_i)<(0))||((a1)==((C)[_i])))))
{
(ds.p=62974234);
_i=(_i)-(1);
}
(ds.p=62974740);
R=(_i)>=(0);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9fast_has={"fast_has of NATIVE_ARRAY",1,4,"%E9%element%E3%upper%E2%Result%E6%i%E2%",1};


void r9copy_at(se_dump_stack*caller,T9 C,T2 a1,T9 a2,T2 a3){
T2 _i2=0;
T2 _i1=0;
void**locals[5];
se_dump_stack ds;
ds.fd=&f9copy_at;
ds.current=((void**)&C);
ds.p=62997512;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&a3;
locals[3]=(void**)&_i2;
locals[4]=(void**)&_i1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9copy_at.assertion_flag){
f9copy_at.assertion_flag=0;
(ds.p=62998810);
ac_req((a1)>=(0),NULL);
(ds.p=62999086);
ac_req((a3)>=(0),NULL);
f9copy_at.assertion_flag=1;
}
(ds.p=63000346);
_i1=a1;
while (!(((ds.p=63000864),(_i2)==(a3))))
{
(ds.p=63001370);
(C)[_i1]=((a2)[_i2]);
(ds.p=63001626);
_i2=(_i2)+(1);
(ds.p=63001882);
_i1=(_i1)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f9copy_at={"copy_at of NATIVE_ARRAY",1,5,"%E9%at%E2%src%E9%src_capacity%E2%i2%E2%i1%E2%",1};


T6 r9is_not_null(se_dump_stack*caller,T9 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f9is_not_null;
ds.current=((void**)&C);
ds.p=63064072;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=63064596);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E9%Result%E6%",1};


void r9copy_from(se_dump_stack*caller,T9 C,T9 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f9copy_from;
ds.current=((void**)&C);
ds.p=63022600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=63024154);
_i=a2;
while (!(((ds.p=63024670),(_i)<(0))))
{
(ds.p=63025178);
(C)[_i]=((a1)[_i]);
(ds.p=63025434);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f9copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E9%model%E9%upper%E2%i%E2%",1};


void r7copy(se_dump_stack*caller,T7* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f7copy;
ds.current=((void**)&C);
ds.p=14999304;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=0;
se_require_last_result=1;
if(f7copy.assertion_flag){
f7copy.assertion_flag=0;
(ds.p=15000102);
ac_req(r7is_mutable(&ds,C),"mutable");
f7copy.assertion_flag=1;
}
se_require_uppermost_flag=1;
if(!se_require_last_result){
se_require_last_result=1;
if(f7copy.assertion_flag){
f7copy.assertion_flag=0;
(ds.p=2160704);
ac_req((a1)!=((void*)(NULL)),"other_not_void");
f7copy.assertion_flag=1;
}
}
(ds.p=15000596);
(/*SFN*/C->_count)=(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15000614))))->_count/*12*/);
if(((ds.p=15000870),((/*RF2*/(C)->_count/*12*/))>(0))){
if(((ds.p=15001138),((/*RF2*/(C)->_capacity/*16*/))<((/*RF2*/(C)->_count/*12*/)))){
(ds.p=15001376);
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_count/*12*/),sizeof(T3))));
(ds.p=15001632);
(/*SFN*/C->_capacity)=(/*RF2*/(C)->_count/*12*/);
}
(ds.p=15002154);
r9copy_from(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15002174))))->_storage/*4*/),((/*RF2*/(C)->_count/*12*/))-(1));
}
if(f7copy.assertion_flag){
f7copy.assertion_flag=0;
(ds.p=15002912);
ac_ens(((/*RF2*/(C)->_count/*12*/))==((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15002916))))->_count/*12*/)),NULL);
(ds.p=2161448);
ac_ens(r7is_equal(&ds,C,a1),"is_equal");
f7copy.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7copy={"copy of STRING",1,1,"%R7%other%R7%",1};


T3 r7last(se_dump_stack*caller,T7* C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7last;
ds.current=((void**)&C);
ds.p=15155208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7last.assertion_flag){
f7last.assertion_flag=0;
(ds.p=15155988);
ac_req(r6_ix_not(&ds,r7is_empty(&ds,C)),NULL);
f7last.assertion_flag=1;
}
(ds.p=15156500);
R=((/*RF2*/(C)->_storage/*4*/))[((/*RF2*/(C)->_count/*12*/))-(1)];
if(f7last.assertion_flag){
f7last.assertion_flag=0;
(ds.p=15157036);
ac_ens((R)==(r7item(&ds,C,(/*RF2*/(C)->_count/*12*/))),"definition");
f7last.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7last={"last of STRING",1,1,"%R7%Result%E3%",1};


T2 r7upper(se_dump_stack*caller,T7* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7upper;
ds.current=((void**)&C);
ds.p=14724104;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14725126);
R=(/*RF2*/(C)->_count/*12*/);
if(f7upper.assertion_flag){
f7upper.assertion_flag=0;
(ds.p=14725652);
ac_ens((R)==((/*RF2*/(C)->_count/*12*/)),NULL);
f7upper.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7upper={"upper of STRING",1,1,"%R7%Result%E2%",1};


T6 r7is_equal(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7is_equal;
ds.current=((void**)&C);
ds.p=14774792;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7is_equal.assertion_flag){
f7is_equal.assertion_flag=0;
(ds.p=2138688);
ac_req((a1)!=((void*)(NULL)),"other_not_void");
f7is_equal.assertion_flag=1;
}
if(((ds.p=14775846),((/*RF2*/(C)->_count/*12*/))==((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14775850))))->_count/*12*/)))){
(ds.p=14776090);
R=r9fast_memcmp(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14776150))))->_storage/*4*/),(/*RF2*/(C)->_count/*12*/));
}
if(f7is_equal.assertion_flag){
f7is_equal.assertion_flag=0;
(ds.p=41956140);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,r7_px_60(&ds,se_i7(&ds,C),a1)),r6_ix_not(&ds,r7_px_60(&ds,se_i7(&ds,((T7*)ci(7,a1,41956208))),(T0*)C)))),"trichotomy");
(ds.p=2139486);
ac_ens((!(r7standard_is_equal(&ds,C,a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,a1,2139720))),(T0*)C)),"symmetric");
f7is_equal.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_equal={"is_equal of STRING",1,2,"%R7%other%R7%Result%E6%",1};


T3 r7item(se_dump_stack*caller,T7* C,T2 a1){
T3 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7item;
ds.current=((void**)&C);
ds.p=14753544;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7item.assertion_flag){
f7item.assertion_flag=0;
(ds.p=14754350);
ac_req(r7valid_index(&ds,C,a1),"valid_index");
f7item.assertion_flag=1;
}
(ds.p=14754836);
R=((/*RF2*/(C)->_storage/*4*/))[(a1)-(1)];
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7item={"item of STRING",1,2,"%R7%i%E2%Result%E3%",1};


T6 r7valid_index(se_dump_stack*caller,T7* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7valid_index;
ds.current=((void**)&C);
ds.p=14755592;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14756372);
R=((1)<=(a1))&&((a1)<=(r7upper(&ds,C)));
if(f7valid_index.assertion_flag){
f7valid_index.assertion_flag=0;
(ds.p=14756922);
ac_ens((R)==(r6_px_and(&ds,(1)<=(a1),(a1)<=(r7upper(&ds,C)))),"definition");
f7valid_index.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7valid_index={"valid_index of STRING",1,2,"%R7%i%E2%Result%E6%",1};


void r7append(se_dump_stack*caller,T7* C,T0* a1){
T2 _new_capacity=0;
T2 _needed_capacity=0;
T2 _s_count=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f7append;
ds.current=((void**)&C);
ds.p=15025928;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&_needed_capacity;
locals[3]=(void**)&_s_count;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7append.assertion_flag){
f7append.assertion_flag=0;
(ds.p=15026726);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=15026992);
ac_req((a1)!=((void*)(NULL)),"s_not_void");
f7append.assertion_flag=1;
}
(ds.p=15028230);
_s_count=(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15028252))))->_count/*12*/);
(ds.p=15028500);
_needed_capacity=((/*RF2*/(C)->_count/*12*/))+(_s_count);
if(((ds.p=15028794),(_needed_capacity)>((/*RF2*/(C)->_capacity/*16*/)))){
if(((ds.p=15029042),((/*RF2*/(C)->_capacity/*16*/))==(0))){
(ds.p=15029280);
(/*SFN*/C->_storage)=((T9)(se_calloc(_needed_capacity,sizeof(T3))));
(ds.p=15029536);
(/*SFN*/C->_capacity)=_needed_capacity;
}
else{
(ds.p=15030048);
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*16*/));
if(((ds.p=15030342),(_needed_capacity)>(_new_capacity))){
(ds.p=15030566);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*16*/),_needed_capacity);
(ds.p=15030822);
(/*SFN*/C->_capacity)=_needed_capacity;
}
else{
(ds.p=15031334);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*16*/),_new_capacity);
(ds.p=15031590);
(/*SFN*/C->_capacity)=_new_capacity;
}
}
}
(ds.p=15032612);
r9copy_at(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_count/*12*/),(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15032640))))->_storage/*4*/),_s_count);
(ds.p=15032852);
(/*SFN*/C->_count)=_needed_capacity;
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7append={"append of STRING",1,4,"%R7%s%R7%new_capacity%E2%needed_capacity%E2%s_count%E2%",1};


T6 r7is_integer(se_dump_stack*caller,T7* C){
T6 R=0;
T3 _cc=0;
T6 _negative=0;
T2 _value=0;
T2 _state=0;
T2 _i=0;
void**locals[6];
se_dump_stack ds;
ds.fd=&f7is_integer;
ds.current=((void**)&C);
ds.p=14821384;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
locals[1]=(void**)&_cc;
locals[2]=(void**)&_negative;
locals[3]=(void**)&_value;
locals[4]=(void**)&_state;
locals[5]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=14828058);
_i=1;
while (!(((ds.p=14828590),((_state)==(4))||((_i)>((/*RF2*/(C)->_count/*12*/))))))
{
(ds.p=14829082);
_cc=r7item(&ds,C,_i);
/*[INSPECT*/
{int z1=_state;
switch(z1){
case 0:
if(((ds.p=14830124),r3is_separator(&ds,_cc))){
}
 else if(((ds.p=14830388),(_cc)==(((T3)'\53')))){
(ds.p=14830630);
_state=1;
}
 else if(((ds.p=14830900),(_cc)==(((T3)'\55')))){
(ds.p=14831142);
_negative=1;
(ds.p=14831398);
_state=1;
}
 else if(((ds.p=14831668),r3is_digit(&ds,_cc))){
(ds.p=14831910);
_value=r3decimal_value(&ds,r7item(&ds,C,_i));
(ds.p=14832166);
_state=2;
}
else{
(ds.p=14832678);
_state=4;
}
break;
case 1:
if(((ds.p=14833452),r3is_digit(&ds,_cc))){
(ds.p=14833702);
_value=r3decimal_value(&ds,r7item(&ds,C,_i));
if(_negative){
(ds.p=14834220);
_value=(-(1))*(_value);
}
(ds.p=14834726);
_state=2;
}
else{
(ds.p=14835238);
_state=4;
}
break;
case 2:
if(((ds.p=14836012),r3is_digit(&ds,_cc))){
if(_negative){
(ds.p=14836524);
_value=((10)*(_value))-(r3decimal_value(&ds,r7item(&ds,C,_i)));
}
else{
(ds.p=14837036);
_value=((10)*(_value))+(r3decimal_value(&ds,r7item(&ds,C,_i)));
}
if(((ds.p=14838060),((_negative)&&((_value)>(0)))||((r6_ix_not(&ds,_negative))&&((_value)<(0))))){
(ds.p=14838316);
_state=4;
}
}
 else if(((ds.p=14838836),r3is_separator(&ds,_cc))){
(ds.p=14839078);
_state=3;
}
else{
(ds.p=14839590);
_state=4;
}
break;
case 3:
if(((ds.p=14840364),r3is_separator(&ds,_cc))){
}
else{
(ds.p=14840870);
_state=4;
}
break;
default:;
internal_exception_handler(Incorrect_inspect_value);
}
}/*INSPECT]*/
(ds.p=14841626);
_i=(_i)+(1);
}
if(((ds.p=14842146),((_state)!=(0))&&((_state)!=(4)))){
(ds.p=14842394);
R=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_integer={"is_integer of STRING",1,6,"%R7%Result%E6%cc%E3%negative%E6%value%E2%state%E2%i%E2%",1};


void r7make(se_dump_stack*caller,T7* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f7make;
ds.current=((void**)&C);
ds.p=14728456;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7make.assertion_flag){
f7make.assertion_flag=0;
(ds.p=14729510);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=14729818);
ac_req((a1)>=(0),"non_negative_size");
f7make.assertion_flag=1;
}
if(((ds.p=14730298),(a1)>(0))){
if(((ds.p=14730546),((/*RF2*/(C)->_capacity/*16*/))<(a1))){
(ds.p=14730784);
(/*SFN*/C->_storage)=((T9)(se_calloc(a1,sizeof(T3))));
(ds.p=14731040);
(/*SFN*/C->_capacity)=a1;
}
}
(ds.p=14731796);
(/*SFN*/C->_count)=0;
if(f7make.assertion_flag){
f7make.assertion_flag=0;
(ds.p=14732340);
ac_ens((a1)<=((/*RF2*/(C)->_capacity/*16*/)),NULL);
(ds.p=14732604);
ac_ens(((/*RF2*/(C)->_count/*12*/))==(0),"empty_string");
f7make.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7make={"make of STRING",1,1,"%R7%needed_capacity%E2%",1};


T6 r7is_empty(se_dump_stack*caller,T7* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7is_empty;
ds.current=((void**)&C);
ds.p=14750472;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14751252);
R=((/*RF2*/(C)->_count/*12*/))==(0);
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_empty={"is_empty of STRING",1,1,"%R7%Result%E6%",1};


T6 r7is_mutable(se_dump_stack*caller,T7* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7is_mutable;
ds.current=((void**)&C);
ds.p=14747912;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14748436);
R=((/*RF2*/(C)->_key/*20*/))==(0);
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_mutable={"is_mutable of STRING",1,1,"%R7%Result%E6%",1};


void r7extend(se_dump_stack*caller,T7* C,T3 a1){
T2 _new_capacity=0;
T2 o7_1524_26=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f7extend;
ds.current=((void**)&C);
ds.p=15065352;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&o7_1524_26;
se_dst=&ds;/*link*/
o7_1524_26=(/*RF2*/(C)->_count/*12*/);
se_require_uppermost_flag=1;
if(f7extend.assertion_flag){
f7extend.assertion_flag=0;
(ds.p=15066150);
ac_req(r7is_mutable(&ds,C),"mutable");
f7extend.assertion_flag=1;
}
if(((ds.p=15067180),((/*RF2*/(C)->_capacity/*16*/))>((/*RF2*/(C)->_count/*12*/)))){
}
 else if(((ds.p=15067444),((/*RF2*/(C)->_capacity/*16*/))==(0))){
(ds.p=15067674);
(/*SFN*/C->_capacity)=32;
(ds.p=15067930);
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_capacity/*16*/),sizeof(T3))));
}
else{
(ds.p=15068442);
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*16*/));
(ds.p=15068698);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*16*/),_new_capacity);
(ds.p=15068954);
(/*SFN*/C->_capacity)=_new_capacity;
}
(ds.p=15069476);
((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_count/*12*/)]=(a1);
(ds.p=15069716);
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*12*/))+(1);
if(f7extend.assertion_flag){
f7extend.assertion_flag=0;
(ds.p=15070240);
ac_ens(((/*RF2*/(C)->_count/*12*/))==((1)+(o7_1524_26)),NULL);
(ds.p=15070510);
ac_ens((r7item(&ds,C,(/*RF2*/(C)->_count/*12*/)))==(a1),NULL);
f7extend.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7extend={"extend (add_last of STRING)",1,3,"%R7%c%E3%new_capacity%E2%old l1524c26STRING%E2%",1};


T6 r7_px_60(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f7_px_60;
ds.current=((void**)&C);
ds.p=14762504;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7_px_60.assertion_flag){
f7_px_60.assertion_flag=0;
(ds.p=41957692);
ac_req((a1)!=((void*)(NULL)),"other_exists");
f7_px_60.assertion_flag=1;
}
(ds.p=14764058);
_i=1;
while (!(((ds.p=14764826),((((/*RF2*/(C)->_count/*12*/))<(_i))||(((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14764606))))->_count/*12*/))<(_i)))||((r7item(&ds,C,_i))!=(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,14764864))),_i))))))
{
(ds.p=14765338);
_i=(_i)+(1);
}
if(((ds.p=14765862),((/*RF2*/(C)->_count/*12*/))<(_i))){
(ds.p=14766106);
R=((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14766126))))->_count/*12*/))>=(_i);
}
 else if(((ds.p=14766394),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14766370))))->_count/*12*/))<(_i))){
(ds.p=14766618);
R=0;
}
else{
(ds.p=14767130);
R=r3_px_60(&ds,r7item(&ds,C,_i),r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,14767170))),_i));
}
if(f7_px_60.assertion_flag){
f7_px_60.assertion_flag=0;
(ds.p=41958458);
ac_ens((!(R))||(r6_ix_not(&ds,r7_px_60(&ds,se_i7(&ds,((T7*)ci(7,a1,41958484))),(T0*)C))),"asymmetric");
f7_px_60.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7_px_60={"infix < of STRING",1,3,"%R7%other%R7%Result%E6%i%E2%",1};


T6 r7standard_is_equal(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7standard_is_equal;
ds.current=((void**)&C);
ds.p=2145046;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7standard_is_equal.assertion_flag){
f7standard_is_equal.assertion_flag=0;
(ds.p=2145824);
ac_req((a1)!=((void*)(NULL)),NULL);
f7standard_is_equal.assertion_flag=1;
}
R=((C->id==a1->id)?!memcmp(C,a1,sizeof(*C)):0);if(f7standard_is_equal.assertion_flag){
f7standard_is_equal.assertion_flag=0;
(ds.p=2146616);
ac_ens((!(R))||(r7standard_is_equal(&ds,se_i7(&ds,((T7*)ci(7,a1,2146632))),(T0*)C)),"symmetric");
f7standard_is_equal.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7standard_is_equal={"standard_is_equal of GENERAL",1,2,"%R7%other%R7%Result%E6%",1};


T6 r7has(se_dump_stack*caller,T7* C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7has;
ds.current=((void**)&C);
ds.p=14801160;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14801940);
R=r9fast_has(&ds,(/*RF2*/(C)->_storage/*4*/),a1,((/*RF2*/(C)->_count/*12*/))-(1));
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7has={"has of STRING",1,2,"%R7%c%E3%Result%E6%",1};


T2 r7to_integer(se_dump_stack*caller,T7* C){
T2 R=0;
T6 _negative=0;
T3 _cc=0;
T2 _state=0;
T2 _i=0;
void**locals[5];
se_dump_stack ds;
ds.fd=&f7to_integer;
ds.current=((void**)&C);
ds.p=14843400;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
locals[1]=(void**)&_negative;
locals[2]=(void**)&_cc;
locals[3]=(void**)&_state;
locals[4]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7to_integer.assertion_flag){
f7to_integer.assertion_flag=0;
(ds.p=14844180);
ac_req(r7is_integer(&ds,C),NULL);
f7to_integer.assertion_flag=1;
}
(ds.p=14847258);
_i=1;
while (!(((ds.p=14847774),(_i)>((/*RF2*/(C)->_count/*12*/)))))
{
(ds.p=14848282);
_cc=r7item(&ds,C,_i);
/*[INSPECT*/
{int z1=_state;
switch(z1){
case 0:
if(((ds.p=14849324),r3is_separator(&ds,_cc))){
}
 else if(((ds.p=14849588),(_cc)==(((T3)'\53')))){
(ds.p=14849830);
_state=1;
}
 else if(((ds.p=14850100),(_cc)==(((T3)'\55')))){
(ds.p=14850342);
_negative=1;
(ds.p=14850598);
_state=1;
}
else{
(ds.p=14851110);
R=r3value(&ds,_cc);
(ds.p=14851366);
_state=2;
}
break;
case 1:
(ds.p=14852384);
R=r3value(&ds,_cc);
if(_negative){
(ds.p=14852908);
R=(-(1))*(R);
}
(ds.p=14853408);
_state=2;
break;
case 2:
if(((ds.p=14853932),r3is_digit(&ds,_cc))){
if(_negative){
(ds.p=14854444);
R=((10)*(R))-(r3decimal_value(&ds,r7item(&ds,C,_i)));
}
else{
(ds.p=14854956);
R=((10)*(R))+(r3decimal_value(&ds,r7item(&ds,C,_i)));
}
}
else{
(ds.p=14855718);
_state=3;
}
break;
case 3:
(ds.p=14856736);
_i=(/*RF2*/(C)->_count/*12*/);
break;
default:;
internal_exception_handler(Incorrect_inspect_value);
}
}/*INSPECT]*/
(ds.p=14857242);
_i=(_i)+(1);
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7to_integer={"to_integer of STRING",1,5,"%R7%Result%E2%negative%E6%cc%E3%state%E2%i%E2%",1};


T8 r7to_external(se_dump_stack*caller,T7* C){
T8 R=NULL;
T2 o7_2090_22=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7to_external;
ds.current=((void**)&C);
ds.p=15211272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
locals[1]=(void**)&o7_2090_22;
se_dst=&ds;/*link*/
o7_2090_22=(/*RF2*/(C)->_count/*12*/);
if(((ds.p=15212844),((/*RF2*/(C)->_capacity/*16*/))==((/*RF2*/(C)->_count/*12*/)))){
(ds.p=15213082);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*16*/),((/*RF2*/(C)->_capacity/*16*/))+(1));
(ds.p=15213338);
(/*SFN*/C->_capacity)=((/*RF2*/(C)->_capacity/*16*/))+(1);
}
if(((ds.p=15213890),(((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_count/*12*/)])!=(((T3)'\0')))){
(ds.p=15214122);
((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_count/*12*/)]=(((T3)'\0'));
}
(ds.p=15214612);
R=((void*)(/*RF2*/(C)->_storage/*4*/));
if(f7to_external.assertion_flag){
f7to_external.assertion_flag=0;
(ds.p=15215136);
ac_ens(((/*RF2*/(C)->_count/*12*/))==(o7_2090_22),NULL);
(ds.p=15215394);
ac_ens((NULL!=R),NULL);
f7to_external.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7to_external={"to_external of STRING",1,2,"%R7%Result%E8%old l2090c22STRING%E2%",1};
se_frame_descriptor se_ifd7={"Class invariant of STRING",1,0,"%R7%",1};


T7*se_i7(se_dump_stack*caller,T7*C){
se_dump_stack ds;
ds.fd=&se_ifd7;
ds.current=((void**)&C);
ds.p=14714638;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=15250188);
ac_inv((0)<=((/*RF2*/(C)->_count/*12*/)),NULL);
(ds.p=15250708);
ac_inv(((/*RF2*/(C)->_count/*12*/))<=((/*RF2*/(C)->_capacity/*16*/)),NULL);
(ds.p=15251234);
ac_inv((!(((/*RF2*/(C)->_capacity/*16*/))>(0)))||(r9is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T2 r36count(se_dump_stack*caller,T36* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f36count;
ds.current=((void**)&C);
ds.p=69243144;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=69243668);
R=((/*RF2*/(C)->_upper/*16*/))+(1);
if(f36count.assertion_flag){
f36count.assertion_flag=0;
(ds.p=73422882);
ac_ens((R)==((((/*RF2*/(C)->_upper/*16*/))-(0))+(1)),NULL);
f36count.assertion_flag=1;
}
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f36count={"count of FIXED_ARRAY",1,1,"%R36%Result%E2%",1};


void r36put(se_dump_stack*caller,T36* C,T0* a1,T2 a2){
T2 o35_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f36put;
ds.current=((void**)&C);
ds.p=69241864;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o35_140_22;
se_dst=&ds;/*link*/
o35_140_22=r36count(&ds,C);
se_require_uppermost_flag=1;
if(f36put.assertion_flag){
f36put.assertion_flag=0;
(ds.p=73435156);
ac_req(r36valid_index(&ds,C,a2),NULL);
f36put.assertion_flag=1;
}
(ds.p=69242404);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f36put.assertion_flag){
f36put.assertion_flag=0;
(ds.p=73435940);
ac_ens((r36item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=73436192);
ac_ens((r36count(&ds,C))==(o35_140_22),NULL);
f36put.assertion_flag=1;
}
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f36put={"put of FIXED_ARRAY",1,3,"%R36%element%R7%i%E2%old l140c22COLLECTION%E2%",1};


T0* r36item(se_dump_stack*caller,T36* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f36item;
ds.current=((void**)&C);
ds.p=69240584;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f36item.assertion_flag){
f36item.assertion_flag=0;
(ds.p=73428244);
ac_req(r36valid_index(&ds,C,a1),NULL);
f36item.assertion_flag=1;
}
(ds.p=69241108);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f36item={"item of FIXED_ARRAY",1,2,"%R36%i%E2%Result%R7%",1};


T6 r36valid_index(se_dump_stack*caller,T36* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f36valid_index;
ds.current=((void**)&C);
ds.p=73419030;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=73420052);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*16*/)));
if(f36valid_index.assertion_flag){
f36valid_index.assertion_flag=0;
(ds.p=73420578);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*16*/)))),NULL);
f36valid_index.assertion_flag=1;
}
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f36valid_index={"valid_index of COLLECTION",1,2,"%R36%index%E2%Result%E6%",1};


void r36make(se_dump_stack*caller,T36* C,T2 a1){
T2 o33_91_26=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f36make;
ds.current=((void**)&C);
ds.p=69222920;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o33_91_26;
se_dst=&ds;/*link*/
o33_91_26=(/*RF2*/(C)->_capacity/*12*/);
se_require_uppermost_flag=1;
if(f36make.assertion_flag){
f36make.assertion_flag=0;
(ds.p=69223976);
ac_req((a1)>=(0),NULL);
f36make.assertion_flag=1;
}
if(((ds.p=69224494),(a1)==(0))){
if(((ds.p=69224748),(((/*RF2*/(C)->_capacity/*12*/))>(0))&&(((/*RF2*/(C)->_upper/*16*/))>=(0)))){
(ds.p=69224994);
r37clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*16*/));
}
(ds.p=69225498);
(/*SFN*/C->_upper)=-(1);
}
 else if(((ds.p=69225780),((/*RF2*/(C)->_capacity/*12*/))==(0))){
(ds.p=69226010);
(/*SFN*/C->_storage)=((T37)(se_calloc(a1,sizeof(T0*))));
(ds.p=69226266);
(/*SFN*/C->_capacity)=a1;
(ds.p=69226522);
(/*SFN*/C->_upper)=(a1)-(1);
}
 else if(((ds.p=69226804),((/*RF2*/(C)->_capacity/*12*/))<(a1))){
(ds.p=69227034);
(/*SFN*/C->_storage)=((T37)(se_calloc(a1,sizeof(T0*))));
(ds.p=69227290);
(/*SFN*/C->_capacity)=a1;
(ds.p=69227546);
(/*SFN*/C->_upper)=(a1)-(1);
}
else{
(ds.p=69228060);
r37clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*16*/));
(ds.p=69228314);
(/*SFN*/C->_upper)=(a1)-(1);
}
if(f36make.assertion_flag){
f36make.assertion_flag=0;
(ds.p=69229088);
ac_ens((r36count(&ds,C))==(a1),NULL);
(ds.p=69229350);
ac_ens(((/*RF2*/(C)->_capacity/*12*/))>=(o33_91_26),NULL);
(ds.p=69229588);
ac_ens(r36all_default(&ds,C),NULL);
f36make.assertion_flag=1;
}
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f36make={"make of FIXED_ARRAY",1,2,"%R36%new_count%E2%old l91c26FIXED_ARRAY%E2%",1};


T6 r36is_empty(se_dump_stack*caller,T36* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f36is_empty;
ds.current=((void**)&C);
ds.p=71319304;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=71319828);
R=(r36count(&ds,C))==(0);
if(f36is_empty.assertion_flag){
f36is_empty.assertion_flag=0;
(ds.p=73424660);
ac_ens((R)==((r36count(&ds,C))==(0)),NULL);
f36is_empty.assertion_flag=1;
}
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f36is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R36%Result%E6%",1};


T6 r36all_default(se_dump_stack*caller,T36* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f36all_default;
ds.current=((void**)&C);
ds.p=69258504;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=69259028);
R=r37all_default(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_upper/*16*/));
if(se_rci(C))se_i36(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f36all_default={"all_default of FIXED_ARRAY",1,1,"%R36%Result%E6%",1};
se_frame_descriptor se_ifd36={"Class invariant of FIXED_ARRAY[STRING]",1,0,"%R36%",1};


T36*se_i36(se_dump_stack*caller,T36*C){
se_dump_stack ds;
ds.fd=&se_ifd36;
ds.current=((void**)&C);
ds.p=69217806;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=73552432);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*16*/))+(1)),"valid_bounds");
(ds.p=71355418);
ac_inv(((/*RF2*/(C)->_capacity/*12*/))>=((((/*RF2*/(C)->_upper/*16*/))-(0))+(1)),NULL);
(ds.p=71355938);
ac_inv((!(((/*RF2*/(C)->_capacity/*12*/))>(0)))||(r37is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=69278510);
ac_inv((r36count(&ds,C))<=((/*RF2*/(C)->_capacity/*12*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


void r26put_new_line(se_dump_stack*caller,T26* C){
se_dump_stack ds;
ds.fd=&f26put_new_line;
ds.current=((void**)&C);
ds.p=56700168;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f26put_new_line.assertion_flag){
f26put_new_line.assertion_flag=0;
(ds.p=56700948);
ac_req(r26is_connected(&ds,C),NULL);
f26put_new_line.assertion_flag=1;
}
(ds.p=56701460);
r26put_character(&ds,C,((T3)'\n'));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26put_new_line={"put_new_line of OUTPUT_STREAM",1,0,"%R26%",1};


void r26disconnect(se_dump_stack*caller,T26* C){
se_dump_stack ds;
ds.fd=&f26disconnect;
ds.current=((void**)&C);
ds.p=54549000;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f26disconnect.assertion_flag){
f26disconnect.assertion_flag=0;
(ds.p=54549524);
ac_req(r26is_connected(&ds,C),NULL);
f26disconnect.assertion_flag=1;
}
(ds.p=54550036);
r26fclose(&ds,(/*RF2*/(C)->_output_stream/*12*/));
(ds.p=54550292);
(/*SFN*/C->_path)=NULL;
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26disconnect={"disconnect of STD_FILE_WRITE",1,0,"%R26%",1};


T6 r26is_connected(se_dump_stack*caller,T26* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f26is_connected;
ds.current=((void**)&C);
ds.p=54552584;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=54553108);
R=((/*RF2*/(C)->_path/*4*/))!=((void*)(NULL));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f26is_connected={"is_connected of STD_FILE_WRITE",1,1,"%R26%Result%E6%",1};


void r26make(se_dump_stack*caller,T26* C){
se_dump_stack ds;
ds.fd=&f26make;
ds.current=((void**)&C);
ds.p=54551048;
ds.caller=caller;
se_dst=&ds;/*link*/
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26make={"make of STD_FILE_WRITE",1,0,"%R26%",1};


void r26connect_to(se_dump_stack*caller,T26* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f26connect_to;
ds.current=((void**)&C);
ds.p=54545416;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f26connect_to.assertion_flag){
f26connect_to.assertion_flag=0;
(ds.p=54545940);
ac_req(r6_ix_not(&ds,r26is_connected(&ds,C)),NULL);
(ds.p=54546196);
ac_req(r6_ix_not(&ds,r7is_empty(&ds,se_i7(&ds,((T7*)ci(7,a1,54546204))))),NULL);
f26connect_to.assertion_flag=1;
}
(ds.p=54546708);
r26make(&ds,C);
(ds.p=54546964);
(/*SFN*/C->_output_stream)=fopen((char*)r7to_external(&ds,se_i7(&ds,((T7*)ci(7,a1,54547016)))),"wa");
if(((ds.p=54547254),(NULL!=(/*RF2*/(C)->_output_stream/*12*/)))){
(ds.p=54547482);
(/*SFN*/C->_path)=a1;
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26connect_to={"connect_to of STD_FILE_WRITE",1,1,"%R26%new_path%R7%",1};


void r26put_integer(se_dump_stack*caller,T26* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f26put_integer;
ds.current=((void**)&C);
ds.p=56655368;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f26put_integer.assertion_flag){
f26put_integer.assertion_flag=0;
(ds.p=56656148);
ac_req(r26is_connected(&ds,C),NULL);
f26put_integer.assertion_flag=1;
}
(ds.p=56656664);
r2store(&ds,a1,(T0*)C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26put_integer={"put_integer of OUTPUT_STREAM",1,1,"%R26%i%E2%",1};


void r26put_character(se_dump_stack*caller,T26* C,T3 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f26put_character;
ds.current=((void**)&C);
ds.p=54555144;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f26put_character.assertion_flag){
f26put_character.assertion_flag=0;
(ds.p=56647188);
ac_req(r26is_connected(&ds,C),NULL);
f26put_character.assertion_flag=1;
}
(ds.p=54555668);
putc(a1,((FILE*)((/*RF2*/(C)->_output_stream/*12*/))));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26put_character={"put_character of STD_FILE_WRITE",1,1,"%R26%c%E3%",1};


void r26put_string(se_dump_stack*caller,T26* C,T0* a1){
T2 _i=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f26put_string;
ds.current=((void**)&C);
ds.p=56648712;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f26put_string.assertion_flag){
f26put_string.assertion_flag=0;
(ds.p=56649492);
ac_req(r26is_connected(&ds,C),NULL);
(ds.p=56649752);
ac_req((a1)!=((void*)(NULL)),NULL);
f26put_string.assertion_flag=1;
}
(ds.p=56651034);
_i=1;
while (!(((ds.p=56651550),(_i)>((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,56651554))))->_count/*12*/)))))
{
(ds.p=56652058);
r26put_character(&ds,C,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,56652086))),_i));
(ds.p=56652314);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26put_string={"put_string of OUTPUT_STREAM",1,2,"%R26%s%R7%i%E2%",1};


void r26fclose(se_dump_stack*caller,T8 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f26fclose;
ds.current=NULL;
ds.p=54563080;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
fclose(a1);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26fclose={"fclose of STD_FILE_WRITE",0,1,"stream_pointer%E8%",1};


void r32put_new_line(se_dump_stack*caller,T32* C){
se_dump_stack ds;
ds.fd=&f32put_new_line;
ds.current=((void**)&C);
ds.p=56700168;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=56701460);
r32put_character(&ds,C,((T3)'\n'));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_new_line={"put_new_line of OUTPUT_STREAM",1,0,"%R32%",1};


void r32make(se_dump_stack*caller,T32* C){
se_dump_stack ds;
ds.fd=&f32make;
ds.current=((void**)&C);
ds.p=67124488;
ds.caller=caller;
se_dst=&ds;/*link*/
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32make={"make of STD_ERROR",1,0,"%R32%",1};


void r32put_character(se_dump_stack*caller,T32* C,T3 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f32put_character;
ds.current=((void**)&C);
ds.p=67126024;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=67126548);
putc(a1,((FILE*)(stderr)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_character={"put_character of STD_ERROR",1,1,"%R32%c%E3%",1};


void r32put_string(se_dump_stack*caller,T32* C,T0* a1){
T2 _i=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f32put_string;
ds.current=((void**)&C);
ds.p=56648712;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32put_string.assertion_flag){
f32put_string.assertion_flag=0;
(ds.p=56649752);
ac_req((a1)!=((void*)(NULL)),NULL);
f32put_string.assertion_flag=1;
}
(ds.p=56651034);
_i=1;
while (!(((ds.p=56651550),(_i)>((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,56651554))))->_count/*12*/)))))
{
(ds.p=56652058);
r32put_character(&ds,C,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,56652086))),_i));
(ds.p=56652314);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_string={"put_string of OUTPUT_STREAM",1,2,"%R32%s%R7%i%E2%",1};
T0*oBC1command_arguments=NULL;
int fBC1command_arguments=0;


T0* r18command_arguments(se_dump_stack*caller){
if(fBC1command_arguments==0){fBC1command_arguments=1;{
T0* _arg=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f18command_arguments;
ds.current=NULL;
ds.p=2232342;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC1command_arguments;
locals[1]=(void**)&_arg;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=2234394);
_i=se_argc;
(ds.p=2234650);
{T36*n=((T36*)se_malloc(sizeof(*n))/*20*/);
*n=M36;
oBC1command_arguments=((T0*)n);
r36make(&ds,n,_i);
se_i36(&ds,n);}
while (!(((ds.p=2235166),(_i)==(0))))
{
(ds.p=2235674);
_i=(_i)-(1);
(ds.p=2235930);
_arg=((T0*)se_string(se_argv[_i]));
(ds.p=2236200);
r36put(&ds,se_i36(&ds,((T36*)ci(36,oBC1command_arguments,2236186))),_arg,_i);
}
if(f18command_arguments.assertion_flag){
f18command_arguments.assertion_flag=0;
(ds.p=2236948);
ac_ens(r6_ix_not(&ds,r36is_empty(&ds,se_i36(&ds,((T36*)ci(36,oBC1command_arguments,2236956))))),NULL);
f18command_arguments.assertion_flag=1;
}
se_dst=caller;/*unlink*/
}}
return oBC1command_arguments;
}
se_frame_descriptor f18command_arguments={"command_arguments of GENERAL",0,3,"Result%R36%arg%R7%i%E2%",1};


T2 r18argument_count(se_dump_stack*caller,T18* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f18argument_count;
ds.current=((void**)&C);
ds.p=2226952;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=2227988);
R=(/*RF2*/(se_i36(&ds,((T36*)ci(36,r18command_arguments(&ds),2228008))))->_upper/*16*/);
if(f18argument_count.assertion_flag){
f18argument_count.assertion_flag=0;
(ds.p=2228514);
ac_ens((R)>=(0),NULL);
f18argument_count.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f18argument_count={"argument_count of GENERAL",1,1,"%R18%Result%E2%",1};


void r18make(se_dump_stack*caller,T18* C){
T0* _path=NULL;
T2 _i=0;
T2 _number=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f18make;
ds.current=((void**)&C);
ds.p=37758984;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&_path;
locals[1]=(void**)&_i;
locals[2]=(void**)&_number;
se_dst=&ds;/*link*/
if(((ds.p=37760578),((r18argument_count(&ds,C))!=(2))||(r6_ix_not(&ds,r7is_integer(&ds,se_i7(&ds,((T7*)ci(7,r18argument(&ds,C,1),37760602)))))))){
(ds.p=37760814);
r32put_string(&ds,((T32*)ci(32,oBC1std_error,37760794)),((T0*)ms18_2263847));
(ds.p=37761070);
r32put_string(&ds,((T32*)ci(32,oBC1std_error,37761050)),r18argument(&ds,C,0));
(ds.p=37761326);
r32put_string(&ds,((T32*)ci(32,oBC1std_error,37761306)),((T0*)ms18_526111769));
(ds.p=37761562);
exit(1);
}
(ds.p=37762324);
_number=r7to_integer(&ds,se_i7(&ds,((T7*)ci(7,r18argument(&ds,C,1),37762344))));
(ds.p=37762836);
{T7*n=((T7*)se_malloc(sizeof(*n))/*24*/);
*n=M7;
r7make(&ds,n,((/*RF2*/(se_i7(&ds,((T7*)ci(7,r18argument(&ds,C,2),37762860))))->_count/*12*/))+(16));
_path=((T0*)n);
se_i7(&ds,n);}
{int c=0;int v=0;
(ds.p=37763610);
_i=1;
while (!(((ds.p=37764638),(_i)>(_number))))
{
(ds.p=37764136);
v=ac_lvc(c++,v,(_number)-(_i));
(ds.p=37765156);
r7copy(&ds,se_i7(&ds,((T7*)ci(7,_path,37765146))),r18argument(&ds,C,2));
if(((ds.p=37765684),(r7last(&ds,se_i7(&ds,((T7*)ci(7,_path,37765664)))))!=(((T3)'\57')))){
(ds.p=37765930);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,_path,37765920))),((T3)'\57'));
}
(ds.p=37766692);
r7append(&ds,se_i7(&ds,((T7*)ci(7,_path,37766682))),((T0*)ms18_16016));
if(((ds.p=37767204),(_i)<(10))){
(ds.p=37767466);
r7append(&ds,se_i7(&ds,((T7*)ci(7,_path,37767456))),((T0*)ms18_1488));
}
 else if(((ds.p=37767724),(_i)<(100))){
(ds.p=37767978);
r7append(&ds,se_i7(&ds,((T7*)ci(7,_path,37767968))),((T0*)ms18_288));
}
 else if(((ds.p=37768236),(_i)<(1000))){
(ds.p=37768490);
r7append(&ds,se_i7(&ds,((T7*)ci(7,_path,37768480))),((T0*)ms18_48));
}
(ds.p=37769246);
r2append_in(&ds,_i,_path);
(ds.p=37769764);
r7append(&ds,se_i7(&ds,((T7*)ci(7,_path,37769754))),((T0*)ms18_9366));
(ds.p=37770276);
r26connect_to(&ds,((T26*)ci(26,r18file(&ds),37770266)),_path);
if(((ds.p=37770784),r6_ix_not(&ds,r26is_connected(&ds,((T26*)ci(26,r18file(&ds),37770792)))))){
(ds.p=37771060);
r32put_string(&ds,((T32*)ci(32,oBC1std_error,37771040)),((T0*)ms18_483529661));
(ds.p=37771316);
r32put_string(&ds,((T32*)ci(32,oBC1std_error,37771296)),_path);
(ds.p=37771572);
r32put_new_line(&ds,((T32*)ci(32,oBC1std_error,37771552)));
(ds.p=37771808);
exit(1);
}
(ds.p=37772580);
r26put_string(&ds,((T26*)ci(26,r18file(&ds),37772570)),((T0*)ms18_189106055));
(ds.p=37772836);
r26put_integer(&ds,((T26*)ci(26,r18file(&ds),37772826)),_i);
(ds.p=37773092);
r26put_new_line(&ds,((T26*)ci(26,r18file(&ds),37773082)));
(ds.p=37773604);
r26disconnect(&ds,((T26*)ci(26,r18file(&ds),37773594)));
(ds.p=37774106);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f18make={"make of GEN_N_FILES",1,3,"%R18%path%R7%i%E2%number%E2%",1};


T0* r18argument(se_dump_stack*caller,T18* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f18argument;
ds.current=((void**)&C);
ds.p=2229256;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f18argument.assertion_flag){
f18argument.assertion_flag=0;
(ds.p=2230296);
ac_req((a1)>=(0),NULL);
(ds.p=2230552);
ac_req((a1)<=(r18argument_count(&ds,C)),NULL);
f18argument.assertion_flag=1;
}
(ds.p=2231060);
R=r36item(&ds,se_i36(&ds,((T36*)ci(36,r18command_arguments(&ds),2231080))),a1);
if(f18argument.assertion_flag){
f18argument.assertion_flag=0;
(ds.p=2231586);
ac_ens((R)!=((void*)(NULL)),NULL);
f18argument.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f18argument={"argument of GENERAL",1,2,"%R18%i%E2%Result%R7%",1};
T0*oBC18file=NULL;
int fBC18file=0;


T0* r18file(se_dump_stack*caller){
if(fBC18file==0){fBC18file=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f18file;
ds.current=NULL;
ds.p=37775112;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC18file;
se_dst=&ds;/*link*/
(ds.p=37775636);
{T26*n=((T26*)se_malloc(sizeof(*n))/*20*/);
*n=M26;
oBC18file=((T0*)n);
r26make(&ds,n);
}
se_dst=caller;/*unlink*/
}}
return oBC18file;
}
se_frame_descriptor f18file={"file of GEN_N_FILES",0,1,"Result%R26%",1};
T0*oBC1std_error=NULL;
T18*eiffel_root_object=NULL;
int se_argc;
char**se_argv;
T7* g[38];
T7* t[38];
char* p[38];
void(*se_prinT[38])(void**);


void initialize_eiffel_runtime(int argc,char*argv[]){
se_frame_descriptor irfd={"Initialising runtime.",0,0,"",1};
se_dump_stack ds = {NULL,NULL,0,NULL,NULL};
ds.fd=&irfd;
ds.caller=se_dst;
se_argc=argc;
se_argv=argv;
setup_signal_handler();
p[0]="???";
p[31]="/usr/local/fine/lib/std/safe_equal.e";
p[27]="/usr/local/fine/lib/std/output_stream.e";
p[19]="/usr/local/fine/lib/std/platform.e";
p[2]="/usr/local/fine/lib/std/integer.e";
p[7]="/usr/local/fine/lib/std/string.e";
p[20]="/usr/local/fine/lib/std/comparable.e";
p[26]="/usr/local/fine/lib/std/std_file_write.e";
p[23]="/usr/local/fine/lib/std/integer_ref.e";
p[10]="/usr/local/fine/lib/std/any.e";
p[33]="/usr/local/fine/lib/std/fixed_array.e";
p[24]="/usr/local/fine/lib/std/numeric.e";
p[1]="/usr/local/fine/lib/std/general.e";
p[18]="./gen_n_files.e";
p[32]="/usr/local/fine/lib/std/std_error.e";
p[21]="/usr/local/fine/lib/std/hashable.e";
p[28]="/usr/local/fine/lib/std/pointer_ref.e";
p[8]="/usr/local/fine/lib/std/pointer.e";
p[30]="/usr/local/fine/lib/std/native_array.e";
p[35]="/usr/local/fine/lib/std/collection.e";
p[29]="/usr/local/fine/lib/std/character_ref.e";
p[3]="/usr/local/fine/lib/std/character.e";
p[6]="/usr/local/fine/lib/std/boolean.e";
p[22]="/usr/local/fine/lib/std/storable.e";
p[25]="/usr/local/fine/lib/std/boolean_ref.e";
p[34]="/usr/local/fine/lib/std/arrayed_collection.e";
se_prinT[8]=((void(*)(void**))se_prinT8);
se_prinT[6]=((void(*)(void**))se_prinT6);
se_prinT[3]=((void(*)(void**))se_prinT3);
se_prinT[26]=((void(*)(void**))se_prinT26);
se_prinT[36]=((void(*)(void**))se_prinT36);
p[36]=p[33];
se_prinT[37]=((void(*)(void**))se_prinT37);
p[37]=p[30];
se_prinT[18]=((void(*)(void**))se_prinT18);
se_prinT[7]=((void(*)(void**))se_prinT7);
se_prinT[9]=((void(*)(void**))se_prinT9);
p[9]=p[30];
se_prinT[2]=((void(*)(void**))se_prinT2);
se_prinT[32]=((void(*)(void**))se_prinT32);
g[31]=se_string("SAFE_EQUAL");
g[27]=se_string("OUTPUT_STREAM");
g[19]=se_string("PLATFORM");
g[2]=se_string("INTEGER");
g[7]=se_string("STRING");
g[20]=se_string("COMPARABLE");
g[26]=se_string("STD_FILE_WRITE");
g[23]=se_string("INTEGER_REF");
g[10]=se_string("ANY");
g[33]=se_string("FIXED_ARRAY");
g[24]=se_string("NUMERIC");
g[1]=se_string("GENERAL");
g[18]=se_string("GEN_N_FILES");
g[32]=se_string("STD_ERROR");
g[21]=se_string("HASHABLE");
g[28]=se_string("POINTER_REF");
g[8]=se_string("POINTER");
g[30]=se_string("NATIVE_ARRAY");
g[35]=se_string("COLLECTION");
g[29]=se_string("CHARACTER_REF");
g[3]=se_string("CHARACTER");
g[6]=se_string("BOOLEAN");
g[0]=se_string("NONE");
g[22]=se_string("STORABLE");
g[25]=se_string("BOOLEAN_REF");
g[34]=se_string("ARRAYED_COLLECTION");
g[36]=g[33];
g[37]=g[30];
g[9]=g[30];
t[8]=g[8];
t[6]=g[6];
t[3]=g[3];
t[26]=g[26];
t[36]=se_string("FIXED_ARRAY[STRING]");
t[37]=se_string("NATIVE_ARRAY[STRING]");
t[18]=g[18];
t[7]=g[7];
t[9]=se_string("NATIVE_ARRAY[CHARACTER]");
t[2]=g[2];
t[32]=g[32];
se_msi1();
/*PCO*/
(ds.p=2193172);
{T32*n=((T32*)se_malloc(sizeof(*n))/*4*/);
*n=M32;
oBC1std_error=((T0*)n);
r32make(&ds,n);
}
/*PCO*/
eiffel_root_object=((T18*)se_malloc(sizeof(*eiffel_root_object))/*4*/);
*eiffel_root_object=M18;
se_dst=NULL;
}
int  main(int argc,char*argv[]){
initialize_eiffel_runtime(argc,argv);
{T18*n=eiffel_root_object;
se_frame_descriptor root={"System root.",1,0,"%R18%",1};
se_dump_stack ds;
ds.fd=&root;
ds.current=((void**)(&n));
ds.p=37758984;
ds.caller=NULL;
se_dst=&ds;/*link*/
r18make(&ds,n);
}
return 0;}
T7*ms18_16016;
T7*ms18_2263847;
T7*ms18_189106055;
T7*ms18_288;
T7*ms18_526111769;
T7*ms18_1488;
T7*ms2_117797837;
T7*ms18_9366;
T7*ms18_48;
T7*ms18_483529661;


T7*se_ms(int c,char*e){
/* Allocation of a Manifest STRING.*/
T7*s=((T7*)se_malloc(sizeof(T7)));
s->id=7;
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


T7*se_string(char*e){
/* Creation of an Eiffel STRING by copying C char*e */
int c=strlen(e);
T7*s;
s=((T7*)se_malloc(sizeof(*s))/*24*/);
*s=M7;
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


void se_msi1(void){
ms18_16016=se_ms(4,"file");
ms18_2263847=se_ms(7,"usage: ");
ms18_189106055=se_ms(21,"This is file number: ");
ms18_288=se_ms(2,"00");
ms18_526111769=se_ms(27," number-of-files directory\n");
ms18_1488=se_ms(3,"000");
ms2_117797837=se_ms(10,"0123456789");
ms18_9366=se_ms(4,".txt");
ms18_48=se_ms(1,"0");
ms18_483529661=se_ms(21,"Unable to open file: ");
}


void X27put_character(se_dump_stack*caller,se_position position,T0*C,T3 a1){
se_dump_stack ds=*caller;
ds.caller=caller;
{Tid id=vc(C,position)->id;
switch(id){
case 26:r26put_character(&ds,((T26*)C),a1);

break;
case 32:r32put_character(&ds,((T32*)C),a1);

break;
default: error2(C,position);
}
}
se_dst=caller;
}

#ifdef __cplusplus
}
#endif
