/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-07 07:42:54 -0600 (Fri, 07 Aug 2009) $
--   $Revision: 4303 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../objectify_private.h"



int main(int argc, char* argv[])
{
    Disk_Header disk_header;
    Disk_Header* public_header_ptr;
    int obj_fd;
    FILE* out_fp;
    uint8 block[FILE_BLOCK_SIZE];
    size_t bytes_read;
    uint32 used_public_blocks;
    int i;

    if (argc != 2)
    {
	fprintf(stderr, "usage: %s file-name\n", argv[0]);
	exit(1);
    }

    out_fp = fopen(argv[1], "w");

    if (out_fp == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    obj_fd = open(DEFAULT_FILE, O_RDONLY);    /* don't need large file if not seeking? */

    if (obj_fd < 0)
    {
	perror(DEFAULT_FILE);
	exit(1);
    }


    /* read the header first */

    bytes_read = read(obj_fd, block, sizeof(block));

    if (bytes_read != sizeof(block))
    {
	perror(DEFAULT_FILE);
	exit(1);
    }

    memcpy(&disk_header, block, sizeof(disk_header));    /* copy the header into the header structure */


    /* create the public header in the block */

    memset(block, 0, sizeof(block));

    public_header_ptr = (Disk_Header*) block;

    memcpy(public_header_ptr->magic_number, disk_header.magic_number, sizeof(public_header_ptr->magic_number));

    memcpy(public_header_ptr->version_string, disk_header.version_string, sizeof(public_header_ptr->version_string));

    memcpy(public_header_ptr->public_last_change, disk_header.public_last_change, sizeof(public_header_ptr->public_last_change));

    memcpy(public_header_ptr->used_public_blocks, disk_header.used_public_blocks, sizeof(public_header_ptr->used_public_blocks));
    nwos_4_uint8_to_uint32(public_header_ptr->used_public_blocks, &used_public_blocks);

    public_header_ptr = NULL;    /* don't use this anymore */


    /* write the header block */

    if (fwrite(block, 1, sizeof(block), out_fp) != sizeof(block))
    {
	perror(argv[1]);
	exit(1);
    }

    for (i = 1; i < used_public_blocks; i++)
    {
	bytes_read = read(obj_fd, block, sizeof(block));

	if (bytes_read != sizeof(block))
	{
	    perror(DEFAULT_FILE);
	    exit(1);
	}

	if (fwrite(block, 1, sizeof(block), out_fp) != sizeof(block))
	{
	    perror(argv[1]);
	    exit(1);
	}
    }

    close(obj_fd);

    if (fclose(out_fp) != 0)
    {
	perror(argv[1]);
	exit(1);
    }

    return 1;
}

