/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2005, 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-04 05:36:52 -0600 (Tue, 04 Aug 2009) $
--   $Revision: 4253 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file and the name.c file which this
--   file was derived from.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>   /* define memset */

#include "crc32.h"
#include "objectify.h"



bool nwos_find_word(char* word, ObjRef* thing_class, ObjRef* lang, ObjRef* ref)
{
    C_struct_Word word_obj;
    C_struct_Language lang_obj;
    EveryObject spelling_header;
    EveryObject thing_header;
    ObjRef word_class_ref;
    ObjRef spelling_ref;
    ObjRef object_class;
    ReferenceList* ref_list;
    int num_spellings;
    int i;
    bool result = false;

    assert(nwos_read_object_from_disk(lang, &lang_obj, sizeof(lang_obj)));   /* read the language object just to verify it exists */

    assert(nwos_find_public_class_definition("WORD", &word_class_ref));

    if (nwos_find_public_spelling(word, &spelling_ref))
    {
	nwos_read_object_headers_from_disk(&spelling_ref, &spelling_header);

	ref_list = nwos_malloc_reference_list(&spelling_header.object.references);

	num_spellings = ref_list->common_header.num_refs;

	/* printf("num_spellings (in find_word): %d\n", num_spellings); */

	for (i = 0; i < num_spellings; i++)
	{
	    nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	    if (is_same_object(&object_class, &word_class_ref))   /* it is a word object */
	    {
		assert(nwos_read_object_from_disk(&ref_list->references[i], &word_obj, sizeof(word_obj)));

		if (is_same_object(&word_obj.language, lang))
		{
		    /* get the class for the "thing" this word points to */
		    nwos_read_object_headers_from_disk(&word_obj.thing, &thing_header);
		    if (is_same_object(&thing_header.common.class_definition, thing_class))
		    {
			memcpy(ref, &ref_list->references[i], sizeof(ObjRef));
			result = true;
			break;
		    }
		}
	    }
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;
    }

    return result;
}


ObjCreateResult nwos_create_word(char* word, ObjRef* thing, ObjRef* lang, ObjRef* ref)
{
    C_struct_Word word_obj;
    C_struct_Language lang_obj;
    EveryObject thing_header;
    ObjRef word_class_ref;
    ObjRef spelling_ref;
    ObjCreateResult result = CREATED_NEW;

    assert(nwos_read_object_from_disk(lang, &lang_obj, sizeof(lang_obj)));   /* read the language object just to verify it exists */

    /* for now all words must be public */

    assert(nwos_find_public_class_definition("WORD", &word_class_ref));

    nwos_read_object_headers_from_disk(thing, &thing_header);

    if (!nwos_find_word(word, &thing_header.common.class_definition, lang, ref))   /* didn't find it */
    {
	nwos_create_public_spelling(word, &spelling_ref);

	memset(&word_obj, 0, sizeof(word_obj));  /* zero it out */

	nwos_generate_new_id(ref);

	nwos_fill_in_common_header(&word_obj.header.common, ref, &word_class_ref);

	memcpy(&word_obj.language, lang, sizeof(ObjRef));
	nwos_add_to_references(ref, lang);

	memcpy(&word_obj.thing, thing, sizeof(ObjRef));
	nwos_add_to_references(ref, thing);

	memcpy(&word_obj.spelling, &spelling_ref, sizeof(ObjRef));
	nwos_add_to_references(ref, &spelling_ref);

	nwos_create_reference_list(ref, &word_obj.header.object.references);

	nwos_crc32_calculate((uint8*) &word_obj.header.object, sizeof(ObjectHeader), word_obj.header.common.header_chksum);

	nwos_crc32_calculate((uint8*) &word_obj.thing, sizeof(word_obj) - sizeof(EveryObject), word_obj.header.common.data_chksum);

	nwos_write_object_to_disk(ref, &word_obj, sizeof(word_obj));

        nwos_add_to_references(ref, &word_class_ref);
    }

    return result;
}


