/*
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-07 07:42:54 -0600 (Fri, 07 Aug 2009) $
--   $Revision: 4303 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>    /* define sleep() */

#include "../objectify_private.h"

uint32 convert_4_uint8_to_uint32(uint8 byte[4])
{
  return ((uint32)byte[0] << 24) | ((uint32)byte[1] << 16) | ((uint32)byte[2] << 8) | (uint32)byte[3];
}


int main(int argc, char* argv[])
{
    FILE* fp1;
    uint8 buf1[FILE_BLOCK_SIZE];
    uint32 ref;
    size_t read1;
    Disk_Header header;


    if (argc != 2)
    {
	fprintf(stderr, "usage: %s compressed_file\n", argv[0]);
	exit(1);
    }


    /* Open the old file and check it */

    fp1 = fopen(argv[1], "r");
    if (fp1 == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    read1 = fread(buf1, 1, sizeof(buf1), fp1);

    if (read1 != FILE_BLOCK_SIZE)
    {
	if (ferror(fp1))
	{
	    perror(argv[1]);
	}
	else
	{
	    fprintf(stderr, "Unexpected end of file: %s\n", argv[1]);
	}
	fclose(fp1);
	exit(1);
    }

    memcpy(&header, buf1, sizeof(header));

    if (memcmp(header.magic_number, "NWOS", 4) != 0)
    {
	fprintf(stderr, "Not an Objectify file: %s\n", argv[1]);
	fclose(fp1);
	exit(1);
    }

    fprintf(stderr, "Version: %c%c%c%c\n",
	    header.version_string[0], header.version_string[1],
	    header.version_string[2], header.version_string[3]);


    read1 = fread(buf1, 1, sizeof(buf1), fp1);

    while (!feof(fp1) && read1 == FILE_BLOCK_SIZE)
    {
	if (buf1[0] != 0 || buf1[1] != 0 || buf1[2] != 0 || buf1[3] != 0)
	{
	    fprintf(stderr, "\n%s - first four bytes not zero: %02x%02x%02x%02x\n",
		    argv[1], buf1[0], buf1[1], buf1[2], buf1[3]);
	    exit(1);
	}

	ref = convert_4_uint8_to_uint32(&buf1[4]);

	printf("%08x\n", ref);

	read1 = fread(buf1, 1, sizeof(buf1), fp1);
    }

    if (ferror(fp1))
    {
	perror(argv[1]);
	exit(1);
    }

    if (!feof(fp1) && read1 != FILE_BLOCK_SIZE)
    {
	fprintf(stderr, "Short read: %zd bytes\n", read1);
	exit(1);
    }

    fclose(fp1);

    return 0;
}
