/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2004, 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#ifndef TYPES_H
#define TYPES_H


#include <sys/types.h>    /* define system types like size_t */

typedef signed char      int8;
typedef signed short     int16;
typedef signed int       int32;
typedef signed long long int64;

typedef unsigned char      uint8;
typedef unsigned short     uint16;
typedef unsigned int       uint32;
typedef unsigned long long uint64;

typedef enum { false = 0, true = 1 } bool;

typedef signed char bool8;
typedef signed short bool16;


#define DEFAULT_FILE NULL      /* this used to define a path, now a null tells disk_io to use the default */

#define FILE_BLOCK_SIZE 256


typedef enum {
  PUBLIC     = 0x50424C43,
  READ_ONLY  = 0x52454144,
  READ_WRITE = 0x52445752,
} AccessType;


#define MD5_DIGEST_SIZE    16
#define SHA1_DIGEST_SIZE   20
#define SHA256_DIGEST_SIZE 32
#define SHA512_DIGEST_SIZE 64



static inline void nwos_8_uint8_to_uint64(uint8* src, uint64* dst) 
{
    *dst = ((uint64)src[0] << 56) | ((uint64)src[1] << 48) | ((uint64)src[2] << 40) | ((uint64)src[3] << 32) |
           ((uint64)src[4] << 24) | ((uint64)src[5] << 16) | ((uint64)src[6] << 8)  |  (uint64)src[7];
}

static inline void nwos_4_uint8_to_uint32(uint8* src, uint32* dst) 
{
    *dst = ((uint32)src[0] << 24) | ((uint32)src[1] << 16) | ((uint32)src[2] << 8) | (uint32)src[3];
}

static inline void nwos_2_uint8_to_uint16(uint8* src, uint16* dst) 
{
    *dst = ((uint16)src[0] << 8) | ((uint16)src[1]);
}


static inline void nwos_uint64_to_8_uint8(uint64* src, uint8* dst) 
{
    dst[0] = *src >> 56;
    dst[1] = *src >> 48;
    dst[2] = *src >> 40;
    dst[3] = *src >> 32;
    dst[4] = *src >> 24;
    dst[5] = *src >> 16;
    dst[6] = *src >> 8;
    dst[7] = *src;
}

static inline void nwos_uint32_to_4_uint8(uint32* src, uint8* dst) 
{
    dst[0] = *src >> 24;
    dst[1] = *src >> 16;
    dst[2] = *src >> 8;
    dst[3] = *src;
}


static inline uint16 byteswap_uint16(uint16 x)
{
    return (x << 8) | (x >> 8);
}

static inline uint32 byteswap_uint32(uint32 x)
{
  return (x << 24) |
    ((x & 0x0000ff00) << 8) |
    ((x & 0x00ff0000) >> 8) |
    (x >> 24);
}

static inline uint64 byteswap_uint64(uint64 x)
{
  return (x << 56) |
    ((x & 0x000000000000ff00ll) << 40) |
    ((x & 0x0000000000ff0000ll) << 24) |
    ((x & 0x00000000ff000000ll) << 8)  |
    ((x & 0x000000ff00000000ll) >> 8)  |
    ((x & 0x0000ff0000000000ll) >> 24) |
    ((x & 0x00ff000000000000ll) >> 40) |
    (x >> 56);
}

#endif

