/*
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2005, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file and the revision history of the
--   address.c, computer.c, financial.c, log_disc.c, objectify.c, person.c,
--   phone.c, and us_state.c files where the functions were taken from.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "objectify.h"


static void get_answer(char* buffer, size_t bufsize)
{
    if (fgets(buffer, bufsize, stdin) == NULL)
    {
	fputc('\n', stderr);

	if (feof(stdin))
	{
	    fprintf(stderr, "ERROR: received end of input from standard input\n");
	}
	else
	{
	    perror("reading answer to question");
	}

	exit(1);
    }
}


void nwos_ask_user(char* descr, char* buffer, size_t size)
{
    char *ptr;

    while (1)
    {
	printf("%s: ", descr);
	fflush(stdout);

	get_answer(buffer, size);

	ptr = strchr(buffer, '\n');

	if (ptr != NULL)
	{
	    *ptr = '\0';
	    break;
	}

	do { get_answer(buffer, size); } while (strchr(buffer, '\n') == NULL);

	printf("input too long, maximum length: %zd - try again!\n", size);
    }
}


bool nwos_ask_yes_or_no(char* statement, char* question)
{
    char buffer[16];

    if (statement != NULL)
    {
	printf("%s.  %s? (y/n): ", statement, question);
    }
    else
    {
	printf("%s? (y/n): ", question);
    }

    while (1)
    {
	fflush(stdout);
	get_answer(buffer, sizeof(buffer));
	printf("\n");

	if (strchr(buffer, '\n') == NULL)  /* too much input */
	{
	    while (strchr(buffer, '\n') == NULL) get_answer(buffer, sizeof(buffer));
	    buffer[0] = '\0';
	}

	if (strcasecmp(buffer, "y\n") == 0 || strcasecmp(buffer, "yes\n") == 0) break;

	if (strcasecmp(buffer, "n\n") == 0 || strcasecmp(buffer, "no\n") == 0) break;

	printf("Please answer the question: %s (yes or no)\n", question);
    }

    return (tolower(buffer[0]) == 'y');
}


