--
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- This program analyzes a compressed file to see how many chunks are used,
-- number of blocks used in various chunks, etc.
--


class ID_SPACING

creation make

feature

   in_file: BINARY_FILE_READ

   read_4_characters: STRING is
      do
         !!Result.make(4)

         in_file.read_character
         Result.extend(in_file.last_character)

         in_file.read_character
         Result.extend(in_file.last_character)

         in_file.read_character
         Result.extend(in_file.last_character)

         in_file.read_character
         Result.extend(in_file.last_character)
      end

   read_header is
      local
         i: INTEGER
         s: STRING
      do
         s := read_4_characters

         if s.is_equal("NWOS") then
            std_output.put_string("Magic number: OK%N")
         else
            std_error.put_string("Magic number: BAD%N")
            die_with_code(exit_failure_code)
         end

         s := read_4_characters

         if s.is_equal("0022") then
            std_output.put_string("Version 0022: OK%N")
         else
            std_error.put_string("Compressed file must be version 0022, instead of: ")
            std_error.put_string(s)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         from
            i := 8
         until
            in_file.end_of_input or else i = 256
         loop
            in_file.read_byte
            i := i + 1
         end
      end

   next_id: UNSIGNED is
      local
         i: INTEGER
      do
         in_file.read_32_bit_unsigned

         check
            in_file.last_unsigned = 0U
         end

         in_file.read_32_bit_unsigned
         Result := in_file.last_unsigned

         from
            i := 8
         until
            in_file.end_of_input or else i = 256
         loop
            in_file.read_byte
            i := i + 1
         end
      end


   make is
      local
         id: UNSIGNED
         last_id: UNSIGNED
         counts: FIXED_ARRAY[INTEGER]
         distance: INTEGER
         i: INTEGER
         chunks: FIXED_ARRAY[INTEGER]
         chunk_counts: FIXED_ARRAY[INTEGER]
         chunks_used: INTEGER
         blocks_per_chunk: UNSIGNED
         chunk: UNSIGNED
         blocks_used: INTEGER
      do
         if argument_count /= 1 then
            std_error.put_string("usage: ")
            std_error.put_string(argument(0))
            std_error.put_string(" compressed_file%N")
            die_with_code(exit_failure_code)
         end

         blocks_per_chunk := 65504U

         !!in_file.connect_to(argument(1))

         in_file.set_big_endian

         !!counts.make(1048576)
         !!chunks.make(65536)

         from
            read_header
            last_id := next_id
            chunk := (last_id - 0x10000000) // blocks_per_chunk
            chunks.put(chunks.item(chunk.to_integer) + 1, chunk.to_integer)
         until
            last_id = 0xFFED425D or else in_file.end_of_input
         loop
            id := next_id

            chunk := (id - 0x10000000) // blocks_per_chunk
            chunks.put(chunks.item(chunk.to_integer) + 1, chunk.to_integer)

            distance := (id - last_id).to_integer

            if (distance > counts.upper) then
               counts.resize(distance)
            end

            counts.put(counts.item(distance) + 1, distance)
            
            std_output.put_unsigned_in_hexadecimal(last_id)
            std_output.put_character(' ')
            std_output.put_integer(distance)
            std_output.put_new_line
            last_id := id
         end

         std_output.put_unsigned_in_hexadecimal(last_id)
         std_output.put_new_line

         std_output.put_string("separation: blocks that far apart%N")

         from
            i := counts.lower
         until
            i > counts.upper
         loop
            if counts.item(i) /= 0 then
               std_output.put_integer(i)
               std_output.put_string(": ")
               std_output.put_integer(counts.item(i))
               std_output.put_new_line
            end
            i := i + 1
         end

         !!chunk_counts.make(65536)

         from
            i := chunks.lower
         until
            i > chunks.upper
         loop
            blocks_used := chunks.item(i)
            chunk_counts.put(chunk_counts.item(blocks_used) + 1, blocks_used)

            if blocks_used /= 0 then
               chunks_used := chunks_used + 1
            end
            i := i + 1
         end

         std_output.put_string("Chunks used: ")
         std_output.put_integer(chunks_used)
         std_output.put_new_line

         std_output.put_string("blocks in chunk: how many%N")

         from
            i := chunk_counts.lower
         until
            i > chunk_counts.upper
         loop
            if chunk_counts.item(i) /= 0 then
               std_output.put_integer(i)
               std_output.put_string(": ")
               std_output.put_integer(chunk_counts.item(i))
               std_output.put_new_line
            end
            i := i + 1
         end
      end

end

