#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by:
--------------------------------------------------------------------
 Fine - Release 0.11x18 [alpha] (Sunday 01-Mar-2004)
  Copyright (C) 2001-2003 QRW Software - http://www.qrwsoftware.com
  J. Scott Edwards - sedwards@qrwsoftware.com
  http://fine.sourceforge.net
 Based upon SmallEiffel Release -0.76
  Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
  Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
  http://SmallEiffel.loria.fr
--------------------------------------------------------------------
*/


/*
  This file (fine/lib/runtime/base.h) contains all basic Fine
  type definitions.
  This file is automatically included in the header for ALL modes of 
  compilation : -no_check, -system_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef WIN32
#include <windows.h>
#else
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif
#endif

/*
  Because ANSI C EXIT_FAILURE is not always defined :
 */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
#define JMP_BUF    sigjmp_buf
#define SETJMP(x)  sigsetjmp( (x), 1)
#define LONGJMP    siglongjmp
#else
#define JMP_BUF    jmp_buf
#define SETJMP(x)  setjmp( (x) )
#define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Fine type INTEGER is #2 :
*/
typedef int T2;
#define EIF_INTEGER T2
#define M2 (0)
#define EIF_INTEGER_BITS (CHAR_BIT*sizeof(T2))
#define EIF_MINIMUM_INTEGER (INT_MIN)
#define EIF_MAXIMUM_INTEGER (INT_MAX)

/*
  Fine type CHARACTER is #3 :
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT*sizeof(T3))
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T2)(x))
#define T3to_integer(x) ((T2)((char)(x)))
#define T3to_bit(x) (x)

/*
  Fine type FLOAT is #4 :
*/
typedef float T4;
#define EIF_FLOAT T4
#define M4 (0.0)
#define EIF_FLOAT_BITS (CHAR_BIT*sizeof(T4))
#define EIF_MINIMUM_FLOAT (-(FLT_MAX))
#define EIF_MAXIMUM_FLOAT (FLT_MAX)
#define T2toT4(x) ((T4)(x))

/*
  Fine type DOUBLE is #5 :
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(T5))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)
#define T2toT5(x) ((T5)(x))
#define T4toT5(x) ((T5)(x))

/*
  Fine type BOOLEAN is #6 :
*/
typedef int T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT*sizeof(T6))

/* 
   Fine type POINTER is #8 :
*/
typedef void* T8;
#define EIF_POINTER T8
#define M8 (NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(T8))

/*
  To use type STRING on the C side :
*/
#define EIF_STRING T7*

/* 
   Fine type UNSIGNED is #17 :
*/
typedef unsigned T17;
#define EIF_UNSIGNED T17
#define M17 (0)
#define EIF_UNSIGNED_BITS (CHAR_BIT*sizeof(T17))
#define EIF_MINIMUM_UNSIGNED (0)
#define EIF_MAXIMUM_UNSIGNED (UINT_MAX)

/*
  Some Other EIF_* defined in ETL :
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/* 
   Wrappers for `malloc', `calloc' and `realloc' :
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
void* se_realloc(void *ptr, size_t size);

/*
   And so we can catch the exits :
*/
void  se_exit(int exit_code);

/*
   find out if the machine we're running on is little endian :
*/
int   machine_is_little_endian();

/* $Revision: 4184 $ */


/* --- Mangling Table Start ---
A 1  T8    E POINTER 8
A 1  T6    E BOOLEAN 6
A 1  T3    E CHARACTER 3
D    T23   R INTEGER_REF
A 1  T26   R STD_FILE_WRITE 26
D    T28   R POINTER_REF
D    T25   R BOOLEAN_REF
A 1  T36   R FIXED_ARRAY[STRING] 36
A 1  T37   E NATIVE_ARRAY[STRING] 37
A 1  T18   R GEN_N_FILES 18
A 1  T7    R STRING 7
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
A 1  T2    E INTEGER 2
D 2  T27   R OUTPUT_STREAM 32,26
D    T29   R CHARACTER_REF
A 1  T32   R STD_ERROR 32
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S26 T26;
typedef struct S36 T36;
typedef struct S7 T7;
typedef struct S18 T18;
typedef struct S32 T32;

/*C Header Pass 2 :*/
typedef T0**T37;
typedef T3*T9;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
void se_prinT8(T8*o);
void se_prinT6(T6*o);
void se_prinT3(T3*o);
struct S26{Tid id;T0* _path;T8 _output_stream;};
extern T26 M26;
void se_prinT26(T26**o);
struct S36{Tid id;T37 _storage;T2 _capacity;T2 _upper;};
extern T36 M36;
void se_prinT36(T36**o);
void se_prinT37(T37*o);
struct S18{Tid id;};
extern T18 M18;
void se_prinT18(T18**o);
struct S7{Tid id;T9 _storage;T2 _count;T2 _capacity;T2 _key;};
extern T7 M7;
void se_prinT7(T7**o);
void se_prinT9(T9*o);
void se_prinT2(T2*o);
struct S32{Tid id;};
extern T32 M32;
void se_prinT32(T32**o);

/*
  This file (fine/lib/runtime/check.h) is automatically included 
  when `system_check' is true (ie. all modes except mode -no_check).
*/
#define SE_CHECK 1

void se_prinT0(T0**o);

/* Special routines to assist in printing characters and strings. */
/* They are called by the se_prinTn routines, which are generated */
/* by the TYPE_CHARACTER and TYPE_STRING classes in the compiler. */

int  se_counTchar(unsigned char c);
void se_puTchar(unsigned char c, FILE* stream);
int  se_longesTline(char* storage, int count);
void se_puTshortlines(FILE* stream, char *ptr, int cnt, char *nlstr);
void se_puTlonglines(FILE* streadm, char *ptr, int cnt, char* nlstr, int max);


/* 
   This type is used to store a position in some Eiffel source file.
   It must be compatible with the implementation of class POSITION.
*/
typedef unsigned int se_position;

EIF_INTEGER se_position2line(se_position position);
EIF_INTEGER se_position2column(se_position position);
EIF_INTEGER se_position2path_id(se_position position);

/*
  To be able to print a stack frame in a human readable format :
*/
typedef struct _se_frame_descriptor se_frame_descriptor;
struct _se_frame_descriptor {
  char* name;
  int use_current;
  int local_count; /* Number of C variable to print. */
  char* local_format; /* Format information. */
  int assertion_flag; /* 1 when assertions can be checked. */ 
};

/*
  To keep the track of execution in order to be able to print a 
  dump when things goes wrong :
*/
typedef struct _se_dump_stack se_dump_stack;
struct _se_dump_stack {
  se_frame_descriptor* fd;
  void** current; /* NULL when not used. */
  se_position p; /* The current position. */
  se_dump_stack* caller; /* Back to the caller. */
  void*** locals;
};
extern se_dump_stack* se_dst;
void se_print_run_time_stack(void);
void se_print_one_frame(se_dump_stack*ds);
void se_core_dump(char *msg);

extern int se_rspf;
extern int se_require_uppermost_flag;
extern int se_require_last_result;
int se_rci(void*C);
void error0(char*m,char*vv);
void error1(char*m,se_position position);
void error2(T0*o,se_position position);
T0* vc(void*o,se_position position);
T0* ci(int id,void*o,se_position position);
void ac_req(int v,char*vv);
void ac_ens(int v,char*vv);
void ac_inv(int v,char*vv);
void ac_liv(int v,char*vv);
void ac_insp(int v);
int ac_lvc(int lc,int lv1,int lv2);
void ac_civ(int v,char*vv);
void se_evobt(void*o,se_position position);
void sigrsp(int sig);
void se_gc_check_id(void*o,int id);

/* $Revision: 4184 $ */


/*
  This file (sys/runtime/trace.h) is automatically included when 
  `system_check' is true (ie. all modes except -no_check).
  This file comes after no_check.[hc] to implements the -trace flag.
*/
#ifdef SE_WEDIT
se_position se_trace(se_position p);
#elif SE_TRACE
void se_trace(se_dump_stack*ds,se_position p);
#endif
/* $Revision: 4184 $ */


/*
  This file (fine/lib/runtime/exception.h) is automatically included 
  when exception handling is used somewhere in the live code.
*/

#define SE_EXCEPTIONS 1

/*
  Constants from Eiffel class EXCEPTIONS :
*/
#define Check_instruction 	  1
#define Class_invariant 	  2
#define Developer_exception 	  3
#define Incorrect_inspect_value   4
#define Loop_invariant 		  5
#define Loop_variant 		  6
#define No_more_memory  	  7
#define Postcondition 		  8
#define Precondition  		  9
#define Routine_failure  	  10
#define	Os_signal		  11
#define Void_attached_to_expanded 12
#define Void_call_target 	  13

/* 
   This will be the structure of rescue contexts.  A rescue context 
   will be declared for every routine that has a rescue clause.

   The `next' pointer is the address of the next rescue context if there
   is one higher up the call chain, or NULL if there is no other
   context.
*/
struct rescue_context {
  JMP_BUF jb;
#ifdef SE_CHECK
  /* To keep track of dump stack to unwind it safely
     before the LONGJMP :
  */
  struct _se_dump_stack * top_of_ds ;
#endif
  struct rescue_context *next;
};

extern struct rescue_context *rescue_context_top;
extern int internal_exception_number;
extern int original_internal_exception_number;
extern int signal_exception_number;
extern char *additional_error_message;

void setup_signal_handler(void);
void signal_exception_handler(int);
void internal_exception_handler(int);
void print_exception(void);
/* $Revision: 4184 $ */

T6 r6_ix_not(se_dump_stack*caller,T6 C);
extern se_frame_descriptor f6_ix_not;
T6 r6_px_or(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_or;
T6 r6_px_and(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_and;
T6 r3_px_6061(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_6061;
T6 r3is_equal(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3is_equal;
T6 r3is_digit(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3is_digit;
T6 r3is_separator(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3is_separator;
T6 r3in_range(se_dump_stack*caller,T3 C,T3 a1,T3 a2);
extern se_frame_descriptor f3in_range;
T6 r3_px_6261(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_6261;
T2 r3value(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3value;
T6 r3_px_60(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_60;
T2 r3decimal_value(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3decimal_value;
T6 r2is_equal(se_dump_stack*caller,T2 C,T2 a1);
extern se_frame_descriptor f2is_equal;
T6 r2divisible(se_dump_stack*caller,T2 a1);
extern se_frame_descriptor f2divisible;
T6 r2in_range(se_dump_stack*caller,T2 C,T2 a1,T2 a2);
extern se_frame_descriptor f2in_range;
void r2store(se_dump_stack*caller,T2 C,T0* a1);
extern se_frame_descriptor f2store;
T3 r2digit(se_dump_stack*caller,T2 C);
extern se_frame_descriptor f2digit;
void r2append_in(se_dump_stack*caller,T2 C,T0* a1);
extern se_frame_descriptor f2append_in;
T6 r37is_not_null(se_dump_stack*caller,T37 C);
extern se_frame_descriptor f37is_not_null;
void r37clear(se_dump_stack*caller,T37 C,T2 a1,T2 a2);
extern se_frame_descriptor f37clear;
T6 r37all_default(se_dump_stack*caller,T37 C,T2 a1);
extern se_frame_descriptor f37all_default;
T9 r9realloc(se_dump_stack*caller,T9 C,T2 a1,T2 a2);
extern se_frame_descriptor f9realloc;
T6 r9fast_memcmp(se_dump_stack*caller,T9 C,T9 a1,T2 a2);
extern se_frame_descriptor f9fast_memcmp;
T6 r9fast_has(se_dump_stack*caller,T9 C,T3 a1,T2 a2);
extern se_frame_descriptor f9fast_has;
void r9copy_at(se_dump_stack*caller,T9 C,T2 a1,T9 a2,T2 a3);
extern se_frame_descriptor f9copy_at;
T6 r9is_not_null(se_dump_stack*caller,T9 C);
extern se_frame_descriptor f9is_not_null;
void r9copy_from(se_dump_stack*caller,T9 C,T9 a1,T2 a2);
extern se_frame_descriptor f9copy_from;
void r7copy(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7copy;
T3 r7last(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7last;
T2 r7upper(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7upper;
T6 r7is_equal(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7is_equal;
T3 r7item(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7item;
T6 r7valid_index(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7valid_index;
void r7append(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7append;
T6 r7is_integer(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7is_integer;
void r7make(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7make;
T6 r7is_empty(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7is_empty;
T6 r7is_mutable(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7is_mutable;
void r7extend(se_dump_stack*caller,T7* C,T3 a1);
extern se_frame_descriptor f7extend;
T6 r7_px_60(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7_px_60;
T6 r7standard_is_equal(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7standard_is_equal;
T6 r7has(se_dump_stack*caller,T7* C,T3 a1);
extern se_frame_descriptor f7has;
T2 r7to_integer(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7to_integer;
T8 r7to_external(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7to_external;
extern se_frame_descriptor se_ifd7;
T7*se_i7(se_dump_stack*caller,T7*C);
T2 r36count(se_dump_stack*caller,T36* C);
extern se_frame_descriptor f36count;
void r36put(se_dump_stack*caller,T36* C,T0* a1,T2 a2);
extern se_frame_descriptor f36put;
T0* r36item(se_dump_stack*caller,T36* C,T2 a1);
extern se_frame_descriptor f36item;
T6 r36valid_index(se_dump_stack*caller,T36* C,T2 a1);
extern se_frame_descriptor f36valid_index;
void r36make(se_dump_stack*caller,T36* C,T2 a1);
extern se_frame_descriptor f36make;
T6 r36is_empty(se_dump_stack*caller,T36* C);
extern se_frame_descriptor f36is_empty;
T6 r36all_default(se_dump_stack*caller,T36* C);
extern se_frame_descriptor f36all_default;
extern se_frame_descriptor se_ifd36;
T36*se_i36(se_dump_stack*caller,T36*C);
void r26put_new_line(se_dump_stack*caller,T26* C);
extern se_frame_descriptor f26put_new_line;
void r26disconnect(se_dump_stack*caller,T26* C);
extern se_frame_descriptor f26disconnect;
T6 r26is_connected(se_dump_stack*caller,T26* C);
extern se_frame_descriptor f26is_connected;
void r26make(se_dump_stack*caller,T26* C);
extern se_frame_descriptor f26make;
void r26connect_to(se_dump_stack*caller,T26* C,T0* a1);
extern se_frame_descriptor f26connect_to;
void r26put_integer(se_dump_stack*caller,T26* C,T2 a1);
extern se_frame_descriptor f26put_integer;
void r26put_character(se_dump_stack*caller,T26* C,T3 a1);
extern se_frame_descriptor f26put_character;
void r26put_string(se_dump_stack*caller,T26* C,T0* a1);
extern se_frame_descriptor f26put_string;
void r26fclose(se_dump_stack*caller,T8 a1);
extern se_frame_descriptor f26fclose;
void r32put_new_line(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32put_new_line;
void r32make(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32make;
void r32put_character(se_dump_stack*caller,T32* C,T3 a1);
extern se_frame_descriptor f32put_character;
void r32put_string(se_dump_stack*caller,T32* C,T0* a1);
extern se_frame_descriptor f32put_string;
extern T0*oBC1command_arguments;
extern int fBC1command_arguments;
T0* r18command_arguments(se_dump_stack*caller);
extern se_frame_descriptor f18command_arguments;
T2 r18argument_count(se_dump_stack*caller,T18* C);
extern se_frame_descriptor f18argument_count;
void r18make(se_dump_stack*caller,T18* C);
extern se_frame_descriptor f18make;
T0* r18argument(se_dump_stack*caller,T18* C,T2 a1);
extern se_frame_descriptor f18argument;
extern T0*oBC18file;
extern int fBC18file;
T0* r18file(se_dump_stack*caller);
extern se_frame_descriptor f18file;
extern T0*oBC1std_error;
extern T18*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 38
extern T7* g[];
extern T7* t[];
extern char* p[];
extern void(*se_prinT[38])(void**);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms18_16016;
extern T7*ms18_2263847;
extern T7*ms18_189106055;
extern T7*ms18_288;
extern T7*ms18_526111769;
extern T7*ms18_1488;
extern T7*ms2_117797837;
extern T7*ms18_9366;
extern T7*ms18_48;
extern T7*ms18_483529661;
T7*se_ms(int c,char*e);
T7*se_string(char*e);
void se_msi1(void);
void X27put_character(se_dump_stack*caller,se_position position,T0*C,T3 a1);

#ifdef __cplusplus
}
#endif
