/*
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

/* This file just contains the C_structs that changed between 0014 and 0016  */


typedef struct {
    EveryObject header;
    ObjRef name;
    ObjRef date;
    ObjRef capital;
    ObjRef postal_code;
    uint8 number;
} C_struct_US_State_0014;

typedef struct {
    EveryObject header;
    uint8 count;
    char storage[0];
} C_struct_Year_0014;

typedef struct {
    EveryObject header;
    ObjRef definition;
    char storage[2];
    uint8 minimum_days;
    uint8 maximum_days;
} C_struct_Month_0014;

typedef struct {
    EveryObject header;
    ObjRef year;
    ObjRef month;
    uint8 day_of_month;
} C_struct_Date_0014;

typedef struct {
    EveryObject header;
    ObjRef file;
    uint8 count;
    char storage[0];
} C_struct_File_Path_0014;

typedef struct {
    EveryObject header;
    ObjRef gender;
    ObjRef title;
    ObjRef first_name;
    ObjRef middle_name;
    ObjRef last_name;
    ObjRef maiden_name;
    ObjRef preferred_name;
    ObjRef goes_by;
    ObjRef nickname;
    ObjRef birth_date;
    ObjRef birth_place;
    ObjRef death_date;
    ObjRef death_place;
    ObjRef height;
    ObjRef mailing_address;
} C_struct_Person_0014;


