/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../crc32.h"
#include "../objectify_private.h"



int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef acronym_ref;
    ObjRef cu_ref;
    C_struct_Credit_Union cu_obj;
    int i;

    struct name_acronym
    {
      char* name;
      char* acronym;
    };

    struct name_acronym credit_unions[] = {
      { "America First",    "AFCU" },
      { "Deseret First",    "DFCU" },
      { "Mountain America", "MACU" },
      { "Salt Lake City Credit Union", "SLCCU" },
      { "Trans West",       "TWCU" },
      { "Utah First",       "UFCU" },
    };
    const int num_credit_unions = (sizeof(credit_unions) / sizeof(struct name_acronym));


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_set_encryption_level(Encryption_None);

    printf("Adding acronyms to credit unions on: %s\n", DEFAULT_FILE);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);

    for (i = 0; i < num_credit_unions; i++)
    {
	printf("%s: ", credit_unions[i].name);

	assert(nwos_find_public_credit_union(credit_unions[i].name, &cu_ref));

	assert(nwos_read_object_from_disk(&cu_ref, &cu_obj, sizeof(cu_obj)));

	nwos_create_public_acronym(credit_unions[i].acronym, &acronym_ref);

	assert(is_void_reference(&cu_obj.acronym));

	copy_reference(&cu_obj.acronym, &acronym_ref);

	nwos_add_to_references(&cu_ref, &cu_obj.acronym);

	nwos_crc32_calculate((uint8*) &cu_obj.full_name, sizeof(cu_obj) - sizeof(EveryObject), cu_obj.header.common.data_chksum);

	nwos_overwrite_object_to_disk(&cu_ref, &cu_obj, sizeof(cu_obj));

	printf("reference: %02x%02x%02x%02x\n", 
	       acronym_ref.id[0],
	       acronym_ref.id[1],
	       acronym_ref.id[2],
	       acronym_ref.id[3]);
    }

    nwos_terminate_objectify();

    return 0;
}

