/*
--         This file is part of the New World OS and Objectify projects
--                    Copyright (C) 2004-2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: storage.h,v $
-- Revision 1.2  2009/04/14 11:35:13  jsedwards
-- Added external declaration for new nwos_storage_is_compressed_file function.
--
-- Revision 1.1  2009/04/13 13:02:14  jsedwards
-- Moved external declarations from gen_id.h and added new declarations for
-- new functions created from disk_io.c.
--
*/

#ifndef STORAGE_H
#define STORAGE_H

#include "reference.h"
#include "types.h"


extern void nwos_initialize_storage(AccessType type, const char* path);
extern void nwos_terminate_storage(void);

extern bool nwos_storage_is_public_only(void);
extern bool nwos_storage_is_compressed_file(void);
extern bool nwos_storage_is_read_write(void);

extern void nwos_flush_storage(void);

extern bool nwos_read_block(ObjRef* ref, uint8* block);          /* Note: this assumes that block is FILE_BLOCK_SIZE */
extern void nwos_write_block(ObjRef* ref, uint8* block);         /* Note: this assumes that block is FILE_BLOCK_SIZE */
extern void nwos_erase_block(ObjRef* ref);

#endif

