--
--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: play_music.e,v $
-- Revision 1.4  2009/07/21 18:18:50  jsedwards
-- Moved read and write list functions to new song_list class and added --pause
-- option.
--
-- Revision 1.3  2008/12/29 15:41:10  jsedwards
-- Added commands after the programs return.
--
-- Revision 1.2  2008/12/29 15:27:21  jsedwards
-- Removed paths from executables.
--
-- Revision 1.1  2008/11/28 17:11:56  jsedwards
-- Initial experimental quick hack.
--
--


class PLAY_MUSIC

creation make

feature

   played_list: SONG_LIST
   favorites_list: SONG_LIST

   playable(path: STRING): BOOLEAN is
      local
         i: INTEGER
      do
         if path.has_suffix(".mp3") or path.has_suffix(".ogg") then
            if argument_count = 0 or (argument_count = 1 and then argument(1).is_equal("--pause")) then
               Result := not played_list.has(path)
            else
               from
                  i := 1
               until
                  Result or else i > argument_count
               loop
                  if path.has_string(argument(i)) then
                     Result := not played_list.has(path)
                  end
                  i := i + 1
               end
            end
         end
      end

   make is
      local
         assoc_class_def: CLASS_DEFINITION
	 assoc_obj: PATH_AND_FILE_ASSOCIATION
         path_obj: FILE_PATH
         tmp_path: STRING
         home_path: STRING
         command: STRING
         played_list_path: STRING
         favorites_list_path: STRING
         i: INTEGER
         start_time: INTEGER
         pausing: BOOLEAN
         
      do
         !!played_list.with_capacity(4000)
         !!favorites_list.with_capacity(2000)

         pausing := argument_count = 1 and then argument(1).is_equal("--pause");

         if argument_count = 0 or pausing then
            home_path := get_environment_variable("HOME")

            if home_path = Void then
               std_error.put_string("ERROR: HOME environment variable is not set%N")
               die_with_code(exit_failure_code)
            end

            !!played_list_path.make(home_path.count)
            played_list_path.copy(home_path)
            played_list_path.append("/played_list.txt")
            if not played_list.read_list(played_list_path) then
               std_error.put_string("WARNING: could not open played list, starting from beginning%N")
            end

            !!favorites_list_path.make(home_path.count)
            favorites_list_path.copy(home_path)
            favorites_list_path.append("/favorites_list.txt")
            if not favorites_list.read_list(favorites_list_path) then
               std_error.put_string("WARNING: could not open favorites list, new list will be created%N")
            end
         end


         nwos_initialize_objectify(0x52454144, Void);

	 !!assoc_class_def.find("PATH AND FILE ASSOCIATION")

         if assoc_class_def.reference.is_void then
	     std_output.put_string("No files are stored in the system!%N")
         else
             std_output.put_string("Assoc class: ")
             assoc_class_def.reference.dump

             std_output.put_string("Number of files: ")
             std_output.put_integer(assoc_class_def.references.count)
             std_output.put_new_line

             !!tmp_path.make(24)
             !!command.make(48)

             from
                i := assoc_class_def.references.lower
             until
                i > assoc_class_def.references.upper
             loop
--                assoc_class_def.references.item(i).dump

                if assoc_class_def.references.item(i).object_class.is_equal(assoc_class_def.reference) then
                   !!assoc_obj.read_from_disk(assoc_class_def.references.item(i))
--                   std_output.put_string("path: ")
--                   assoc_obj.path.dump

                   !!path_obj.read_from_disk(assoc_obj.path)
--                   std_output.put_string(path_obj.path)
--                   std_output.put_new_line

                   if (playable(path_obj.path)) then
                      tmp_path.copy(path_obj.path)
                      tmp_path.fill('-')
                      tmp_path.extend('%N')
                      std_output.put_string(tmp_path)
                      std_output.put_string(path_obj.path)
                      std_output.put_new_line
                      std_output.put_string(tmp_path)

                      tmp_path.copy("/tmp/")
                      assoc_class_def.references.item(i).append_in(tmp_path)
                      if path_obj.path.has_suffix(".mp3") then
                         tmp_path.append(".mp3")
                         command.copy("mpg321 ")
                      else
                         tmp_path.append(".ogg")
                         command.copy("ogg123 ")
                      end
                      std_output.put_string(tmp_path)
                      std_output.put_new_line

                      if nwos_restore_file(assoc_class_def.references.item(i).to_external, tmp_path.to_external) then
                         command.append(tmp_path)
                         start_time := get_unix_time
                         system(command)
                         remove_file(tmp_path)

                         if pausing or get_unix_time - start_time < 5 then
                            std_output.put_string("%N Last: ")
                            std_output.put_string(path_obj.path)
                            std_output.put_string("%N%N")

                            from
                               command.clear
                            until
                               command.is_equal("c")
                            loop
                               std_output.put_string("? ")
                               std_output.flush

                               std_input.read_line_in(command)
                               command.to_lower

                               if command.is_equal("q") then
                                  i := assoc_class_def.references.upper + 1
                                  command.copy("c")
                               elseif command.is_equal("a") then
                                  if favorites_list.has(path_obj.path) then
                                     std_output.put_string(path_obj.path)
                                     std_output.put_string(" is already in favorites list!%N")
                                  else
                                     favorites_list.add_last(path_obj.path)
                                     if favorites_list.write_list(favorites_list_path) then
                                        std_output.put_string(path_obj.path)
                                        std_output.put_string(" added to favorites list!%N")
                                     else
                                        std_error.put_string("ERROR: could not write favorites list file%N")
                                        nwos_terminate_objectify;
                                        die_with_code(exit_failure_code)
                                     end
                                  end
                                  command.clear
                               elseif command.is_equal("b") then
                                  i := assoc_class_def.references.lower
                                  std_output.put_string("Replay: ")
                                  std_output.put_string(played_list.last)
                                  std_output.put_new_line
                                  played_list.remove_last
                                  command.clear
                               elseif command.is_equal("c") then
                                  if pausing then
                                     played_list.add_last(path_obj.path)
                                     if not played_list.write_list(played_list_path) then
                                        std_error.put_string("ERROR: could not write played list file%N")
                                        nwos_terminate_objectify;
                                        die_with_code(exit_failure_code)
                                     end
                                  end
                               else
                                  std_output.put_string("Please enter 'c' for continue or 'q' for quit%N")
                                  command.clear
                               end
                            end
                            i := i - 1
                         else
                            played_list.add_last(path_obj.path)
                            if argument_count = 0 or pausing then
                               if not played_list.write_list(played_list_path) then
                                  std_error.put_string("ERROR: could not write played list file%N")
                                  nwos_terminate_objectify;
                                  die_with_code(exit_failure_code)
                               end
                            end
                         end
                      else
                         std_error.put_string("Error could not read file: ")
                         std_error.put_string(path_obj.path)
                         nwos_terminate_objectify;
                         die_with_code(exit_failure_code)
                      end
                   end
                end

                i := i + 1
             end
         end

         nwos_terminate_objectify;
      end

   nwos_initialize_objectify(mode: UNSIGNED; path: STRING) is
      external "C"
      end

   nwos_restore_file(assoc_ref: POINTER;  path: POINTER): BOOLEAN is
      external "C"
      end

   nwos_terminate_objectify is
      external "C"
      end

   get_unix_time: INTEGER is
      external "C"
      end     

end


