# 
#              This file is part of the New World OS project
#                     Copyright (C) 2007 QRW Software
#            J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#                       http://www.qrwsoftware.com
#                       http://nwos.sourceforge.com
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program, in the file LICENSE.  If not, see 
#    <http://www.gnu.org/licenses/>.
# 
#    You can also contact me via paper mail at:
# 
#       QRW Software
#       P.O. Box 27511
#       Salt Lake City, UT 84127-0511, USA.
# 
# 
#  This script runs a quick test of file importing and exporting.
# 
#  $Log: test_import_export.sh,v $
#  Revision 1.2  2008/07/12 03:14:26  jsedwards
#  Changed --remove option to verify_file to --remove-no-shred.
#
#  Revision 1.1  2008/06/05 14:44:49  jsedwards
#  Initial version.
#

echo "---------------"
echo " prep disk..."
echo "---------------"
./prep_disk 128M
sleep 4

echo "---------------"
echo " import_files..."
echo "---------------"
./import_file *.[ch]
sleep 4

echo "-----------------"
echo " export_files..."
echo "-----------------"

mkdir test
cd test
../export_file "*"
for file in ../*.[ch]; do diff -s $file .; done
sleep 4

echo "-------------------"
echo " md5 checksums..."
echo "-------------------"
../list_files --md5 | tee a.md5
md5sum -c a.md5
sleep 4

echo "-------------------"
echo " sha1 checksums..."
echo "-------------------"
../list_files --sha1 | tee a.sha1
sha1sum -c a.sha1
sleep 4

echo "---------------------"
echo " sha256 checksums..."
echo "---------------------"
../list_files --sha256 | tee a.sha256
sha256sum -c a.sha256
sleep 4

echo "---------------------"
echo " sha512 checksums..."
echo "---------------------"
../list_files --sha512 | tee a.sha512
sha512sum -c a.sha512
sleep 4

echo "---------------------"
echo " file revision..."
echo "---------------------"
sed -i -e "s/2005-2008/2005-2009/" computer.c

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
../verify_file --remove-no-shred *
echo "---------------------"
echo " files left: "
ls

echo "---------------------"
echo " add-revision..."
echo "---------------------"
../import_file --add-revision computer.c
cp -piv computer.c computer.c.save
sleep 4

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
../verify_file --remove-no-shred *
sleep 4

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
../export_file computer.c
rmdup computer.c.save computer.c
sleep 9

echo "---------------------"
echo " compress..."
echo "---------------------"
../compress_sparse compressed
sleep 4

echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
../prep_disk --no-private 128M
sleep 4

echo "---------------------"
echo " compress..."
echo "---------------------"
../expand_sparse compressed
sleep 4

../export_file "*"
for file in ../*.[ch]; do diff -s $file .; done
sleep 4

echo "-------------------"
echo " md5 checksums..."
echo "-------------------"
../list_files --md5 | tee a.md5
md5sum -c a.md5
sleep 4

echo "-------------------"
echo " sha1 checksums..."
echo "-------------------"
../list_files --sha1 | tee a.sha1
sha1sum -c a.sha1
sleep 4

echo "---------------------"
echo " sha256 checksums..."
echo "---------------------"
../list_files --sha256 | tee a.sha256
sha256sum -c a.sha256
sleep 4

echo "---------------------"
echo " sha512 checksums..."
echo "---------------------"
../list_files --sha512 | tee a.sha512
sha512sum -c a.sha512
sleep 4

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
../export_file computer.c
rmdup computer.c computer.c.save
sleep 4

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
../verify_file --remove-no-shred *
echo "---------------------"
echo " files left: "
ls

echo "---------------------------"
echo " list revision and time..."
echo "---------------------------"
../list_files --time --revision

