/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: objects.h,v $
-- Revision 1.1  2009/03/13 04:48:47  jsedwards
-- Moved various declarations from objectify.h.
--
*/


#ifndef OBJECTS_H
#define OBJECTS_H

#include "reference.h"
#include "time_stamp.h"


typedef struct {
    uint32    flags;                      /*   4 */  /* flags / version */
    ObjRef    id;                         /*   8 */  /* reference id */
    union {
      uint8     header_chksum[4];         /*  12 */  /* CRC32 of header */
      uint32    num_refs;                            /* used by reference lists only */
    };
    uint8     data_chksum[4];             /*  16 */  /* CRC32 of data   */
    TimeStamp creation_time;              /*  24 */
    TimeStamp access_time;                /*  32 */  /* used when in memory for caching */
    ObjRef    class_definition;           /*  36 */
} CommonHeader;


typedef struct {
    ObjRef    clone_of;                   /*   4 */
    ObjRef    references;                 /*   8 */
    ObjRef    context;                    /*  12 */
    ObjRef    creation;                   /*  16 */
    ObjRef    source;                     /*  20 */
    ObjRef    prev_version;               /*  24 */
    ObjRef    next_version;               /*  28 */
} ObjectHeader;


typedef struct {
    CommonHeader common;                  /*  36 */
    ObjectHeader object;                  /*  64 */
} EveryObject;

typedef struct {
    CommonHeader common_header;           /*  36 */
    ObjRef       references[0];
} ReferenceList;


typedef struct {
    CommonHeader  header;                 /*   36 */
    uint32        index[256];             /*  ??? */
    ObjRef        references[256];        /* ???? */
} IndexedReferenceList;


/* If we are making the export_c_structs program, c_structs.h doesn't   */
/* exist yet, so these need to be defined for it to build successfully. */

#ifdef USE_PREDEFINED_STRUCTS

typedef struct {
    EveryObject header;
    ObjRef name;
    uint8 count;
    ObjRef feature[0];
} C_struct_Class_Definition;

typedef struct {
    EveryObject header;
    ObjRef character_set;
    uint8 count;
    char storage[0];
} C_struct_Spelling;

typedef struct {
    EveryObject header;
    uint8 count;
    ObjRef spelling[0];
} C_struct_Name;

typedef struct {
    EveryObject header;
    ObjRef inherit;
    ObjRef class;
    ObjRef label;
    uint8 count;
} C_struct_Feature_Definition;

typedef struct {
    EveryObject header;
    ObjRef class_definition_class;
    ObjRef reference_list_class;
} C_struct_Root;

#else
#include "c_structs.h"
#endif

#endif

