/*
--             This file is part of the New World OS project
--                 Copyright (C) 2007-2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--  This program finds a pass phrase that has an entry point in the highest
--  possible chunk - 0xFFFFxxxx.
--  
--
-- $Log: find_high_entry.c,v $
-- Revision 1.3  2008/09/20 11:12:08  jsedwards
-- Added code to find one entry that has a zero in the most significant nibble.
--
-- Revision 1.2  2008/09/14 16:57:59  jsedwards
-- Change to start with abcdefghij and only use letters.
--
-- Revision 1.1  2008/09/14 16:18:31  jsedwards
-- Initial version - starts at 0123456789 and each character goes to '~'.
--
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../objectify.h"


int main()
{
    int i;
    int j;
    char pass_phrase[12] = "abcdefghij";
    uint8 big_key[16 + 8 + 4];
    uint8 high_water_mark[4] = { 0xF0, 0x00, 0x00, 0x00 };
    int zero_found = 0;

    for (i = 0; i < 10000000; i++)
    {
	if (i % 1000000 == 0) printf("%d: %s\n", i, pass_phrase);

	setenv("OBJECTIFY_TEST_ONLY_DO_NOT_USE", pass_phrase, 1);

	nwos_get_key_from_password(big_key, sizeof(big_key));

	if (big_key[20] > high_water_mark[0] ||
	    (big_key[20] == high_water_mark[0] &&
	     (big_key[21] > high_water_mark[1] ||
	      (big_key[21] == high_water_mark[1] && big_key[22] > high_water_mark[2])
	     )
	    )
	   )
	{
	    memcpy(high_water_mark, big_key + 20, sizeof(high_water_mark));
	    printf("%s: %02x%02x%02x%02x\n", pass_phrase, high_water_mark[0], high_water_mark[1], high_water_mark[2], high_water_mark[3]);
	}
	else if (big_key[20] < 0x10)
	{
	    if (zero_found == 0)
	    {
		printf("%s: %02x%02x%02x%02x\n", pass_phrase, big_key[20], big_key[21], big_key[22], big_key[23]);
		zero_found = 1;
	    }
	}

	for (j = 9; j > -1; j--)
	{
	    pass_phrase[j]++;
	    if (pass_phrase[j] <= 'z') break;
	    pass_phrase[j] = 'a';
	}
    }

    return 0;
}

