/*
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: mem_alloc.h,v $
-- Revision 1.1  2009/03/11 12:18:35  jsedwards
-- Created by moving nwos_malloc, nwos_realloc, and nwos_free external
-- declarations from the objectify.h file.
--
*/

#ifndef MEM_ALLOC_H
#define MEM_ALLOC_H

#include <stdlib.h>


extern void* nwos_malloc(size_t size);
extern void* nwos_realloc(void* oldptr, size_t size);
extern void  nwos_free(void* ptr);

#endif

