/*
--             This file is part of the New World OS project
--                    Copyright (C) 2007 QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: fix_dif.c,v $
-- Revision 1.2  2008/01/02 16:43:52  jsedwards
-- New method: read the whole file into memory and rearrange the blocks.
--
-- Revision 1.1  2008/01/02 14:14:35  jsedwards
-- First attempt at a program to repair a broken .dif file, DOES NOT WORK!
--
*/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>    /* define sleep() */

#include "../objectify_private.h"

#define BUFFER_SIZE 2097152

uint32 convert_4_uint8_to_uint32(uint8 byte[4])
{
  return ((uint32)byte[0] << 24) | ((uint32)byte[1] << 16) | ((uint32)byte[2] << 8) | (uint32)byte[3];
}


int main(int argc, char* argv[])
{
    FILE* fp1;
    FILE* fp2;
    size_t read1;
    size_t write2;
    uint32 id1 = 0;
    uint32 id2 = 0;
    uint8* buffer;
    size_t offset;
    size_t num_blocks;
    int i;
    int j;
    int duplicates = 0;


    if (argc != 3)
    {
	fprintf(stderr, "usage: %s in_file out_file\n", argv[0]);
	exit(1);
    }

    buffer = malloc(BUFFER_SIZE);

    if (buffer == NULL)
    {
	perror("allocating buffer");
	exit(1);
    }

    /* Open the file and check it */

    fp1 = fopen(argv[1], "r");
    if (fp1 == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    offset = 0;

    read1 = fread(buffer + offset, 1, FILE_BLOCK_SIZE, fp1);

    while (!feof(fp1) && read1 == FILE_BLOCK_SIZE)
    {
	offset += read1;

	read1 = fread(buffer + offset, 1, FILE_BLOCK_SIZE, fp1);

	assert(offset < BUFFER_SIZE);
    }

    if (!feof(fp1) || ferror(fp1))
    {
	perror(argv[1]);
	exit(1);
    }

    if (offset % FILE_BLOCK_SIZE != 0)
    {
	fprintf(stderr, "file size: %d not a multiple of %d\n", offset, FILE_BLOCK_SIZE);
	exit(1);
    }

    num_blocks = offset / FILE_BLOCK_SIZE;

    printf("file size: %d  blocks: %d\n", offset, num_blocks);

    fclose(fp1);

    for (i = 2; i < num_blocks - 1; i++)
    {
	id1 = convert_4_uint8_to_uint32(buffer + i * FILE_BLOCK_SIZE + 4);

	for (j = i + 1; j < num_blocks; j++)
	{
	    id2 = convert_4_uint8_to_uint32(buffer + j * FILE_BLOCK_SIZE + 4);
	    if (id1 == id2)
	    {
		duplicates++;

		printf("Duplicate block: %08x - ", id1);

		if (memcmp(buffer + i * FILE_BLOCK_SIZE, buffer + j * FILE_BLOCK_SIZE, FILE_BLOCK_SIZE) == 0)
		{
		    printf("same\n");
		}
		else
		{
		    printf("differ\n");
		    memcpy(buffer + i * FILE_BLOCK_SIZE, buffer + j * FILE_BLOCK_SIZE, FILE_BLOCK_SIZE);
		}

		memmove(buffer + j * FILE_BLOCK_SIZE, buffer + (j + 1) * FILE_BLOCK_SIZE, (num_blocks - j - 1) * FILE_BLOCK_SIZE);
		num_blocks--;
	    }
	}
    }

    printf("duplicates: %d  new blocks: %d\n", duplicates, num_blocks);

    /* Open the file and check it */

    fp2 = fopen(argv[2], "w");
    if (fp2 == NULL)
    {
	perror(argv[2]);
	exit(2);
    }

    for (i = 0; i < num_blocks; i++)
    {
	write2 = fwrite(buffer + i * FILE_BLOCK_SIZE, 1, FILE_BLOCK_SIZE, fp2);

	if (write2 != FILE_BLOCK_SIZE)
	{
	    perror(argv[2]);
	    exit(1);
	}
    }

    if (fclose(fp2) != 0)
    {
	perror(argv[2]);
	exit(1);
    }

    return 0;
}
