/*
--             This file is part of the New World OS project
--                    Copyright (C) 2007 QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: add_more_spellings.c,v $
-- Revision 1.2  2007/07/07 22:31:07  jsedwards
-- Changed to add some other words.
--
-- Revision 1.1  2007/07/07 20:48:02  jsedwards
-- Initial version.
--
*/

/* This program adds spellings to the public objects. */


#include <stdio.h>

#include "../objectify_private.h"



static char* extra_spellings[] = 
{
  "aluminium",
  "cardboard",
  "grey",
  "iron",
  "left",
  "paper",
  "pink",
  "right",
  "silver",
  "steel",
  "tin",
  "video",
};

#define NUM_EXTRA_SPELLINGS (sizeof(extra_spellings) / sizeof(char*))



int main(int argc, char* argv[])
{
    ObjRef root_obj_ref;
    int i;
    ObjRef ref;
    char msg[128];


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, 0, NULL);

    root_obj_ref.id[0] = 0;
    root_obj_ref.id[1] = 0;
    root_obj_ref.id[2] = 0;
    root_obj_ref.id[3] = 1;

    nwos_set_root_object(&root_obj_ref);

    for (i = 0; i < NUM_EXTRA_SPELLINGS; i++)
    {
	snprintf(msg, sizeof(msg), "Creating spelling: %s", extra_spellings[i]);
	nwos_log(msg);

	nwos_create_public_spelling(extra_spellings[i], &ref);
    }

    nwos_terminate_objectify();

    return 0;
}

