--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: remove_time.e,v $
-- Revision 1.3  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.2  2006/11/05 13:40:41  jsedwards
-- Added GPL header (oops).
--
--
-- Program to remove time from .csv files so that they can be diff'd.
--


class REMOVE_TIME

creation make

feature

   make is
      local
         line: STRING
      do
         !!line.make(4096)

         from
            std_input.read_line_in(line)
         until
            std_input.end_of_input
         loop
            if line.count < 43 then
               std_error.put_string("Bad line: ")
               std_error.put_string(line)
               std_error.put_new_line
            else
               line.remove_between(13, 42)
               std_output.put_string(line)
               std_output.put_new_line
            end

            std_input.read_line_in(line)
         end
      end

end

