/*
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: identify_disc.c,v $
-- Revision 1.4  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.3  2007/06/13 21:08:41  jsedwards
-- Changed to take a directory as an argument instead of a list of files.
--
-- Revision 1.2  2007/06/04 13:44:05  jsedwards
-- Add 'match' paramter to find_matchine_path_and_file_association.
--
-- Revision 1.1  2007/04/26 13:35:37  jsedwards
-- Initial version extracted from log_disc.c.
--
*/


#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "objectify.h"



int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    int i;
    char id[13];
    char* file_names[MAX_FILES_PER_DISC_LIST];
    int num_files;
    ObjRef files[MAX_FILES_PER_DISC_LIST];
    ObjRef disc_list_ref;
    bool missing_files = false;
#if 0
    bool bad_checksum = false;
    CheckFileResult check_file_result;
#endif
    uint8 kludge[MAX_SIZE_DISC_LIST];
    C_struct_Disc_List* ptr_list_obj = (C_struct_Disc_List*)kludge;
    DIR* dp;
    struct dirent *dir_entry;

    if (argc != 2)
    {
	fprintf(stderr, "usage: %s directory\n", argv[0]);
	exit(1);
    }

    dp = opendir(argv[1]);
    if (dp == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    num_files = 0;
    dir_entry = readdir(dp);
    while (dir_entry != NULL)
    {
	if (strcmp(dir_entry->d_name, ".") != 0 && strcmp(dir_entry->d_name, "..") != 0)
	{
	    if (num_files == MAX_FILES_PER_DISC_LIST)
	    {
		fprintf(stderr, "Too many files in directory: %d, currently can only handle %d files max\n",
			num_files, MAX_FILES_PER_DISC_LIST);
		exit(1);
	    }

	    file_names[num_files] = malloc(strlen(dir_entry->d_name) + 1);

	    if (file_names[num_files] == NULL)
	    {
		perror("allocating memory for file name");
		exit(1);
	    }

	    strcpy(file_names[num_files], dir_entry->d_name);

	    /* printf("%s\n", file_names[num_files]); */

	    num_files++;
	}

	dir_entry = readdir(dp);
    }

    if (closedir(dp) != 0)
    {
	perror(argv[1]);
	exit(1);
    }

    printf("\n");

    nwos_log_arguments(argc, argv);

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE_RO, DEFAULT_FILE);

    nwos_set_root_object(&root_object_ref);


    /* first verify that all the listed files are already in the system */

    memset(files, 0, sizeof(files));

    for (i = 0; i < num_files; i++)
    {
	if (!nwos_find_matching_path_and_file_association(argv[1], file_names[i], &files[i], MatchAll))
	{
	    missing_files = true;
	}
    }

    if (missing_files)
    {
	printf("The following files are not in the system:\n\n");

	for (i = 0; i < num_files; i++)
	{
	    if (is_void_reference(&files[i]))
	    {
		printf("   %s\n", file_names[i]);
	    }
	}

	printf("\n");
	exit(1);
    }

    printf("\n");

    /* find and verify the disc */

    if (!nwos_find_matching_disc_list(files, &disc_list_ref))
    {
	printf("No matching disc list found!\n");
	exit(1);
    }

    nwos_read_variable_sized_object_from_disk(&disc_list_ref, kludge, sizeof(kludge), &nwos_get_disc_list_object_size);

    memcpy(id, ptr_list_obj->id, sizeof(id) - 1);
    id[sizeof(id) - 1] = '\0';

    printf("disc list %02x%02x%02x%02x: %s\n",
	   disc_list_ref.id[0], disc_list_ref.id[1], disc_list_ref.id[2], disc_list_ref.id[3], id);

    for (i = 0; i < num_files; i++)
    {
	free(file_names[i]);
    }

    nwos_terminate_objectify();

    return 0;
}


