/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: log.c,v $
-- Revision 1.8  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.7  2007/03/07 13:10:45  jsedwards
-- Fixed bug so appending date is null terminated.
-- Changed to use file name defined in config.h so debug versions can have a
-- different file name.
--
-- Revision 1.6  2007/02/23 13:27:02  jsedwards
-- Move the strlcpy and strlcat functions from objectify.c to log.c so that
-- log.o can be used without having to drag in the whole objecitfy library.
--
-- Revision 1.5  2007/02/11 18:04:22  jsedwards
-- Added code to dynamically create the log file path using the users home
-- directory and the date.
--
-- Revision 1.4  2007/02/11 14:43:45  jsedwards
-- Cast the time value for ctime so the compiler won't complain.
--
-- Revision 1.3  2007/01/07 20:30:56  jsedwards
-- Increased size of msg buffer for logging arguments.
--
-- Revision 1.2  2006/12/28 23:24:39  jsedwards
-- Added include of sys/time.h to declare gettimeofday.
--
-- Revision 1.1  2006/12/27 14:15:24  jsedwards
-- Move log functions out of objectify.c and into a new file log.c.
--
*/


#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>
#include <unistd.h>

#include "config.h"   /* for the log file path */

/* forward references for functions that aren't supplied by GNU/Linux */
#ifdef linux
size_t strlcpy(char* dst, char* src, size_t len);
size_t strlcat(char* dst, char* src, size_t len);
#endif

/******************************************/
/* Log file - THIS NEEDS TO GO AWAY SOON. */
/******************************************/

void append_date_from_time_string(char* dst, char* time_str, size_t length)
{
    int i;
    int month;
    char* months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

    for (i = 0; i < length; i++) if (dst[i] == '\0') break;

    assert((i + 9) < length);

    dst[i++] = time_str[20];
    dst[i++] = time_str[21];
    dst[i++] = time_str[22];
    dst[i++] = time_str[23];

    for (month = 0; month < 12; month++) if (memcmp(months[month], &time_str[4], 3) == 0) break;

    assert(month < 12);

    month++;

    if (month < 10)
    {
	dst[i++] = '0';
    }
    else
    {
	dst[i++] = '1';
    }

    dst[i++] = '0' + month;

    if (time_str[8] == ' ')
    {
	dst[i++] = '0';
    }
    else
    {
	dst[i++] = time_str[8];
    }
    dst[i++] = time_str[9];

    dst[i++] = '\0';
}

void nwos_log(char* str)
{
    struct timeval tv;
    FILE* fp;
    char time_str[32];
    static char* log_file_path;
    size_t path_len;
    char* home_dir;

    gettimeofday(&tv, NULL);
    strncpy(time_str, ctime((time_t*)&tv.tv_sec), 32);
    *strchr(time_str, '\n') = '\0';

    if (log_file_path == NULL)
    {
	home_dir = getenv("HOME");

	if (home_dir == NULL)   /* no home directory?? */
	{
	    path_len = strlen(LOG_FILE_NAME) + 1 + 8 + 4 + 1;

	    log_file_path = malloc(path_len);
	    assert(log_file_path != NULL);

	    *log_file_path = '\0';
	}
	else
	{
	    path_len = strlen(home_dir) + 1 + strlen(LOG_FILE_NAME) + 1 + 8 + 4 + 1;

	    log_file_path = malloc(path_len);
	    assert(log_file_path != NULL);

	    strlcpy(log_file_path, home_dir, path_len);
	    strlcat(log_file_path, "/", path_len);
	}

	strlcat(log_file_path, LOG_FILE_NAME, path_len);
	strlcat(log_file_path, "-", path_len);
	append_date_from_time_string(log_file_path, time_str, path_len);
	strlcat(log_file_path, ".txt", path_len);

	/* printf("LOG FILE: %s\n", log_file_path); */
    }

    fp = fopen(log_file_path, "a");
    if (fp == NULL)
    {
	perror(log_file_path);
	exit(1);
    }
    fprintf(fp, "%s: %s\n", time_str, str);
    fclose(fp);
}


void nwos_log_arguments(int argc, char* argv[])
{
    int i;
    int arg;
    char* src;
    char msg[16384] = "Program:";

    i = strlen(msg);

    assert(msg[i] == '\0');

    for (arg = 0; arg < argc; arg++)
    {
	assert(i < sizeof(msg));

	msg[i] = ' ';
	i++;

	src = argv[arg];

	while (*src != '\0')
	{
	    assert(i < sizeof(msg));

	    msg[i] = *src;
	    src++;
	    i++;
	}
    }

    assert(i < sizeof(msg));

    msg[i] = '\0';

    nwos_log(msg);
}


/* since neither Linux or GNU seem to have these functions */

#ifdef linux
size_t strlcpy(char* dst, char* src, size_t len)
{
    int i;

    for (i = 0; src[i] != '\0'; i++)
    {
	if (i < len)
	{
	    dst[i] = src[i];
	}
    }

    if (i < len)
    {
	dst[i] = src[i];
    }
    else
    {
	dst[len-1] = src[i];
    }

    return i;
}

size_t strlcat(char* dst, char* src, size_t len)
{
    int i, j;

    /* find the end of the destination string */
    /* if we don't find the null before len, don't write a zero */
    for (i = 0; dst[i] != '\0'; i++)
    {
	if (i >= len)
	{
	    return len + 1 + strlen(src);
	}
    }

    for (j = 0; src[j] != '\0'; j++)
    {
	if (i < len)
	{
	    dst[i] = src[j];
	}
	i++;
    }

    if (i < len)
    {
	dst[i] = src[j];
    }
    else
    {
	dst[len-1] = src[j];
    }

    return i;
}

#endif


