--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_object_grade.e,v $
-- Revision 1.1  2007/04/14 02:24:16  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.11  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.10  2006/02/19 18:24:02  jsedwards
-- Changed attribute to a routine that makes sure current object is loaded
-- before returning any values.
--
-- Revision 1.9  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.8  2006/02/18 15:37:06  jsedwards
-- Changed name of "storage" in NWOS_STRING class to "to_string" so it makes
-- more sense in the clients.
--
-- Revision 1.7  2006/02/10 20:22:52  jsedwards
-- Create "name" object in read_body and added print statements to print it.
--
-- Revision 1.6  2006/02/10 13:52:26  jsedwards
-- Removed "load" from creation list.
--
-- Revision 1.5  2006/02/10 02:10:20  jsedwards
-- Removed the "session_log" as it is pointed to by the "log" in the header.
--
-- Revision 1.4  2006/02/09 13:06:49  jsedwards
-- Added reference parameter to "initialize header" call and removed "next
-- identifier" feature that is now in nwos_header.  Changed to the new
-- method of doing the class defintion stuff, with the "class reference"
-- and "class revision".
--
-- Revision 1.3  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.2  2006/02/05 03:11:33  jsedwards
-- Upgrade to new format.
--
-- Revision 1.1  2006/02/05 03:06:43  jsedwards
-- Renamed from nwos_object_status.e to nwos_object_grade.e.
--
-- Revision 1.2  2006/02/04 15:00:36  jsedwards
-- Changed to the new way of having a deferred class_definition.
--
-- Revision 1.1  2006/02/01 12:43:20  jsedwards
-- Initial version.
--


class NWOS_OBJECT_GRADE

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   description: STRING is
      do
         load_if_not_already
         Result := descr_obj.to_string
      ensure
         Result /= Void
      end


feature {NONE}

   make(desc: STRING) is
      do
         !!descr_obj.copy_from_string(desc)
         initialize_header(next_nwos_identifier)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      do
         descr_obj.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      do
         !!descr_obj.read_from_stream(stream)
std_output.put_string("NWOS_OBJECT_GRADE.read_body_from_stream%N")
std_output.put_string(descr_obj.to_string)
std_output.put_new_line
      end


feature {NONE}  -- once again the kludgy class definition stuff

   descr_obj: NWOS_STRING


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.1 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_object_grade_ref
      end

end

