/*             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: add_manufacturer.c,v $
-- Revision 1.3  2007/05/25 13:42:09  jsedwards
-- Moved code to create manufacturer object into 'create_public_manufacturer
-- function in 'device.c'.
--
-- Revision 1.2  2007/05/25 13:06:37  jsedwards
-- Add code to warn if name or acronym already exists.
--
-- Revision 1.1  2007/05/24 13:28:14  jsedwards
-- Initial version created from add_credit_union.
--
*/

#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../objectify_private.h"
#include "../crc32.h"

#define MAX_NAME_SIZE 96
#define MAX_URL_SIZE 64
#define MAX_ACRONYM_SIZE 8


static void get_input(char* descr, char* buffer, size_t size)
{
    char *ptr;

    while (1)
    {
	printf("%s: ", descr);
	fflush(stdout);
	fgets(buffer, size, stdin);
	ptr = strchr(buffer, '\n');
	if (ptr != NULL)
	{
	    *ptr = '\0';
	    break;
	}
	do { fgets(buffer, size, stdin); } while (strchr(buffer, '\n') == NULL);
	printf("input too long - try again!\n");
    }
}


int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef reference;
    char brand_name[MAX_NAME_SIZE];
    char acronym[MAX_ACRONYM_SIZE];
    char url[MAX_URL_SIZE];
    C_struct_Manufacturer test_mfr_obj;
    char test_string[128];
    ReferenceList* ref_list;
    int num_refs;


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_set_encryption_level(Encryption_None);

    printf("Adding manufacturer on: %s\n", DEFAULT_FILE);

    printf("next_reference: %02x%02x%02x%02x\n", 
	   nwos_next_public_ref.id[0],
	   nwos_next_public_ref.id[1],
	   nwos_next_public_ref.id[2],
	   nwos_next_public_ref.id[3]);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);


    get_input("brand name", brand_name, sizeof(brand_name));
    get_input("acronym", acronym, sizeof(acronym));
    get_input("url", url, sizeof(url));

    printf("\n");

    if (nwos_find_public_name(brand_name, &reference))
    {
	printf("WARNING: name %s already in database\n", brand_name);
    }

    if (nwos_find_public_acronym(acronym, &reference))
    {
	printf("WARNING: acronym %s already in database\n", acronym);
    }


    if (nwos_ask_yes_or_no(NULL, "Create?"))
      {
	nwos_create_public_manufacturer(brand_name,
					*acronym == '\0' ? NULL : acronym,
					*url == '\0' ? NULL : url,
					&reference);
    }

    nwos_read_object_from_disk(&reference, &test_mfr_obj, sizeof(test_mfr_obj));

    assert(nwos_name_to_string(&test_mfr_obj.brand_name, test_string, sizeof(test_string)));
    printf("brand name: %s\n", test_string);

    if (!is_void_reference(&test_mfr_obj.acronym))
    {
	assert(nwos_acronym_to_string(&test_mfr_obj.acronym, test_string, sizeof(test_string)));
	printf("acronym: %s\n", test_string);
    }

    if (!is_void_reference(&test_mfr_obj.url_list))
    {
	ref_list = nwos_malloc_reference_list(&test_mfr_obj.url_list);

	num_refs = ref_list->common_header.num_refs;

	if (num_refs != 1)
	{
	    printf("Error: number of URLs is not 1: %d\n", num_refs);
	}
	else
	{
	    assert(nwos_url_to_string(&ref_list->references[0], test_string, sizeof(test_string)));
	    printf("url: %s\n", test_string);
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;
    }

    nwos_terminate_objectify();

    return 0;
}


