/*
--                This file is part of the New World OS project
--                       Copyright (C) 2006 QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--
--  This program is free software; you can redistribute it and/or modify it 
--  under the terms of the GNU General Public License as published by the 
--  Free Software Foundation; either version 2 of the License, or (at your 
--  option) any later version.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
--  for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to:
--
--      Free Software Foundation, Inc.
--      51 Franklin Street, Fifth Floor
--      Boston, MA   02110-1301
--      USA
--
--  On the internet: http://www.fsf.org/licenses/gpl.html
--
-- $Log: predefined_references.h,v $
-- Revision 1.1  2007/06/03 12:40:56  jsedwards
-- Moved from root directory.
--
-- Revision 1.19  2006/05/01 12:42:06  jsedwards
-- Removed binary_bits and number_of_bits attribute definitions.  This
-- information is encoded into the reference itself, it is generally a
-- bad idea to duplicate information in two places.
--
-- Revision 1.18  2006/04/16 13:54:45  jsedwards
-- Changed "list" attributes to plain attributes for now, not going to
-- implement lists right now.
--
-- Revision 1.17  2006/04/12 12:47:07  jsedwards
-- Added declarations for attributes for list of character codes, definitions,
-- and heirs.
--
-- Revision 1.16  2006/04/12 11:54:05  jsedwards
-- Added references for description objects for definitions.
--
-- Revision 1.15  2006/04/11 13:04:59  jsedwards
-- Added "inherit" and "implementation" attributes, "base" definition, and
-- "deferred" and "effective" values.
--
-- Revision 1.14  2006/04/09 14:50:49  jsedwards
-- Added "attribute" and "description" attributes and "create_definition"
-- external declration.
--
-- Revision 1.13  2006/04/09 14:11:39  jsedwards
-- Changed specific values (mutable, immutable, etc.) to "values" instead of
-- "definitions".
--
-- Revision 1.12  2006/04/09 03:26:19  jsedwards
-- Changed the attribute definitions a bit and added the definitions.
--
-- Revision 1.11  2006/04/08 13:59:23  jsedwards
-- Added references needed to create a binary code object.
--
-- Revision 1.10  2006/03/26 15:29:33  jsedwards
-- Moved domain defintions out of predefined_references.h and into domains.h.
--
-- Revision 1.9  2006/03/25 14:10:16  jsedwards
-- Moved the defintions from predefined_references.h to .c file.
--
-- Revision 1.8  2006/03/25 14:06:45  jsedwards
-- Rearranged the definitions so that they have id and defintion on the same
-- line, instead of every other line.
--
-- Revision 1.7  2006/03/18 15:26:27  jsedwards
-- Added thing definition and definition definition in english (this version
-- still won't compile).
--
-- Revision 1.6  2006/03/18 14:36:58  jsedwards
-- Added forms for attribute, binary code definition, and sample binary code
-- from notebook.  They are just written in english so this won't compile.
--
-- Revision 1.5  2006/03/18 14:33:34  jsedwards
-- Rearranged the domains again.
--
-- Revision 1.4  2006/03/11 15:01:50  jsedwards
-- Eliminated "universe" domain and divided up "numbers" domain.
--
-- Revision 1.3  2006/03/11 13:53:41  jsedwards
-- Split up numbers differently.
--
-- Revision 1.2  2006/03/10 14:27:02  jsedwards
-- Changed numbers to be a sub-domain of universe.  Added the void reference
-- and the first eleven ordinal numbers.
--
-- Revision 1.1  2006/03/10 13:56:59  jsedwards
-- Moved "domains" into a new include file: "predefinded_references.h".
--
-- Revision 1.2  2006/03/09 19:14:34  jsedwards
-- Changed universe to the 00 domain because that is where all things should
-- be.  The ID 00...00 should be the "Void"/"Empty" thing.
--
-- Revision 1.1  2006/03/06 19:51:17  jsedwards
-- Initial version, incomplete.
--
*/

#ifndef PREDEFINED_REFERENCES_H
#define PREDEFINED_REFERENCES_H

#include <stdio.h>    /* define FILE */

#include "domains.h"
#include "reference.h"
#include "types.h"


extern const reference Ref_void;
extern const reference Ref_binary_bits;

extern const reference Ref_attr_attribute;
extern const reference Ref_attr_char_code_ref;
extern const reference Ref_attr_creation;
extern const reference Ref_attr_definition;
extern const reference Ref_attr_definition_ref;
extern const reference Ref_attr_description;
extern const reference Ref_attr_heir_ref;
extern const reference Ref_attr_implementation;
extern const reference Ref_attr_inherit;
extern const reference Ref_attr_multiplicity;
extern const reference Ref_attr_mutability;
extern const reference Ref_attr_presence;
extern const reference Ref_attr_type;

extern const reference Ref_the_big_bang;

extern const reference Ref_cardinal_8;

extern const reference Ref_def_attribute;
extern const reference Ref_def_base;
extern const reference Ref_def_binary_code;
extern const reference Ref_def_cardinal_number;
extern const reference Ref_def_creation_info;
extern const reference Ref_def_definition;

extern const reference Ref_desc_attribute;
extern const reference Ref_desc_base;
extern const reference Ref_desc_binary_code;
extern const reference Ref_desc_cardinal_number;
extern const reference Ref_desc_creation_info;
extern const reference Ref_desc_definition;

extern const reference Ref_val_deferred;
extern const reference Ref_val_effective;
extern const reference Ref_val_immutable;
extern const reference Ref_val_multiple;
extern const reference Ref_val_mutable;
extern const reference Ref_val_optional;
extern const reference Ref_val_required;
extern const reference Ref_val_single;



/* this probably isn't the correct place for these, but for now... */

extern void write_pair(const reference a, const reference b, FILE* fp);
extern void write_file_header(const reference id, FILE* fp);
extern void create_attribute(const reference id, const reference log, const reference presence, 
			     const reference plurality, const reference mutability, const reference type);
extern void create_definition(const reference id, const reference log, const reference description, 
			      const reference implemenation, const reference inherit, const reference* attributes[]);


#endif  /* PREDEFINED_REFERENCES_H */

