--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_character_set.e,v $
-- Revision 1.6  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.5  2006/02/19 18:42:41  jsedwards
-- This class currently isn't used, when it is used again it needs to be fixed
-- to load the object, etc.  I make a syntax error so it won't compile to
-- notify anyone if use is attempted.
--
-- Revision 1.4  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.3  2006/02/02 02:05:44  jsedwards
-- Removed passing class reference to "initialize header".
--
-- Revision 1.2  2006/01/31 19:31:08  jsedwards
-- Added new kludgy class definition stuff.
--
-- Revision 1.1  2006/01/29 18:17:06  jsedwards
-- Initial version.
--


class NWOS_CHARACTER_SET

inherit NWOS_OBJECT

creation make

feature

   name: NWOS_REFERENCE is   -- these all need to be fixed to load object, etc.

   description: NWOS_REFERENCE is

   mapping: DICTIONARY[NWOS_REFERENCE, NWOS_REFERENCE] is


feature

   add_mapping(character, binary_code: NWOS_REFERENCE) is
      do
         mapping.put(binary_code, character)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      require
         mapping.count > 0
      local
         i: INTEGER
      do
         name.write_to_stream(stream)

         description.write_to_stream(stream)

         inspect
            mapping.count
         when 1 .. 255 then
            stream.put_character((1).to_character)
            stream.put_8_bit_unsigned(mapping.count.to_unsigned)
         when 256 .. 65535 then
            stream.put_character((2).to_character)
            stream.put_16_bit_unsigned(mapping.count.to_unsigned)
         when 65536 .. 16777215 then
            stream.put_character((3).to_character)
            stream.put_24_bit_unsigned(mapping.count.to_unsigned)
         else
            stream.put_character((4).to_character)
            stream.put_32_bit_unsigned(mapping.count.to_unsigned)
         end

         from
            i := mapping.lower
         variant
            mapping.upper - i
         until
            i > mapping.upper
         loop
            mapping.key(i).write_to_stream(stream)
            mapping.item(i).write_to_stream(stream)
            i := i + 1
         end
      end

feature {NONE}

   make(size: INTEGER) is
      do
         initialize_header

         name := Void_reference
         description := Void_reference

         !!mapping.with_capacity(size)
      end


feature -- fill in the class definition kludgy stuff

   class_name: STRING is "nwos_character_set.e"

   class_definition_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0xC0000009)   -- the class definition class reference
      end


invariant

   mapping /= Void

end

