/*             This file is part of the New World OS project
--                   Copyright (C) 2005  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package; see the file LICENSE.   If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: language.c,v $
-- Revision 1.7  2006/11/11 12:01:04  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.6  2006/10/26 01:51:27  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.5.2.1  2006/09/01 13:27:20  jsedwards
-- Changed "nwos_object_size" to "nwos_reference_list_size" and added the
-- object reference to "nwos_fill_in_common_header" so it can put the "id"
-- in the header now.
--
-- Revision 1.5  2005/12/29 17:50:53  jsedwards
-- Commented out printf debugging statements, that aren't useful now.
--
-- Revision 1.4  2005/12/29 17:01:41  jsedwards
-- Changed to just read spelling obj header to get reference list instead of
-- the whole variable sized object.
--
-- Revision 1.3  2005/12/27 18:34:05  jsedwards
-- Changed to look up class definition instead of using a fixed file name.
-- Also changed so that object id is random instead of fixed filename.
--
-- Revision 1.2  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.1  2005/12/11 16:38:50  jsedwards
-- Moved create english language function from create_class_def file and
-- added "find_language" function.
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>   /* define memset */

#include "crc32.h"
#include "objectify.h"
#include "objectify_private.h"


bool nwos_find_language(char* word, ObjRef* ref)
{
    C_struct_Word word_obj;
    EveryObject spelling_header;
    ObjRef word_class_ref;
    ObjRef lang_class_ref;
    ObjRef spelling_ref;
    ObjRef object_class;
    ReferenceList* ref_list;
    size_t ref_list_size;
    int num_spellings;
    int i;
    bool result = false;

    assert(nwos_find_class_definition("WORD", &word_class_ref));

    assert(nwos_find_class_definition("LANGUAGE", &lang_class_ref));

    if (nwos_find_spelling(word, &spelling_ref)) /* the spelling exists, search for word */
    {
	nwos_read_object_headers_from_disk(&spelling_ref, &spelling_header);

	ref_list_size = nwos_reference_list_size(&spelling_header.object.references);

	ref_list = malloc(ref_list_size);

	if (ref_list == NULL) 
	{
	    perror("reading spelling reference list");
	    exit(1);
	}

	nwos_read_reference_list_from_disk(&spelling_header.object.references, ref_list, ref_list_size);

	num_spellings = (ref_list_size - sizeof(CommonHeader)) / sizeof(ObjRef);

	/* printf("num_spellings (in find_language): %d\n", num_spellings); */

	for (i = 0; i < num_spellings; i++)
	{
	    nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	    if (is_same_object(&object_class, &word_class_ref))   /* it is a word object, figure out if it is a language */
	    {
		nwos_read_object_from_disk(&ref_list->references[i], &word_obj, sizeof(word_obj));

		nwos_get_object_class(&word_obj.thing, &object_class);   /* find out what kind of object it is */

		if (is_same_object(&object_class, &lang_class_ref))
		{
		    memcpy(ref, &word_obj.thing, sizeof(ObjRef));
		    result = true;
		    break;
		}
	    }
	}

	free(ref_list);
	ref_list = NULL;
    }

    return result;
}


void nwos_create_english_language(ObjRef* ref)
{
    ObjRef lang_class_ref;
    C_struct_Language lang_obj;
    ObjRef word_ref;

    memset(&lang_obj, 0, sizeof(lang_obj));  /* zero it out */

    assert(nwos_find_class_definition("LANGUAGE", &lang_class_ref));

    nwos_generate_new_id(ref);

    nwos_fill_in_common_header(&lang_obj.header.common, ref, &lang_class_ref);

    nwos_create_reference_list(ref, &lang_obj.header.object.references);

    nwos_crc32_calculate((uint8*) &lang_obj.header.object, sizeof(ObjectHeader), lang_obj.header.common.header_chksum);

    nwos_crc32_calculate((uint8*) &lang_obj.definition, sizeof(lang_obj) - sizeof(EveryObject), lang_obj.header.common.data_chksum);

    nwos_write_object_to_disk(ref, &lang_obj, sizeof(lang_obj));

    nwos_add_to_references(ref, &lang_class_ref);

    nwos_create_word("English", ref, ref, &word_ref);
}


