/*
--                This file is part of the New World OS project
--                       Copyright (C) 2006 QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--
--  This program is free software; you can redistribute it and/or modify it 
--  under the terms of the GNU General Public License as published by the 
--  Free Software Foundation; either version 2 of the License, or (at your 
--  option) any later version.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
--  for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to:
--
--      Free Software Foundation, Inc.
--      51 Franklin Street, Fifth Floor
--      Boston, MA   02110-1301
--      USA
--
--  On the internet: http://www.fsf.org/licenses/gpl.html
--
-- $Log: domains.h,v $
-- Revision 1.4  2006/04/12 12:02:09  jsedwards
-- Added "descriptions" domain for objects that describe the definitions.
--
-- Revision 1.3  2006/04/09 14:47:10  jsedwards
-- Moved "definitions" subdomain to "nwos" domain and added "values" domain.
--
-- Revision 1.2  2006/04/09 03:28:45  jsedwards
-- Added NWOS attributes, logs and things definitions.
--
-- Revision 1.1  2006/03/26 15:29:33  jsedwards
-- Moved domain defintions out of predefined_references.h and into domains.h.
--
*/

#ifndef DOMAINS_H
#define DOMAINS_H

#define DOMAIN_NWOS         0x00
#define   DOMAIN_DEFINITIONS            (DOMAIN_NWOS+0x08)     /* conceptual defintion objects */
#define   DOMAIN_ATTRIBUTES             (DOMAIN_NWOS+0x04)
#define   DOMAIN_VALUES                 (DOMAIN_NWOS+0x0C)
#define   DOMAIN_DESCRIPTIONS           (DOMAIN_NWOS+0x02)
#define   DOMAIN_LOGS                   (DOMAIN_NWOS+0x0A)

#define DOMAIN_BINARY_CODES 0x20      /* opcodes, character codes, etc. - lower nibble is count 1-15, 0 = >15 */

#define DOMAIN_NUMBERS      0x40
#define   DOMAIN_CARDINAL_NUMBERS       (DOMAIN_NUMBERS+0x00)    /* plain old numbers 0, 1, ... */
#define   DOMAIN_ORDINAL_NUMBERS        (DOMAIN_NUMBERS+0x02)    /* first, second, third, ... */
#define   DOMAIN_DECIMAL_NUMBERS        (DOMAIN_NUMBERS+0x04)    /* fixed point decimal numbers */
#define   DOMAIN_RATIONAL_NUMBERS       (DOMAIN_NUMBERS+0x06)
#define   DOMAIN_IRRATIONAL_NUMBERS     (DOMAIN_NUMBERS+0x07)
#define   DOMAIN_COMPLEX_NUMBERS        (DOMAIN_NUMBERS+0x08)
#define   DOMAIN_SPECIALIZED_NUMBERS    (DOMAIN_NUMBERS+0x0E)    /* dates, phone, vin, isbn, etc. */

#define DOMAIN_THINGS       0x80


#if 0
#define DOMAIN_MACHINES     0x60
#define   DOMAIN_COMPUTERS    0x00

#define DOMAIN_PEOPLE       0x80

#define DOMAIN_LANGUAGE     0xA0

#define DOMAIN_MUSIC        0xC0
#endif

#define DOMAIN_PRIVATE      0xF0


#endif /* DOMAINS_H */

