/*             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: disc_list.c,v $
-- Revision 1.1  2006/11/19 13:53:12  jsedwards
-- Created "disc_list.c" from "log_disc.c".  This program just creates a disc
-- list and does not create a disc copy object.
--
-- Revision 1.6  2006/11/18 14:34:58  jsedwards
-- Changed so that discs can be stored in one of three different binders.
--
-- Revision 1.5  2006/11/11 12:01:04  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2006/11/07 14:03:35  jsedwards
-- Add assert to verify file_path didn't come back void.
--
-- Revision 1.3  2006/11/06 13:54:07  jsedwards
-- Changed wording in print statement because disc_list now stores the
-- references to the file_path object instead of the file object.
--
-- Revision 1.2  2006/11/05 21:32:18  jsedwards
-- Add code to create storage_location and disc_copy objects.
--
-- Revision 1.1  2006/11/04 18:56:22  jsedwards
-- Program to scan all the files on a CD or DVD and make a disk_list object
-- of it.
--
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "objectify.h"


extern void nwos_setup_file();


int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    ObjRef ref;
    ObjCreateResult result;
    int i;
    time_t start_time;
    char id[14];
    char *p;
    bool ok = false;
    ObjRef files[MAX_FILES_PER_DISC_LIST];
    ObjRef disc_list_ref;

    if (argc - 1 > MAX_FILES_PER_DISC_LIST)
    {
	fprintf(stderr, "Too many files specified, currently can only handle %u files max\n", (unsigned)MAX_FILES_PER_DISC_LIST);
	exit(1);
    }

    printf("\n");

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE, DEFAULT_FILE);

    nwos_set_root_object(&root_object_ref);

    nwos_setup_file();

    while (!ok)
    {
	printf("Disk id: ");
	fflush(stdout);

	fgets(id, sizeof(id), stdin);

	p = strchr(id, '\n');   /* find the newline char */

	if (p == NULL)    /* line was tool long */
	{
	    while (p == NULL) 
	    {
		fgets(id, sizeof(id), stdin);
		p = strchr(id, '\n');   /* find the newline char */
	    }
	    printf("id was too long, must be less than %zd characters\n", sizeof(id) - 2);
	}
	else     /* line was ok */
	{
	    *p = '\0';   /* eliminate the newline character */

	    if (strlen(id) < 12)
	    {
		printf("id was too short, must be %zd characters\n", sizeof(id) - 2);
	    }
	    else
	    {
		ok = true;   /* we should be good to go */
	    }
	}
    }

    if (nwos_find_disc_list(id, &ref))
    {
	printf("That disc already exists!\n");
	exit(1);
    }

    memset(files, 0, sizeof(files));

    for (i = 1; i < argc; i++)
    {
	start_time = time(NULL);

	if (nwos_find_file_path(argv[i], &files[i-1]))
	{
	    assert(nwos_check_file_md5sum(argv[i]));
	}
	else
	{
	    result = nwos_create_file_without_storing_data(argv[i], &files[i-1]);

	    assert(!is_void_reference(&files[i-1]));

	    if (result == CREATED_NEW)
	    {
		printf("created new file path: %02x%02x%02x%02x   time: %d seconds\n", 
		       files[i-1].id[0], files[i-1].id[1], files[i-1].id[2], files[i-1].id[3], 
		       (int) (time(NULL) - start_time));

	    }
	    else
	    {
		printf("result: %d\n", result);
	    }

	    nwos_flush_bit_maps();
	}
    }

    assert(nwos_create_disc_list(id, files, &disc_list_ref) == CREATED_NEW);

    printf("disc list: %02x%02x%02x%02x\n",
	   disc_list_ref.id[0], disc_list_ref.id[1], disc_list_ref.id[2], disc_list_ref.id[3]);

    nwos_terminate_objectify();

    return 0;
}


