--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: name.e,v $
-- Revision 1.13  2006/11/04 14:12:58  jsedwards
-- Added yet another kludge to convert Cd_List to CD_List.
--
-- Revision 1.12  2006/11/03 04:18:25  jsedwards
-- Add another kludge to convert md5sum to MD5sum.
--
-- Revision 1.11  2006/11/03 03:41:14  jsedwards
-- Add special kludge to convert classes that start with "US" so that both
-- letters are upper case (instead of "Us").
--
-- Revision 1.10  2006/11/03 02:41:05  jsedwards
-- Change to make first letters of each word of Class name capitalized.
--
-- Revision 1.9  2006/11/02 13:50:57  jsedwards
-- Added "make_from_csv" feature to create object from cvs line.
--
-- Revision 1.8  2006/10/31 23:24:38  jsedwards
-- Add code to add reference to objects that these objects reference.
--
-- Revision 1.7  2006/10/31 23:12:51  jsedwards
-- Add code to add each object to the class definition reference list.
--
-- Revision 1.6  2006/10/31 14:07:01  jsedwards
-- Added reference_lists.
--
-- Revision 1.5  2006/10/31 13:35:04  jsedwards
-- Fix previous log entry to say the right thing (accidentally checked in).
--
-- Revision 1.4  2006/10/31 13:31:15  jsedwards
-- Set reference when object is created and ensure not creating a duplicate.
--
-- Revision 1.3  2006/10/30 13:16:31  jsedwards
-- Changed name of "words" feature to "spellings" and add object itself to
-- "all_names" global array.
--
-- Revision 1.2  2006/10/30 12:27:38  jsedwards
-- Fixed several bugs, now appears to be somewhat working.
--
-- Revision 1.1  2006/10/30 03:21:40  jsedwards
-- Initial version, untested.
--


class NAME

inherit GLOBALS
        REFERENCE_COUNTER
        ANY
           redefine
              is_equal
           end

creation make, make_from_csv

feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   spellings: FIXED_ARRAY[SPELLING]

   name: STRING is
      local
         i: INTEGER
         size: INTEGER
      do
         if name_string = Void then
            from
               i := spellings.lower
            variant
               spellings.upper - i
            until
               i > spellings.upper
            loop
               size := size + spellings.item(i).spelling.count + 1
               i := i + 1
            end

            !!name_string.make(size)
         else
            name_string.clear
         end

         from
            i := spellings.lower
         variant
            spellings.upper - i
         until
            i > spellings.upper
         loop
            if i > spellings.lower then
               name_string.extend('_')
            end
            name_string.append(spellings.item(i).spelling)
            i := i + 1
         end

         Result := name_string
      end

   name_capitalized: STRING is
      local
         i: INTEGER
      do
         Result := name

         Result.put(Result.first.to_upper, 1)

         if Result.has_prefix("Us_") then
            Result.put(Result.item(2).to_upper, 2)
         end

         if Result.has_prefix("Cd_") then
            Result.put(Result.item(2).to_upper, 2)
         end

         if Result.has_prefix("Md5") then
            Result.put(Result.item(2).to_upper, 2)
         end

         from
            i := 2
         until
            i > Result.upper
         loop
            if Result.item(i) = '_' then
               i := i + 1
               Result.put(Result.item(i).to_upper, i)
            end
            i := i + 1
         end
      end

   is_equal(other: like Current): BOOLEAN is
      local
         i: INTEGER
      do
         if spellings.count = other.spellings.count then
            from
               i := spellings.lower
            variant
               spellings.upper - i
            until
               i > spellings.upper or else spellings.item(i) /= other.spellings.item(i)
            loop
               i := i + 1
            end

            Result := i > spellings.upper
         end
      end

   make(nm: STRING) is
      require
         nm.count > 0
         find_name(nm) = Void
      local
         tmp_str: STRING
         start: INTEGER
         i: INTEGER
         spell: SPELLING
      do
         reference := next_reference

         !!reference_list.make

         !!spellings.with_capacity(4)

         tmp_str := string_pool.item(nm.count)

         from
            i := nm.lower
            start := i
         variant
            nm.upper - i
         until
            i > nm.upper
         loop
            if nm.item(i) = '_' then
               tmp_str.copy_substring(nm, start, i - 1)
               start := i + 1
            elseif i = nm.upper then
               tmp_str.copy_substring(nm, start, i)
            end

            if tmp_str.count > 0 then
               spell := find_spelling(tmp_str)

               if spell = Void then
                  !!spell.make(tmp_str)
               end

               spell.reference_list.add_reference(reference)

               spellings.add_last(spell)

               tmp_str.clear
            end

            i := i + 1
         end

         all_names.add_last(Current)

         name_class_def.reference_list.add_reference(reference)

         string_pool.put(tmp_str)
      ensure
         name.same_as(nm)
      end


   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         !!spellings.with_capacity(4)

         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         from
         until
            line.is_empty
         loop
            check_comma(line)

            dummy := scan_reference(line)  -- read first spelling

            spellings.add_last(find_spelling_from_reference(dummy))
         end
      end



feature {NONE}

   name_string: STRING

end

