#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import unittest
from testsPath import *
from qt import *
from OBBFuncts import *
from OBBGui.Floater import Floater
from OBBGui.OBBWidget import OBBWidget
from OBBGui.PixmapSet import *
import sys
import os

class WidgetNoDefStateTest(unittest.TestCase):
    """ A Widget need a PixmapSet with it's default state"""
    def setUp(self):
        self.set = PixmapSet()

    def runTest(self):
        self.failUnlessRaises( StateError,
                               OBBWidget,
                               self.set )
    def tearDown(self):
        del(self.set)

class WidgetInitTest(unittest.TestCase):
    """ A Widget need a PixmapSet with it's default state"""
    def setUp(self):
        self.set = PixmapSet()
        self.set.addState( QPixmap(os.path.join(getImgDir(), "vholder.png")),
                           DISABLED )

    def runTest(self):
        widget = OBBWidget( self.set )
        self.failUnless( widget != None )

    def tearDown(self):
        del(self.set)

def suite():
    testSuite = unittest.TestSuite()
    testSuite.addTest(WidgetNoDefStateTest())
    testSuite.addTest(WidgetInitTest())
    return testSuite

if __name__ == "__main__":
    app = QApplication(sys.argv)

    runner = unittest.TextTestRunner()
    runner.run( suite() )

    kickApp(app)
