#!/usr/bin/python

#   Copyright (C) 2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from qt import PYSIGNAL

# doc
volumeChanged    = PYSIGNAL("volumeChanged(int)")
tempoChanged     = PYSIGNAL("tempoChanged(int)")
patFileChanged   = PYSIGNAL("patFileChanged(str, userSelected)")
instrBalChanged  = PYSIGNAL("instrBalChanged(int, int)")  # (instrId, balValue)
instrFileChanged = PYSIGNAL("instrFileChanged(int, str)") # (instrId, newFile)
hitToggled       = PYSIGNAL("hitToggled(int, int)")       # (instrId, hitPos)
hitPlayed        = PYSIGNAL("hitPlayed(int)")
sampleCreated    = PYSIGNAL("sampleCreated()")

# view
newFile       = PYSIGNAL("newFile()")
newTempo      = PYSIGNAL("newTempo(int)")
newPatVolume  = PYSIGNAL("newPatternVolume(int)")
newInstrBal   = PYSIGNAL("newInstrBalance(int, int)")  # (instrId, balValue)
newInstrFile  = PYSIGNAL("newInstrFilename(int, str)") # (instrId, newFile)
loadPattern   = PYSIGNAL("loadPattern(str)")
savePattern   = PYSIGNAL("savePattern(str)")

play          = PYSIGNAL("play()")
stop          = PYSIGNAL("stop()")
quit          = PYSIGNAL("quit()")
scroll        = PYSIGNAL("scroll()")
clearHits     = PYSIGNAL("clearHits()")
previewInstr  = PYSIGNAL("previewInstr(int)")
