#   Copyright (C) 2002-2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002-2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from os import access, R_OK
from OBBInstrument import *

class OBBOrchestra:
    def __init__(self):
        self.instrumentsList = {}

    def get(self):
        return self.instrumentsList

    def set(self, patternId, sampleName):
        if access(sampleName, R_OK):
            if patternId in self.instrumentsList:
                self.instrumentsList[patternId].setFilePath(sampleName)
            else:
                self.instrumentsList[patternId] = OBBInstrument(sampleName)

        else:
            raise Exception( "Read access denied or file doesn't exist: \"" + sampleName + "\"" )

    def delete(self, patternId):
        if patternId in self.instrumentsList:
            del self.instrumentsList[patternId]
        else:
            raise Exception( "Instrument %d not found." % (patternId+1) )

    def isEmpty(self):
        return len(self.instrumentsList) == 0

if __name__ == "__main__":
     Orch = OBBOrchestra()
     Orch.set(0, "../../sounds/hat03.wav")
     Orch.set(0, "../../sounds/hat02.wav")
     Orch.set(1, "../../sounds/hat03.wav")
     for i in Orch.get():
        print Orch.get()[i].getPlayFilePath()
     Orch.set(1, "../../sounds/hat03.wav")
     print "------"
     Orch.delete(1)
     for i in Orch.get():
        print Orch.get()[i].getPlayFilePath()
