from qt import *

#   Copyright (C) 2002-2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002-2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


class OBBGui(QObject):
    def __init__(self, parent=None):
        QObject.__init__(self, parent)
        self.__floaters = []


    def show(self):
        for floater, visible in self.__floaters:
            if visible:
                floater.show()


    def addFloater(self, floater, visible=1):
        floater.hide()
        self.__floaters.append((floater, visible))


    def getFloaters(self):
        return self.__floaters # Yes, all of them, in-place ! : )  Why not ?
        

    def beMainWidget(self):
        return self.__floaters[-1][0]
