#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from os                import *
from qt                import *
from soundPath         import *
from OBBCSoundTorturer import *
from OBBSongDocument   import *

class OBBSongCreator(QObject):
    def __init__(self, parent=None):
        QObject.__init__(self, parent)
        self.hitPerCycle = 16
        self.hitPerRecorderCall = 2
        self.recorder = OBBCSoundTorturer()

    def newSongDocument(self, bpm = 240):
        self.doc = OBBSongDocument(bpm)

    def setHitPerCycle(self, hitPerCycle):
        self.hitPerCycle = hitPerCycle

    def setInstrument(self, samplePattern, sampleName):
        self.doc.songOrchestra.set(samplePattern, sampleName)

    def removeInstrument(self):
        self.doc.songOrchestra.delete(samplePattern)

    def getInstrument(self, samplePattern):
        return self.doc.getInstrument(samplePattern).getPlayFilePath()
        
    def setPanning(self, samplePattern, panValue):
        self.doc.getInstrument(samplePattern).setPanning(panValue)

    def getPanning(self, samplePattern):
        self.doc.getInstrument(samplePattern).getPanning()

    def addHit(self, hitPattern, hitPosition):
        self.doc.songScore.Add( hitPattern,
                                    hitPosition )


    def removeHit(self, hitPattern, hitPosition):
        self.doc.songScore.Delete( hitPattern,
                                       hitPosition )


    def toggleHit(self, hitPattern, hitPosition):
        if self.doc.songScore.isIn( hitPattern,
                                        hitPosition ):
            self.removeHit(hitPattern, hitPosition)
        else:
            self.addHit(hitPattern, hitPosition)
        self.doc.songScore.printScore()

    def setTempo(self, newValue):
        self.doc.setTempo(newValue)

    def getTempo(self):
        return self.doc.getTempo()

    def makeSample(self, hitId = -1, length = 16):
        #Sould always validate used synthetisor
        #before proceeding with advanced sample
        #creation
        #                             --VBarbin
        if not self.doc.songScore.isEmpty():
            self.recorder.createOrchestraFile(self.doc)
            if self.recorder.createScoreFile(self.doc, (hitId + 1) % self.hitPerCycle, length):
                self.doc.setSample(self.recorder.createWaveFile())
                self.emit(PYSIGNAL("createSample()"), (self.doc,))
                return self.doc.samplePath

    def handleSongChange(self, patternId, hitId):
        self.toggleHit(patternId, hitId)


    def handleHit(self, hitId):
        if hitId % self.hitPerRecorderCall == self.hitPerRecorderCall - 1:
            self.makeSample(hitId, self.hitPerRecorderCall)
            
    def handleInstrumentVolume(self, paternId, volume):
        self.doc.getInstrument(paternId).setVolume(volume)
        self.doc.getInstrument(paternId).refreshSample()

    def handleInstrumentEffects():
        pass

    def cleanUpTemporaryFiles(self):
        self.doc.removeSample()
        for instr in self.doc.songOrchestra.get():
            self.doc.getInstrument(instr).deleteTempSampleFile()
